/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.yarn.conf;

import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.conf.Configuration;
import shaded.org.apache.hadoop.util.ReflectionUtils;
import shaded.org.apache.hadoop.yarn.conf.ConfigurationProvider;
import shaded.org.apache.hadoop.yarn.exceptions.YarnRuntimeException;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ConfigurationProviderFactory {
    public static ConfigurationProvider getConfigurationProvider(Configuration bootstrapConf) {
        Class<?> defaultProviderClass;
        try {
            defaultProviderClass = Class.forName("shaded.org.apache.hadoop.yarn.LocalConfigurationProvider");
        }
        catch (Exception e) {
            throw new YarnRuntimeException("Invalid default configuration provider classorg.apache.hadoop.yarn.LocalConfigurationProvider", e);
        }
        ConfigurationProvider configurationProvider = ReflectionUtils.newInstance(bootstrapConf.getClass("yarn.resourcemanager.configuration.provider-class", defaultProviderClass, ConfigurationProvider.class), bootstrapConf);
        return configurationProvider;
    }
}

