/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pdc.core.ehcache;

import com.ibm.cognos.pdc.core.ehcache.CacheManagerDelegate;
import com.ibm.cognos.pdc.core.ehcache.DefaultCacheManagerDelegate;
import com.ibm.cognos.pdc.core.ehcache.config.ConfigLifeCycleManager;
import com.ibm.cognos.pdc.core.ehcache.config.ConfigProperties;
import com.ibm.cognos.pdc.core.ehcache.config.EhCacheConfigurationException;
import com.ibm.cognos.pdc.core.ehcache.config.EhCacheManagerConfigBuilder;
import com.ibm.cognos.pdc.core.ehcache.pogo.LogKitFactory;
import com.ibm.cognos.pdc.core.ehcache.rmi.CAMFactoryRMISocketFactory;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.rmi.server.RMISocketFactory;
import javax.management.MBeanServer;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.management.ManagementService;
import org.apache.log.Logger;
import sun.rmi.server.LoaderHandler;

public class CacheManagerProvider {
    private static final Logger LOGGER = LogKitFactory.getLogger(CacheManagerProvider.class);
    private static final CacheManagerProvider INSTANCE = new CacheManagerProvider();
    private static boolean rmiSocketFactoryInitialized = false;
    private final CAMFactoryRMISocketFactory camFactory;
    private CacheManager cacheManager;
    private CacheManagerDelegate cacheManagerDelegate;
    private EhCacheManagerConfigBuilder ehConfigBuilder;
    private ConfigLifeCycleManager configManager;

    public static CacheManagerProvider getInstance() {
        return INSTANCE;
    }

    protected CacheManagerProvider() {
        this(CAMFactoryRMISocketFactory.getInstance(), EhCacheManagerConfigBuilder.getInstance(), ConfigLifeCycleManager.getInstance());
    }

    protected CacheManagerProvider(CAMFactoryRMISocketFactory camFactory, EhCacheManagerConfigBuilder ehConfigBuilder, ConfigLifeCycleManager configManager) {
        this.camFactory = camFactory;
        this.ehConfigBuilder = ehConfigBuilder;
        this.configManager = configManager;
    }

    public synchronized CacheManagerDelegate getCacheManager() {
        if (this.cacheManagerDelegate == null) {
            this.registerClassLoader();
            this.initRMISocketFactory();
            this.cacheManager = this.newCacheManager();
            this.cacheManagerDelegate = new DefaultCacheManagerDelegate(this.cacheManager);
            this.registerMBeans();
        }
        return this.cacheManagerDelegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CacheManager newCacheManager() {
        CacheManager manager;
        block6: {
            LOGGER.info("Creating new CacheManager...");
            manager = null;
            try {
                manager = new CacheManager(this.ehConfigBuilder.getConfiguration(this.configManager));
            }
            catch (Exception e) {
                LOGGER.debug("Failed to create CacheManager with default configuration", (Throwable)e);
                boolean replicationEnabled = this.getConfigBoolean("com.ibm.cognos.pdc.config.enableReplication", false);
                if (replicationEnabled) {
                    this.setConfigBoolean("com.ibm.cognos.pdc.config.enableReplication", false);
                    manager = new CacheManager(this.ehConfigBuilder.getConfiguration(this.configManager));
                    LOGGER.warn("CacheManager created but replication has been disabled: " + e.getMessage());
                    break block6;
                }
                throw new EhCacheConfigurationException(e);
            }
            finally {
                LOGGER.info("Returning CacheManager: " + manager);
            }
        }
        return manager;
    }

    private void registerClassLoader() {
        LoaderHandler.registerCodebaseLoader(this.getClass().getClassLoader());
    }

    private void registerMBeans() {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        ManagementService.registerMBeans((CacheManager)this.cacheManager, (MBeanServer)mBeanServer, (boolean)false, (boolean)false, (boolean)false, (boolean)true);
    }

    private void initRMISocketFactory() {
        if (rmiSocketFactoryInitialized) {
            return;
        }
        try {
            boolean enableReplication = this.getConfigBoolean("com.ibm.cognos.pdc.config.enableReplication", false);
            boolean useSSL = this.getConfigBoolean("com.ibm.cognos.pdc.config.useSSL", true);
            if (enableReplication && useSSL) {
                this.camFactory.initialize(useSSL);
                LOGGER.info("installing CAMFactoryRMISocketFactory as the RMISocketFactory");
                RMISocketFactory.setSocketFactory(this.camFactory);
                rmiSocketFactoryInitialized = true;
            }
        }
        catch (IOException e) {
            throw new EhCacheConfigurationException(e);
        }
    }

    private boolean getConfigBoolean(String key, boolean defaultValue) {
        ConfigProperties configProps = this.configManager.getConfigProps();
        Boolean value = (Boolean)configProps.get(key);
        return value != null ? value : defaultValue;
    }

    private void setConfigBoolean(String key, boolean b) {
        ConfigProperties configProps = this.configManager.getConfigProps();
        configProps.put(key, b);
    }
}

