/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pdc.core.ehcache;

import com.ibm.cognos.pdc.core.ehcache.CognosCacheManagerPeerListener;
import com.ibm.cognos.pdc.core.ehcache.config.ConfigLifeCycleManager;
import com.ibm.cognos.pdc.core.ehcache.pogo.LogKitFactory;
import com.ibm.cognos.pdc.core.ehcache.rmi.CAMFactoryRMISocketFactory;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.distribution.CacheManagerPeerListener;
import net.sf.ehcache.distribution.RMICacheManagerPeerListenerFactory;
import org.apache.log.Logger;

public class CognosCacheManagerPeerListenerFactory
extends RMICacheManagerPeerListenerFactory {
    private static final Logger LOGGER = LogKitFactory.getLogger(CognosCacheManagerPeerListenerFactory.class);
    private final CAMFactoryRMISocketFactory socketFactory;
    private final ConfigLifeCycleManager configManager;

    public CognosCacheManagerPeerListenerFactory() {
        this(CAMFactoryRMISocketFactory.getInstance(), ConfigLifeCycleManager.getInstance());
    }

    protected CognosCacheManagerPeerListenerFactory(CAMFactoryRMISocketFactory socketFactory, ConfigLifeCycleManager configManager) {
        this.socketFactory = socketFactory;
        this.configManager = configManager;
    }

    protected CacheManagerPeerListener doCreateCachePeerListener(String host, Integer port, Integer remoteObjectPort, CacheManager cacheManager, Integer soTimeout) {
        try {
            String cognosHost = this.resolveHost(host);
            LOGGER.debug("doCreateCachePeerListener: " + cognosHost + ", port " + port);
            return new CognosCacheManagerPeerListener(cognosHost, this.registerPort(port), this.registerPort(remoteObjectPort), cacheManager, soTimeout);
        }
        catch (UnknownHostException e) {
            throw new CacheException((Throwable)e);
        }
    }

    private String resolveHost(String host) {
        String cognosHost = host;
        if (cognosHost == null) {
            cognosHost = this.configManager.getLocalDispatcher().getHost();
        }
        return cognosHost;
    }

    private Integer registerPort(int port) {
        int registeredPort = port;
        if (registeredPort == 0) {
            ServerSocket serverSocket = null;
            try {
                serverSocket = new ServerSocket(0);
                registeredPort = serverSocket.getLocalPort();
                if (serverSocket.isBound()) {
                    serverSocket.close();
                }
            }
            catch (IOException e) {
                throw new CacheException((Throwable)e);
            }
        }
        this.socketFactory.registerLocalPort(registeredPort);
        return registeredPort;
    }
}

