/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pdc.core.ehcache;

import com.ibm.cognos.pdc.core.ehcache.CacheManagerDelegate;
import com.ibm.cognos.pdc.core.ehcache.CognosCacheManagerPeerListener;
import com.ibm.cognos.pdc.core.ehcache.CognosCacheManagerPeerProvider;
import com.ibm.cognos.pdc.core.ehcache.EhPDCMBean;
import com.ibm.cognos.pdc.core.ehcache.rmi.RMIEndpoint;
import java.util.Iterator;

public class DefaultEhPDCMBean
implements EhPDCMBean {
    private final CacheManagerDelegate cacheManager;
    private final int listenerPort;
    private final int rmiPort;

    public DefaultEhPDCMBean(CacheManagerDelegate cacheManager) {
        this.cacheManager = cacheManager;
        CognosCacheManagerPeerListener listener = (CognosCacheManagerPeerListener)cacheManager.getCachePeerListener("RMI");
        this.listenerPort = listener != null ? listener.getPort() : -1;
        this.rmiPort = listener != null ? listener.getRemoteObjectPort() : -1;
    }

    @Override
    public int getListenerPort() {
        return this.listenerPort;
    }

    @Override
    public int getRMIPort() {
        return this.rmiPort;
    }

    @Override
    public String getPeerList() {
        StringBuilder sb = new StringBuilder("[");
        CognosCacheManagerPeerProvider provider = (CognosCacheManagerPeerProvider)this.cacheManager.getCacheManagerPeerProvider("RMI");
        if (provider != null) {
            Iterator<RMIEndpoint> peersIterator = provider.getRMIPeers().iterator();
            while (peersIterator.hasNext()) {
                RMIEndpoint peer = peersIterator.next();
                sb.append(peer.getRmiBaseUri());
                if (!peersIterator.hasNext()) continue;
                sb.append(", ");
            }
        }
        return sb.append("]").toString();
    }
}

