/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pdc.core.ehcache;

import com.ibm.cognos.pdc.CacheException;
import com.ibm.cognos.pdc.core.AbstractCountersCacheMap;
import com.ibm.cognos.pdc.core.PDCLogging;
import com.ibm.cognos.pdc.core.TransactionAlreadyActiveException;
import com.ibm.cognos.pdc.core.ehcache.EhSession;
import java.util.Iterator;
import java.util.logging.Level;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;

public class EhCacheMap
extends AbstractCountersCacheMap {
    private final Cache cache;

    public EhCacheMap(Cache cache, EhSession parent) {
        this.cache = cache;
    }

    public void clearImpl() throws CacheException, TransactionAlreadyActiveException {
        this.cache.removeAll();
    }

    public boolean containsKeyImpl(Object key) throws CacheException {
        return this.cache.isKeyInCache(key);
    }

    public Object getImpl(Object key) throws CacheException {
        Object value;
        Element cacheElement = this.cache.get(key);
        Object object = value = cacheElement != null ? cacheElement.getObjectValue() : null;
        if (PDCLogging.PDC_TRACE.isLoggable(Level.FINER)) {
            PDCLogging.PDC_TRACE.finer(this.getName() + " get(" + key + ") returned " + value);
        }
        return value;
    }

    public String getName() {
        return this.cache.getName();
    }

    public Object putImpl(Object key, Object value) throws CacheException {
        if (PDCLogging.PDC_TRACE.isLoggable(Level.FINER)) {
            PDCLogging.PDC_TRACE.finer(this.getName() + " put(" + key + ") value=" + value);
        }
        this.cache.put(new Element(key, value));
        return value;
    }

    public Object removeImpl(Object key) throws CacheException {
        Element element;
        if (PDCLogging.PDC_TRACE.isLoggable(Level.FINER)) {
            PDCLogging.PDC_TRACE.finer(this.getName() + " remove(" + key + ")");
        }
        return (element = this.cache.removeAndReturnElement(key)) != null ? element.getObjectValue() : null;
    }

    public Iterator<Object> getKeys() throws CacheException {
        return this.cache.getKeys().iterator();
    }
}

