/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pdc.core.ehcache.config;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.ibm.cognos.pdc.core.ehcache.config.ConfigProperties;
import com.ibm.cognos.pdc.core.ehcache.config.EhCacheConfigurationException;
import com.ibm.cognos.pdc.core.ehcache.pogo.LogKitFactory;
import org.apache.log.Logger;
import org.dom4j.Element;
import org.dom4j.Node;

public class CCLConfigParser {
    private static final Logger LOGGER = LogKitFactory.getLogger(CCLConfigParser.class);
    private static final String XPATH_PARAMETER_FORMAT = "./*[local-name()='parameter'][@name='%s']/*[local-name()='value']/text()";
    private static final String XPATH_ADVPROP_FORMAT = "./*[local-name()='parameter'][@name='advancedProperties']/*[local-name()='value']/*[local-name()='parameter'][@name='%s']/*[local-name()='value']/text()";
    private ConfigProperties configProps = new ConfigProperties();

    public void parse(ICCLConfiguration cclConfig) {
        LOGGER.debug("Parsing CCL configuration");
        try {
            Element element = cclConfig.getValueElement("Replication", false);
            this.parseBoolean(element, "pdcEnableReplication", "com.ibm.cognos.pdc.config.enableReplication", false);
            this.parseInteger(element, "pdcPeerPort", "com.ibm.cognos.pdc.config.peerPort", 0);
            this.parseInteger(element, "pdcRMIPort", "com.ibm.cognos.pdc.config.rmiPort", 0);
            this.parseEnableSSLFlag(element, "pdcUseSSL", "com.ibm.cognos.pdc.config.useSSL", true);
        }
        catch (CCLConfigurationException e) {
            LOGGER.error("Failed to parse CCL configuration", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (EhCacheConfigurationException e) {
            LOGGER.error("Failed to parse CCL configuration", (Throwable)e);
            throw e;
        }
    }

    private String getStringValue(Element element, String paramName) {
        return this.getStringValue(XPATH_PARAMETER_FORMAT, element, paramName);
    }

    private String getStringValue(String xpathFormat, Element element, String paramName) {
        Node paramTextNode;
        String xpath = String.format(xpathFormat, paramName);
        String stringValue = element != null ? ((paramTextNode = element.selectSingleNode(xpath)) == null ? null : paramTextNode.getStringValue()) : null;
        return stringValue;
    }

    private void parseBoolean(Element element, String paramName, String mapKey, boolean defaultValue) {
        String stringValue = this.getStringValue(element, paramName);
        boolean value = stringValue != null ? Boolean.parseBoolean(stringValue) : defaultValue;
        this.configProps.put(mapKey, value);
    }

    private void parseEnableSSLFlag(Element element, String paramName, String mapKey, boolean defaultValue) {
        String stringValue = this.getStringValue(XPATH_ADVPROP_FORMAT, element, paramName);
        boolean value = !"false".equalsIgnoreCase(stringValue);
        this.configProps.put(mapKey, value);
    }

    private void parseInteger(Element element, String paramName, String mapKey, int defaultValue) {
        String stringValue = this.getStringValue(element, paramName);
        int value = defaultValue;
        if (stringValue != null) {
            try {
                value = Integer.parseInt(stringValue.trim());
            }
            catch (NumberFormatException e) {
                throw new EhCacheConfigurationException("Invalid parameter format - " + paramName + ":" + stringValue);
            }
        }
        this.configProps.put(mapKey, value);
    }

    public ConfigProperties getConfigProperties() {
        return this.configProps;
    }
}

