/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pdc.core.ehcache.config;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.ibm.cognos.pdc.core.ehcache.config.CCLConfigParser;
import com.ibm.cognos.pdc.core.ehcache.config.ConfigFileLoader;
import com.ibm.cognos.pdc.core.ehcache.config.ConfigProperties;
import com.ibm.cognos.pdc.core.ehcache.config.DOM4JConfigFileLoader;
import com.ibm.cognos.pdc.core.ehcache.config.ResourceLoader;
import com.ibm.cognos.pdc.core.ehcache.config.bean.PDCBean;
import com.ibm.cognos.pdc.core.ehcache.config.bean.PDCCacheBean;
import com.ibm.cognos.pdc.core.ehcache.config.bean.PDCGridBean;
import com.ibm.cognos.pdc.core.ehcache.pogo.PDCDispatcher;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ConfigLifeCycleManager {
    private static final ConfigLifeCycleManager INSTANCE = new ConfigLifeCycleManager();
    private final ConfigFileLoader configFileLoader;
    private PDCBean pdcConfig;
    private PDCGridBean[] pdcGridConfigs;
    private Map<String, PDCCacheBean> pdcCacheMap;
    private ConfigProperties configProps;
    private PDCDispatcher localDispatcher;

    public static ConfigLifeCycleManager getInstance() {
        return INSTANCE;
    }

    public ConfigLifeCycleManager() {
        this(DOM4JConfigFileLoader.getInstance());
    }

    protected ConfigLifeCycleManager(ConfigFileLoader configFileLoader) {
        this.configFileLoader = configFileLoader;
        this.pdcConfig = new PDCBean();
        this.pdcGridConfigs = new PDCGridBean[0];
        this.pdcCacheMap = Collections.emptyMap();
        this.configProps = new ConfigProperties();
        this.localDispatcher = new StubPDCDispatcher();
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.configFileLoader.setResourceLoader(resourceLoader);
    }

    public void setLocalDispatcher(PDCDispatcher dispatcher) {
        this.localDispatcher = dispatcher;
    }

    public void initialize() {
        this.pdcConfig = this.configFileLoader.getPDCConfig();
        this.pdcGridConfigs = this.configFileLoader.getPDCGridConfigs();
        this.pdcCacheMap = this.buildCacheMap(this.pdcGridConfigs);
    }

    private Map<String, PDCCacheBean> buildCacheMap(PDCGridBean[] pdcGridConfigs) {
        HashMap<String, PDCCacheBean> cacheMap = new HashMap<String, PDCCacheBean>();
        for (PDCGridBean gridConfig : pdcGridConfigs) {
            for (PDCCacheBean cacheConfig : gridConfig.getCaches()) {
                String fullCacheName = gridConfig.getName() + "." + cacheConfig.getName();
                cacheMap.put(fullCacheName, cacheConfig);
            }
        }
        return cacheMap;
    }

    public PDCDispatcher getLocalDispatcher() {
        return this.localDispatcher;
    }

    public PDCBean getPDCConfig() {
        return this.pdcConfig;
    }

    public PDCGridBean[] getPDCGridConfigs() {
        return this.pdcGridConfigs;
    }

    public PDCCacheBean getPDCCacheConfig(String cacheName) {
        return this.pdcCacheMap.get(cacheName);
    }

    public void parseCCLConfiguration(ICCLConfiguration icclConfiguration) {
        CCLConfigParser cclConfigParser = new CCLConfigParser();
        cclConfigParser.parse(icclConfiguration);
        this.configProps = cclConfigParser.getConfigProperties();
    }

    public ConfigProperties getConfigProps() {
        return this.configProps;
    }

    private final class StubPDCDispatcher
    implements PDCDispatcher {
        private StubPDCDispatcher() {
        }

        @Override
        public boolean isLocalDispatcher() {
            return true;
        }

        @Override
        public boolean isAvailable() {
            return false;
        }

        @Override
        public int getListenerPort() {
            return -1;
        }

        @Override
        public int getRMIPort() {
            return -1;
        }

        @Override
        public String getHost() {
            return "localhost";
        }

        @Override
        public Set<String> getServices() {
            return Collections.emptySet();
        }

        @Override
        public void addService(String service) {
        }
    }
}

