/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pdc.core.ehcache.config;

import com.ibm.cognos.pdc.core.ehcache.config.ConfigFileLoader;
import com.ibm.cognos.pdc.core.ehcache.config.ResourceLoader;
import com.ibm.cognos.pdc.core.ehcache.config.bean.PDCBean;
import com.ibm.cognos.pdc.core.ehcache.config.bean.PDCCacheBean;
import com.ibm.cognos.pdc.core.ehcache.config.bean.PDCElementBean;
import com.ibm.cognos.pdc.core.ehcache.config.bean.PDCGridBean;
import com.ibm.cognos.pdc.core.ehcache.pogo.LogKitFactory;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.log.Logger;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class DOM4JConfigFileLoader
implements ConfigFileLoader {
    private static final Logger LOGGER = LogKitFactory.getLogger(DOM4JConfigFileLoader.class);
    private static final DOM4JConfigFileLoader INSTANCE = new DOM4JConfigFileLoader();
    private ResourceLoader resourceLoader;

    public static DOM4JConfigFileLoader getInstance() {
        return INSTANCE;
    }

    @Override
    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    @Override
    public PDCBean getPDCConfig() {
        try {
            InputStream in = this.resourceLoader.getResourceAsStream("pdc.xml");
            SAXReader reader = new SAXReader();
            Document doc = reader.read(in);
            PDCBean pdcConfig = new PDCBean();
            pdcConfig.setName(doc.selectSingleNode("/pdc/@name").getStringValue());
            PDCElementBean elementConfig = this.extractElementConfig((Node)doc, "/pdc/peerProviderFactory");
            if (elementConfig != null) {
                pdcConfig.setPeerProviderFactory(elementConfig);
            }
            if ((elementConfig = this.extractElementConfig((Node)doc, "/pdc/peerListenerFactory")) != null) {
                pdcConfig.setPeerListenerFactory(elementConfig);
            }
            return pdcConfig;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public PDCGridBean[] getPDCGridConfigs() {
        ArrayList<PDCGridBean> gridConfigs = new ArrayList<PDCGridBean>();
        Set<String> resourcePaths = this.resourceLoader.getResourcePaths();
        for (String path : resourcePaths) {
            if (!this.isGridConfigFile(path)) continue;
            InputStream in = this.resourceLoader.getResourceAsStream(path);
            SAXReader reader = new SAXReader();
            Document doc = null;
            try {
                doc = reader.read(in);
                PDCGridBean gridConfig = new PDCGridBean();
                gridConfig.setName(doc.selectSingleNode("/pdcGrid/@name").getStringValue());
                List caches = doc.selectNodes("/pdcGrid/pdcCache");
                gridConfig.setCaches(this.getPDCCacheConfigs(gridConfig, caches));
                gridConfigs.add(gridConfig);
            }
            catch (Exception e) {
                LOGGER.error("Unable to parse grid config '" + path + "'", (Throwable)e);
            }
        }
        return gridConfigs.toArray(new PDCGridBean[gridConfigs.size()]);
    }

    protected boolean isGridConfigFile(String path) {
        boolean excluded = "pdc.xml".equals(path) || !path.endsWith(".xml");
        return !excluded;
    }

    protected List<PDCCacheBean> getPDCCacheConfigs(PDCGridBean gridConfig, List<Node> caches) {
        ArrayList<PDCCacheBean> cacheConfigs = new ArrayList<PDCCacheBean>();
        for (Node cache : caches) {
            PDCCacheBean cacheConfig = new PDCCacheBean();
            this.extractAttributes(cache, cacheConfig);
            PDCElementBean elementConfig = this.extractElementConfig(cache, "./cacheEventListenerFactory");
            if (elementConfig != null) {
                cacheConfig.setCacheEventListenerFactory(elementConfig);
            }
            if ((elementConfig = this.extractElementConfig(cache, "./bootstrapCacheLoaderFactory")) != null) {
                cacheConfig.setBootstrapCacheLoaderFactory(elementConfig);
            }
            cacheConfigs.add(cacheConfig);
        }
        return cacheConfigs;
    }

    protected PDCElementBean extractElementConfig(Node node, String xpath) {
        return this.extractElementConfig(node.selectSingleNode(xpath));
    }

    protected PDCElementBean extractElementConfig(Node node) {
        Element e;
        List attributes;
        PDCElementBean elementConfig = null;
        if (node != null && (attributes = (e = (Element)node).attributes()).size() > 0) {
            elementConfig = new PDCElementBean();
            for (Attribute attribute : attributes) {
                elementConfig.setAttribute(attribute.getName(), attribute.getValue());
            }
        }
        return elementConfig;
    }

    protected void extractAttributes(Node node, PDCElementBean elementConfig) {
        Element e = (Element)node;
        List attributes = e.attributes();
        for (Attribute attribute : attributes) {
            elementConfig.setAttribute(attribute.getName(), attribute.getValue());
        }
    }

    @Override
    public boolean hasPDCGrid(String gridName) {
        return this.resourceLoader.getResourcePaths().contains(gridName + ".xml");
    }
}

