/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pdc.core.ehcache.config;

import com.ibm.cognos.pdc.core.ehcache.config.ConfigFileLoader;
import com.ibm.cognos.pdc.core.ehcache.config.ResourceLoader;
import com.ibm.cognos.pdc.core.ehcache.config.bean.PDCBean;
import com.ibm.cognos.pdc.core.ehcache.config.bean.PDCGridBean;
import com.ibm.cognos.pdc.core.ehcache.pogo.LogKitFactory;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.log.Logger;

public class JAXBConfigFileLoader
implements ConfigFileLoader {
    private static final Logger LOGGER = LogKitFactory.getLogger(JAXBConfigFileLoader.class);
    private static final JAXBConfigFileLoader INSTANCE = new JAXBConfigFileLoader();
    private ResourceLoader resourceLoader;
    private JAXBContext jaxbContext;

    public static JAXBConfigFileLoader getInstance() {
        return INSTANCE;
    }

    protected JAXBConfigFileLoader() {
        try {
            this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{PDCBean.class, PDCGridBean.class});
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    @Override
    public PDCBean getPDCConfig() {
        try {
            InputStream in = this.resourceLoader.getResourceAsStream("pdc.xml");
            Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
            PDCBean pdcConfig = (PDCBean)unmarshaller.unmarshal(in);
            return pdcConfig;
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public PDCGridBean[] getPDCGridConfigs() {
        ArrayList<PDCGridBean> configs = new ArrayList<PDCGridBean>();
        Set<String> resourcePaths = this.resourceLoader.getResourcePaths();
        for (String path : resourcePaths) {
            InputStream in;
            if (!this.isGridConfigFile(path) || (in = this.resourceLoader.getResourceAsStream(path)) == null) continue;
            this.unmarshallStream(configs, path, in);
        }
        return configs.toArray(new PDCGridBean[configs.size()]);
    }

    private void unmarshallStream(ArrayList<PDCGridBean> configs, String path, InputStream in) {
        try {
            Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
            configs.add((PDCGridBean)unmarshaller.unmarshal(in));
        }
        catch (JAXBException e) {
            LOGGER.error("Unable to parse grid config '" + path + "'", (Throwable)e);
        }
    }

    protected boolean isGridConfigFile(String path) {
        boolean excluded = "pdc.xml".equals(path) || !path.endsWith(".xml");
        return !excluded;
    }

    @Override
    public boolean hasPDCGrid(String gridName) {
        return this.resourceLoader.getResourcePaths().contains(gridName + ".xml");
    }
}

