/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pdc.core.ehcache.config;

import com.ibm.cognos.pdc.core.ehcache.config.EhCacheConfigurationException;
import com.ibm.cognos.pdc.core.ehcache.pogo.LogKitFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.log.Logger;

class SetterHelper {
    private static final Logger LOGGER = LogKitFactory.getLogger(SetterHelper.class);
    private final Map<String, Member> memberCache = new HashMap<String, Member>();
    private final Map<String, Method> settersMap = new HashMap<String, Method>();
    private final Class<?> classWithSetters;

    public SetterHelper(Class<?> classWithSetters) {
        this.classWithSetters = classWithSetters;
        this.initialize();
    }

    private void initialize() {
        Method[] methods;
        try {
            this.memberCache.put("int", SetterHelper.getValueOfMethod(Integer.class));
            this.memberCache.put("boolean", SetterHelper.getValueOfMethod(Boolean.class));
            this.memberCache.put("String", SetterHelper.getConstructor(String.class));
            this.memberCache.put("long", SetterHelper.getValueOfMethod(Long.class));
            this.memberCache.put("double", SetterHelper.getValueOfMethod(Double.class));
        }
        catch (Exception e) {
            throw new EhCacheConfigurationException(e);
        }
        for (Method m : methods = this.classWithSetters.getMethods()) {
            if (m.getParameterTypes().length != 1 || !m.getReturnType().equals(Void.TYPE)) continue;
            this.settersMap.put(m.getName().toLowerCase(), m);
            this.settersMap.put(m.getName().replaceFirst("set", "").toLowerCase(), m);
        }
    }

    public void invokeSetter(Object object, String methodName, String attributeValue) {
        Method method = this.settersMap.get(methodName.toLowerCase());
        if (method != null) {
            try {
                LOGGER.debug("invoking setter " + method.getName() + " with: " + attributeValue);
                Class<?> type0 = method.getParameterTypes()[0];
                Object setterValue = this.getValueForSetter(type0, attributeValue);
                method.invoke(object, setterValue);
            }
            catch (Exception e) {
                LOGGER.warn("Cannot set property: " + methodName, (Throwable)e);
            }
        }
    }

    private Object getValueForSetter(Class<?> type, String attributeValue) throws Exception {
        Object value;
        if (type.isAssignableFrom(String.class)) {
            value = attributeValue;
        } else {
            Member member = this.lookupSetterOrConstructor(type);
            if (member instanceof Method) {
                Method method = (Method)member;
                value = method.invoke(null, attributeValue);
            } else if (member instanceof Constructor) {
                Constructor constructor = (Constructor)member;
                value = constructor.newInstance(attributeValue);
            } else {
                throw new EhCacheConfigurationException("Cannot invoke setter: " + type);
            }
        }
        return value;
    }

    private Member lookupSetterOrConstructor(Class<?> type) {
        Constructor<?> member = this.memberCache.get(type.getName());
        if (member == null) {
            member = SetterHelper.getValueOfMethod(type);
        }
        if (member == null) {
            member = SetterHelper.getConstructor(type);
        }
        return member;
    }

    private static Constructor<?> getConstructor(Class<?> class1) {
        Constructor<?> constructor;
        try {
            constructor = class1.getConstructor(String.class);
        }
        catch (SecurityException e) {
            constructor = null;
        }
        catch (NoSuchMethodException e) {
            constructor = null;
        }
        return constructor;
    }

    private static Method getValueOfMethod(Class<?> class1) {
        Method method;
        try {
            method = class1.getMethod("valueOf", String.class);
        }
        catch (SecurityException e) {
            method = null;
        }
        catch (NoSuchMethodException e) {
            method = null;
        }
        return method;
    }
}

