/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pdc.core.ehcache.pogo;

import com.cognos.pogo.config.HandlerFactory;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import com.ibm.cognos.pdc.core.ehcache.CacheManagerDelegate;
import com.ibm.cognos.pdc.core.ehcache.CacheManagerProvider;
import com.ibm.cognos.pdc.core.ehcache.CognosCacheManagerPeerProvider;
import com.ibm.cognos.pdc.core.ehcache.DefaultEhPDCMBean;
import com.ibm.cognos.pdc.core.ehcache.EhPDCMBean;
import com.ibm.cognos.pdc.core.ehcache.config.ConfigLifeCycleManager;
import com.ibm.cognos.pdc.core.ehcache.config.PogoEngineContextResourceLoader;
import com.ibm.cognos.pdc.core.ehcache.pogo.DispatcherFinder;
import com.ibm.cognos.pdc.core.ehcache.pogo.DispatcherFinderProvider;
import com.ibm.cognos.pdc.core.ehcache.pogo.LogKitFactory;
import com.ibm.cognos.pdc.core.ehcache.pogo.PDCDispatcher;
import com.ibm.cognos.pdc.core.ehcache.rmi.CAMFactoryRMISocketFactory;
import com.ibm.cognos.pdc.core.ehcache.rmi.RMIEndpoint;
import com.ibm.cognos.pdc.core.ehcache.rmi.RMIPeerFinder;
import com.ibm.cognos.pdc.core.ehcache.rmi.RMIPeerListener;
import com.ibm.cognos.pdc.core.ehcache.rmi.RMIPeerListenerProvider;
import java.lang.management.ManagementFactory;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import net.sf.ehcache.Cache;
import net.sf.ehcache.distribution.CacheManagerPeerProvider;
import org.apache.log.Logger;

public class EhCacheDispatcherHandler
extends BasicHandler {
    private static final Logger LOGGER = LogKitFactory.getLogger(EhCacheDispatcherHandler.class);
    private CacheManagerProvider cacheManagerProvider;
    private CacheManagerDelegate cacheManager;
    private RMIPeerListener peerListener;
    private DispatcherFinder dispatcherFinder;
    private RMIPeerListenerProvider peerListenerProvider;
    private ConfigLifeCycleManager configManager;
    private CAMFactoryRMISocketFactory rmiSocketFactory;

    public EhCacheDispatcherHandler() {
        this(new HandlerFactory(), CacheManagerProvider.getInstance(), DispatcherFinderProvider.getInstance(), RMIPeerListenerProvider.getInstance(), ConfigLifeCycleManager.getInstance(), CAMFactoryRMISocketFactory.getInstance());
    }

    public EhCacheDispatcherHandler(HandlerFactory handlerFactory, CacheManagerProvider cacheManagerProvider, DispatcherFinder dispatcherFinder, RMIPeerListenerProvider peerListenerProvider, ConfigLifeCycleManager configManager, CAMFactoryRMISocketFactory rmiSocketFactory) {
        super(LOGGER);
        this.cacheManagerProvider = cacheManagerProvider;
        this.dispatcherFinder = dispatcherFinder;
        this.peerListenerProvider = peerListenerProvider;
        this.configManager = configManager;
        this.rmiSocketFactory = rmiSocketFactory;
    }

    public void configure(Configuration configuration) {
        super.configure(configuration);
        LOGGER.debug("configure...");
        this.configManager.parseCCLConfiguration(configuration.getICCLConfiguration());
        Set<PDCDispatcher> dispatchers = this.dispatcherFinder.getDispatchers(configuration);
        Set<RMIEndpoint> initialPeers = this.findPeers(dispatchers);
        this.setInitialPeers(initialPeers);
        PDCDispatcher localDispatcher = this.findLocalDispatcher(dispatchers);
        this.configManager.setLocalDispatcher(localDispatcher);
        this.configManager.initialize();
        LOGGER.debug("configured");
    }

    public void initialize() {
        super.initialize();
        LOGGER.debug("initialize...");
        this.cacheManager = this.cacheManagerProvider.getCacheManager();
        this.initializePeerListener();
        this.initializeMBean();
        if (LOGGER.isInfoEnabled()) {
            this.logCacheInfo();
        }
        LOGGER.debug("initialized");
    }

    private void initializeMBean() {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            DefaultEhPDCMBean pdcMBean = new DefaultEhPDCMBean(this.cacheManager);
            StandardMBean mbean = new StandardMBean(pdcMBean, EhPDCMBean.class);
            ObjectName pdcMbeanName = new ObjectName("com.cognos.pdc:type=pdcMbean");
            mBeanServer.registerMBean(mbean, pdcMbeanName);
            LOGGER.info("Registered mbean: " + pdcMbeanName);
        }
        catch (Exception e) {
            LOGGER.error("mbean registration exception", (Throwable)e);
        }
    }

    private void initializePeerListener() {
        CacheManagerPeerProvider peerProvider = this.cacheManager.getCacheManagerPeerProvider("RMI");
        if (peerProvider instanceof CognosCacheManagerPeerProvider) {
            CognosCacheManagerPeerProvider cognosPeerProvider = (CognosCacheManagerPeerProvider)peerProvider;
            cognosPeerProvider.init();
            this.peerListener = this.peerListenerProvider.getPeerListener(cognosPeerProvider);
        }
    }

    public void invokeImpl(MessageContext mc) throws PogoException {
    }

    private void setInitialPeers(Set<RMIEndpoint> initialPeers) {
        this.rmiSocketFactory.registerPeerSSLEndpoints(initialPeers);
        this.peerListenerProvider.setInitialPeers(initialPeers);
    }

    public void reconfigure(Configuration configuration) {
        super.reconfigure(configuration);
        LOGGER.debug("reconfigure...");
        if (this.peerListener != null) {
            Set<PDCDispatcher> dispatchers = this.dispatcherFinder.getDispatchers(configuration);
            this.rmiSocketFactory.clearPeerSSLEndpoints();
            Set<RMIEndpoint> peers = this.findPeers(dispatchers);
            this.peerListener.reconfigure(peers);
        }
        LOGGER.debug("reconfigured");
    }

    private Set<RMIEndpoint> findPeers(Set<PDCDispatcher> dispatchers) {
        return new RMIPeerFinder().findPeers(dispatchers);
    }

    protected PDCDispatcher findLocalDispatcher(Set<PDCDispatcher> dispatchers) {
        PDCDispatcher localDispatcher = null;
        for (PDCDispatcher dispatcher : dispatchers) {
            if (!dispatcher.isLocalDispatcher()) continue;
            localDispatcher = dispatcher;
        }
        return localDispatcher;
    }

    private void logCacheInfo() {
        LOGGER.info("CacheManager '" + this.cacheManager.getName() + "' " + this.cacheManager.getStatus());
        String[] cacheNames = this.cacheManager.getCacheNames();
        if (cacheNames != null) {
            for (String cacheName : cacheNames) {
                Cache cache = this.cacheManager.getCache(cacheName);
                LOGGER.info("Cache: '" + cacheName + "' size=" + cache.getSize() + ", status=" + cache.getStatus());
            }
        }
    }

    public void dispose() {
        super.dispose();
        if (this.cacheManager != null) {
            if (LOGGER.isInfoEnabled()) {
                this.logCacheInfo();
            }
            this.cacheManager.shutdown();
            LOGGER.info("cache manager shutdown");
        }
    }

    public void compose_impl(PogoEngine engine) throws PogoException {
        LOGGER.debug("compose_impl...");
        PogoEngineContextResourceLoader resourceLoader = new PogoEngineContextResourceLoader(engine.getContext());
        this.configManager = ConfigLifeCycleManager.getInstance();
        this.configManager.setResourceLoader(resourceLoader);
    }
}

