/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pdc.core.ehcache.pogo;

import com.cognos.p2plb.model.NodeID;
import com.cognos.pogo.monitoring.jmx.JMXDispatcher;
import com.ibm.cognos.pdc.core.ehcache.pogo.PDCDispatcher;
import java.util.Set;

public class JMXPDCDispatcher
implements PDCDispatcher,
Comparable<Object> {
    private String hostName;
    private String uri;
    private boolean isLocalDispatcher;
    private boolean isAvailable;
    private Set<String> services;
    private int listenerPort;
    private int rmiPort;

    protected JMXPDCDispatcher(NodeID nodeID, JMXDispatcher jmxDispatcher, Set<String> services, int listenerPort, int rmiPort) {
        this.hostName = nodeID.getHost();
        this.uri = nodeID.getURI();
        this.isLocalDispatcher = jmxDispatcher.isLocalDispatcher();
        this.isAvailable = jmxDispatcher.isAvailable();
        this.services = services;
        this.listenerPort = listenerPort;
        this.rmiPort = rmiPort;
    }

    @Override
    public boolean isLocalDispatcher() {
        return this.isLocalDispatcher;
    }

    @Override
    public boolean isAvailable() {
        return this.isAvailable;
    }

    @Override
    public int getListenerPort() {
        return this.listenerPort;
    }

    @Override
    public int getRMIPort() {
        return this.rmiPort;
    }

    @Override
    public String getHost() {
        return this.hostName;
    }

    @Override
    public Set<String> getServices() {
        return this.services;
    }

    @Override
    public void addService(String serviceName) {
        this.services.add(serviceName);
    }

    public String toString() {
        return "JMXPDCDispatcher(" + this.uri + ", ports=" + this.listenerPort + "," + this.rmiPort + ")";
    }

    public boolean equals(Object obj) {
        boolean isEqual = false;
        if (obj instanceof JMXPDCDispatcher) {
            JMXPDCDispatcher other = (JMXPDCDispatcher)obj;
            isEqual = this.getHost().equals(other.getHost()) && this.listenerPort == other.listenerPort;
        }
        return isEqual;
    }

    @Override
    public int compareTo(Object obj) {
        int comparison = -1;
        if (obj instanceof JMXPDCDispatcher) {
            JMXPDCDispatcher other = (JMXPDCDispatcher)obj;
            comparison = this.uri.compareTo(other.uri);
            if (comparison == 0 && this.listenerPort != other.listenerPort) {
                comparison = this.listenerPort > other.listenerPort ? 1 : -1;
            }
        }
        return comparison;
    }

    public int hashCode() {
        return this.uri.hashCode() ^ this.listenerPort * 31;
    }
}

