/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pdc.core.ehcache.pogo;

import com.ibm.cognos.pdc.core.ehcache.pogo.LogKitFactory;
import java.io.IOException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.log.Logger;

class MBeanAttributeGetter {
    private static final Logger LOGGER = LogKitFactory.getLogger(MBeanAttributeGetter.class);
    private MBeanServerConnection mbsc;
    private ObjectName objectName;

    protected MBeanAttributeGetter(MBeanServerConnection mbsc, String mbeanId) throws MalformedObjectNameException, NullPointerException {
        this(mbsc, ObjectName.getInstance(mbeanId));
    }

    protected MBeanAttributeGetter(MBeanServerConnection mbsc, ObjectName objectName) {
        this.mbsc = mbsc;
        this.objectName = objectName;
    }

    public Object getAttribute(String attributeId) throws IOException {
        Object value = null;
        try {
            if (this.mbsc.isRegistered(this.objectName)) {
                value = this.mbsc.getAttribute(this.objectName, attributeId);
            }
        }
        catch (IOException e) {
            LOGGER.debug("IOException during getAttribute: " + e.getMessage());
            throw e;
        }
        catch (Exception e) {
            LOGGER.debug("Exception during getAttribute", (Throwable)e);
            throw new IOException(e);
        }
        LOGGER.debug(this.objectName + " getAttribute " + attributeId + ": " + value);
        return value;
    }
}

