/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pdc.core.ehcache.pogo;

import com.cognos.p2plb.model.NodeID;
import com.cognos.pogo.config.DispatcherListElement;
import com.cognos.pogo.config.DispatcherListService;
import com.cognos.pogo.monitoring.jmx.JMXDispatcher;
import com.ibm.cognos.pdc.core.ehcache.pogo.JMXDispatcherProvider;
import com.ibm.cognos.pdc.core.ehcache.pogo.JMXPDCDispatcher;
import com.ibm.cognos.pdc.core.ehcache.pogo.LogKitFactory;
import com.ibm.cognos.pdc.core.ehcache.pogo.MBeanAttributeGetter;
import com.ibm.cognos.pdc.core.ehcache.pogo.PDCDispatcher;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import org.apache.log.Logger;

public class PDCDispatcherFactory {
    private static final Logger LOGGER = LogKitFactory.getLogger(PDCDispatcherFactory.class);
    private static final PDCDispatcherFactory INSTANCE = new PDCDispatcherFactory();
    private final JMXDispatcherProvider jmxDispatcherProvider;

    public static PDCDispatcherFactory getInstance() {
        return INSTANCE;
    }

    protected PDCDispatcherFactory() {
        this(new JMXDispatcherProvider());
    }

    protected PDCDispatcherFactory(JMXDispatcherProvider jmxDispatcherProvider) {
        this.jmxDispatcherProvider = jmxDispatcherProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PDCDispatcher getPDCDispatcher(DispatcherListElement dispListElem) throws MalformedObjectNameException {
        Set<String> services = this.getServices(dispListElem);
        NodeID nodeID = dispListElem.getNodeID();
        JMXDispatcher jmxDispatcher = this.jmxDispatcherProvider.getJMXDispatcher(dispListElem);
        int listenerPort = -1;
        int rmiPort = -1;
        if (!jmxDispatcher.isLocalDispatcher()) {
            try {
                MBeanServerConnection mbsc = jmxDispatcher.getMbeanServerConnection();
                if (mbsc != null) {
                    LOGGER.debug("querying remote PDC mbean: " + nodeID);
                    MBeanAttributeGetter attributeGetter = new MBeanAttributeGetter(mbsc, "com.cognos.pdc:type=pdcMbean");
                    listenerPort = this.getMBeanAttribute(nodeID, attributeGetter, "ListenerPort");
                    rmiPort = this.getMBeanAttribute(nodeID, attributeGetter, "RMIPort");
                }
            }
            finally {
                if (jmxDispatcher.isConnected()) {
                    LOGGER.debug("disconnecting mbean server connection: " + nodeID);
                    jmxDispatcher.disconnect();
                }
            }
        }
        return new JMXPDCDispatcher(nodeID, jmxDispatcher, services, listenerPort, rmiPort);
    }

    public PDCDispatcher getPDCDispatcher(String dispUri, String ... services) throws MalformedObjectNameException {
        String guid = "unknownGuid";
        String name = dispUri;
        String capacity = "0";
        String path = "";
        String serverGroup = "";
        String loadBalancingMode = "";
        DispatcherListElement dispListElem = new DispatcherListElement(guid, name, capacity, path, serverGroup, loadBalancingMode);
        PDCDispatcher dispatcher = this.getPDCDispatcher(dispListElem);
        for (String service : services) {
            dispatcher.addService(service);
        }
        return dispatcher;
    }

    private Set<String> getServices(DispatcherListElement disp) {
        Iterator iterator = disp.iterator();
        HashSet<String> result = new HashSet<String>();
        while (iterator.hasNext()) {
            DispatcherListService listService = (DispatcherListService)iterator.next();
            if (listService.getComponentID() != null) continue;
            result.add(listService.getName());
        }
        return result;
    }

    private Integer getMBeanAttribute(NodeID nodeID, MBeanAttributeGetter attributeGetter, String attributeId) throws MalformedObjectNameException {
        int intValue;
        try {
            Object value = attributeGetter.getAttribute(attributeId);
            intValue = value instanceof Integer ? (Integer)value : -1;
        }
        catch (IOException e) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn(String.format("IOException. Cannot query PDC MBean attribute %s from %s", attributeId, nodeID));
            }
            intValue = -1;
        }
        return intValue;
    }
}

