/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pdc.core.ehcache.rmi;

import com.ibm.cognos.pdc.core.ehcache.pogo.LogKitFactory;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Set;
import org.apache.log.Logger;

public class RMIEndpoint
implements Comparable<Object> {
    private static final Logger LOGGER = LogKitFactory.getLogger(RMIEndpoint.class);
    private static final RMIEndpoint UNKNOWN = new RMIEndpoint();
    private final InetAddress inetAddress;
    private final String addressString;
    private final int port;
    private Set<String> services;

    public static RMIEndpoint fromURI(String rmiUri) {
        int lastColonPos;
        int hostPos = rmiUri.indexOf("//") + 2;
        String hostName = rmiUri.substring(hostPos, lastColonPos = rmiUri.lastIndexOf(58));
        if (hostName.startsWith("[")) {
            hostName = hostName.substring(1, hostName.length() - 1);
        }
        int port = Integer.parseInt(rmiUri.substring(lastColonPos + 1));
        return RMIEndpoint.getEndpointByName(hostName, port);
    }

    public static RMIEndpoint getEndpointByAddress(InetAddress inetAddress, int port) {
        return new RMIEndpoint(inetAddress, port, Collections.<String>emptySet());
    }

    public static RMIEndpoint getEndpointByAddress(InetAddress inetAddress, int port, Set<String> services) {
        return new RMIEndpoint(inetAddress, port, services);
    }

    public static RMIEndpoint getEndpointByName(String hostName, int port) {
        return RMIEndpoint.getEndpointByName(hostName, port, Collections.<String>emptySet());
    }

    public static RMIEndpoint getEndpointByName(String hostName, int port, Set<String> services) {
        RMIEndpoint endpoint = UNKNOWN;
        InetAddress inetAddress = RMIEndpoint.getInetAddress(hostName);
        if (inetAddress != null) {
            endpoint = new RMIEndpoint(inetAddress, port, services);
        }
        return endpoint;
    }

    public static RMIEndpoint getLocalEndpoint(int port) {
        return RMIEndpoint.getLocalEndpoint(port, Collections.<String>emptySet());
    }

    public static RMIEndpoint getLocalEndpoint(int port, Set<String> services) {
        RMIEndpoint endpoint = UNKNOWN;
        InetAddress inetAddress = RMIEndpoint.getLocalInetAddress();
        if (inetAddress != null) {
            endpoint = RMIEndpoint.getEndpointByAddress(inetAddress, port, services);
        }
        return endpoint;
    }

    private RMIEndpoint() {
        this(null, -1, Collections.emptySet());
    }

    private RMIEndpoint(InetAddress inetAddress, int port, Set<String> services) {
        this.inetAddress = inetAddress;
        this.addressString = inetAddress != null ? inetAddress.getHostAddress() : "unknown";
        this.port = port;
        this.services = services;
    }

    public String getHostName() {
        return this.addressString;
    }

    public int getPort() {
        return this.port;
    }

    public String getRmiBaseUri() {
        String rmiHostString = this.inetAddress instanceof Inet6Address ? "[" + this.addressString + "]" : this.addressString;
        return "//" + rmiHostString + ":" + this.port;
    }

    public boolean hasService(String service) {
        return this.services.contains(service);
    }

    public void setServices(Set<String> services) {
        this.services = services;
    }

    public boolean isValid() {
        return this.inetAddress != null && this.port > 0 && this.port <= 65535;
    }

    private static InetAddress getInetAddress(String hostName) {
        InetAddress inetAddress;
        try {
            inetAddress = InetAddress.getByName(hostName);
        }
        catch (UnknownHostException e) {
            LOGGER.warn("Cannot get address for " + hostName, (Throwable)e);
            inetAddress = null;
        }
        return inetAddress;
    }

    private static InetAddress getLocalInetAddress() {
        InetAddress inetAddress;
        try {
            inetAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            LOGGER.warn("Cannot get local address", (Throwable)e);
            inetAddress = null;
        }
        return inetAddress;
    }

    public boolean equals(Object o) {
        boolean equal = false;
        if (o instanceof RMIEndpoint) {
            RMIEndpoint other = (RMIEndpoint)o;
            equal = this.addressString.equals(other.addressString) && this.port == other.port;
        }
        return equal;
    }

    public int hashCode() {
        return this.addressString.hashCode() ^ this.port * 31;
    }

    @Override
    public int compareTo(Object o) {
        int comparison = -1;
        if (o instanceof RMIEndpoint) {
            RMIEndpoint other = (RMIEndpoint)o;
            if (this.addressString.equals(other.addressString) && this.port == other.port) {
                comparison = 0;
            } else {
                comparison = this.addressString.compareTo(other.addressString);
                if (comparison == 0) {
                    comparison = this.port > other.port ? 1 : -1;
                }
            }
        }
        return comparison;
    }

    public String toString() {
        return this.getRmiBaseUri();
    }

    public boolean isLocal() {
        boolean isLocal = false;
        if (this.isValid()) {
            isLocal = this.inetAddress.isLoopbackAddress() || this.inetAddress.equals(RMIEndpoint.getLocalInetAddress());
        }
        return isLocal;
    }
}

