/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pdc.core.ehcache.rmi;

import com.ibm.cognos.pdc.core.ehcache.pogo.LogKitFactory;
import com.ibm.cognos.pdc.core.ehcache.pogo.PDCDispatcher;
import com.ibm.cognos.pdc.core.ehcache.rmi.CAMFactoryRMISocketFactory;
import com.ibm.cognos.pdc.core.ehcache.rmi.RMIEndpoint;
import java.util.HashSet;
import java.util.Set;
import org.apache.log.Logger;

public class RMIPeerFinder {
    private static final Logger LOGGER = LogKitFactory.getLogger(RMIPeerFinder.class);
    private final CAMFactoryRMISocketFactory socketFactory;

    public RMIPeerFinder() {
        this(CAMFactoryRMISocketFactory.getInstance());
    }

    protected RMIPeerFinder(CAMFactoryRMISocketFactory socketFactory) {
        this.socketFactory = socketFactory;
    }

    public Set<RMIEndpoint> findPeers(Set<PDCDispatcher> dispatchers) {
        HashSet<RMIEndpoint> pdcPeers = new HashSet<RMIEndpoint>();
        for (PDCDispatcher dispatcher : dispatchers) {
            if (!this.isEligibleRemotePeer(dispatcher)) continue;
            String hostName = dispatcher.getHost();
            int port = dispatcher.getListenerPort();
            Set<String> services = dispatcher.getServices();
            RMIEndpoint listenerEndpoint = RMIEndpoint.getEndpointByName(hostName, port, services);
            RMIEndpoint rmiEndpoint = RMIEndpoint.getEndpointByName(hostName, dispatcher.getRMIPort());
            if (!listenerEndpoint.isValid() || !rmiEndpoint.isValid()) continue;
            this.socketFactory.registerPeerSSLEndpoints(listenerEndpoint, rmiEndpoint);
            pdcPeers.add(listenerEndpoint);
            LOGGER.debug("adding peer listener endpoint: " + listenerEndpoint);
        }
        return pdcPeers;
    }

    private boolean isEligibleRemotePeer(PDCDispatcher dispatcher) {
        boolean isValid;
        boolean bl = isValid = !dispatcher.isLocalDispatcher() && dispatcher.isAvailable();
        if (LOGGER.isDebugEnabled() && isValid) {
            LOGGER.debug(dispatcher + " is an eligible remote peer");
        }
        return isValid;
    }
}

