/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pdc.core.ehcache.rmi;

import com.ibm.cognos.pdc.core.ehcache.CognosCacheManagerPeerProvider;
import com.ibm.cognos.pdc.core.ehcache.pogo.LogKitFactory;
import com.ibm.cognos.pdc.core.ehcache.rmi.RMIEndpoint;
import java.util.HashSet;
import java.util.Set;
import org.apache.log.Logger;

public class RMIPeerListener {
    private static final Logger LOGGER = LogKitFactory.getLogger(RMIPeerListener.class);
    private CognosCacheManagerPeerProvider peerProvider;
    private Set<RMIEndpoint> initialPeers;

    protected RMIPeerListener(CognosCacheManagerPeerProvider peerProvider, Set<RMIEndpoint> peers) {
        this.peerProvider = peerProvider;
        this.initialPeers = peers;
    }

    public void initialize() {
        this.reconfigure(this.initialPeers);
    }

    public void reconfigure(Set<RMIEndpoint> newPeers) {
        Set<RMIEndpoint> oldPeers = this.peerProvider.getRMIPeers();
        this.logPeerSummary(newPeers, oldPeers);
        Set<RMIEndpoint> deadPeers = this.registerNewPeers(newPeers, oldPeers);
        this.unregisterDeadPeers(deadPeers);
    }

    private void logPeerSummary(Set<RMIEndpoint> newPeers, Set<RMIEndpoint> oldPeers) {
        if (LOGGER.isWarnEnabled()) {
            if (newPeers.size() == 0 && oldPeers.size() > 0) {
                LOGGER.warn("reconfigured with 0 peers. Replication is inactive.");
            } else if (newPeers.size() != oldPeers.size()) {
                LOGGER.info(String.format("reconfigured with %d peer(s). Replication is active.", newPeers.size()));
            }
        }
    }

    private Set<RMIEndpoint> registerNewPeers(Set<RMIEndpoint> newPeers, Set<RMIEndpoint> oldPeers) {
        HashSet<RMIEndpoint> deadPeers = new HashSet<RMIEndpoint>(oldPeers);
        for (RMIEndpoint rmiPeer : newPeers) {
            String rmiBaseUri = rmiPeer.getRmiBaseUri();
            if (!oldPeers.contains(rmiPeer)) {
                this.peerProvider.registerPeer(rmiPeer);
                LOGGER.debug("registered peer " + rmiBaseUri);
            }
            deadPeers.remove(rmiPeer);
        }
        return deadPeers;
    }

    private void unregisterDeadPeers(Set<RMIEndpoint> deadPeers) {
        for (RMIEndpoint peer : deadPeers) {
            this.peerProvider.unregisterPeer(peer);
            LOGGER.debug("unregistered peer " + peer);
        }
    }
}

