/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vipr.renderingservice.property;

import com.ibm.vipr.renderingservice.property.FontStyle;
import com.ibm.vipr.renderingservice.property.FontWeight;
import com.ibm.vipr.renderingservice.property.Length;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Font {
    private static final Pattern reWhitespace = Pattern.compile("\\s+");
    private static final Pattern reSemiColon = Pattern.compile("\\s*;\\s*");
    private static final Pattern reComma = Pattern.compile("\\s*,\\s*");
    public final List<String> family;
    public final Length size;
    public final FontStyle style;
    public final FontWeight weight;
    private final int hashCode;

    private static String normalize(String _family) {
        char c;
        String result = null;
        int length = 0;
        if (_family != null && (length = (result = _family.trim()).length()) > 1 && ((c = result.charAt(0)) == '\'' || c == '\"') && c == result.charAt(length - 1)) {
            result = result.substring(1, length - 1);
            length = result.length();
        }
        return length > 0 ? result : null;
    }

    public static Font create(List<String> _family, Length _size, FontStyle _style, FontWeight _weight) {
        return _family == null && _size == null && _style == null && _weight == null ? null : new Font(_family, _size, _style, _weight);
    }

    public static Font merge(Font _current, Font _merge) {
        if (_current == null) {
            return _merge;
        }
        if (_merge == null) {
            return _current;
        }
        return Font.create(_merge.family != null ? _merge.family : _current.family, _merge.size != null ? _merge.size : _current.size, _merge.style != null ? _merge.style : _current.style, _merge.weight != null ? _merge.weight : _current.weight);
    }

    public static List<String> normalizeFamily(List<String> _family) {
        ArrayList<String> family = null;
        if (_family != null) {
            int fontCount = _family.size();
            family = new ArrayList<String>(fontCount);
            for (int i = 0; i < fontCount; ++i) {
                String font = Font.normalize(_family.get(i));
                if (font == null) continue;
                family.add(font);
            }
            if (family.size() < 1) {
                family = null;
            }
        }
        return family == null ? null : Collections.unmodifiableList(family);
    }

    public static List<String> parseFamily(String _value) {
        ArrayList<String> result = null;
        if (_value != null) {
            String[] parts = reComma.split(_value);
            int fontCount = parts.length;
            result = new ArrayList<String>(fontCount);
            for (int i = 0; i < fontCount; ++i) {
                String font = Font.normalize(parts[i]);
                if (font == null) continue;
                result.add(font);
            }
            if (result.size() < 1) {
                result = null;
            }
        }
        return result;
    }

    public static boolean familyEqual(List<String> _a, List<String> _b) {
        if (_a == _b) {
            return true;
        }
        if (_a == null || _b == null) {
            return false;
        }
        int len = _a.size();
        if (len != _b.size()) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            String entryB;
            String entryA = _a.get(i);
            if (entryA == (entryB = _b.get(i)) || entryA != null && entryA.equals(entryB)) continue;
            return false;
        }
        return true;
    }

    public static String familyToCss(List<String> _family) {
        StringBuilder result = new StringBuilder();
        if (_family != null) {
            for (String font : _family) {
                boolean quote = reWhitespace.matcher(font).matches();
                if (result.length() > 0) {
                    result.append(", ");
                }
                if (quote) {
                    result.append('\"');
                }
                result.append(font);
                if (!quote) continue;
                result.append('\"');
            }
        }
        return result.toString();
    }

    private static Font parseShorthand(String _shortHand) {
        int len;
        int n = len = _shortHand == null ? 0 : _shortHand.length();
        if (len < 1) {
            return null;
        }
        List<String> family = null;
        Length size = null;
        FontStyle style = null;
        FontWeight weight = null;
        Matcher match = reWhitespace.matcher(_shortHand);
        int familyStart = 0;
        int lastIndex = 0;
        int start = 0;
        while (start < len) {
            int end;
            if (match.find()) {
                lastIndex = match.end();
                end = match.start();
            } else {
                lastIndex = end = len;
            }
            String section = _shortHand.substring(start, end);
            FontStyle matchStyle = FontStyle.parse(section);
            if (matchStyle != null) {
                if (matchStyle == FontStyle.Normal) {
                    if (style == null) {
                        style = matchStyle;
                    }
                    if (weight == null) {
                        weight = FontWeight.Normal;
                    }
                } else {
                    style = matchStyle;
                }
                familyStart = lastIndex;
            } else {
                FontWeight matchWeight = FontWeight.parse(section);
                if (matchWeight != null) {
                    if (weight == null || matchWeight != FontWeight.Normal) {
                        weight = matchWeight;
                    }
                    familyStart = lastIndex;
                } else {
                    size = Length.parse(section);
                    if (size != null) {
                        familyStart = lastIndex;
                        break;
                    }
                }
            }
            start = end = lastIndex;
        }
        if (familyStart < _shortHand.length()) {
            family = Font.parseFamily(familyStart < 1 ? _shortHand : _shortHand.substring(familyStart));
        }
        return Font.create(family, size, style, weight);
    }

    public static Font parse(String _value) {
        if (_value == null) {
            return null;
        }
        List<String> family = null;
        Length size = null;
        FontStyle style = null;
        FontWeight weight = null;
        block14: for (String entry : reSemiColon.split(_value.trim())) {
            int idx = entry.indexOf(58);
            String property = null;
            String value = null;
            if (idx < 0 && entry.length() > 0) {
                property = "font";
                value = entry;
            } else if (idx > 0) {
                property = entry.substring(0, idx);
                value = entry.substring(idx + 1).trim();
            }
            if (property == null || value == null) continue;
            switch (property) {
                case "font": {
                    Font temp = Font.parseShorthand(value);
                    if (temp == null) continue block14;
                    family = temp.family;
                    size = temp.size;
                    style = temp.style;
                    weight = temp.weight;
                    continue block14;
                }
                case "font-size": {
                    size = Length.parse(value);
                    continue block14;
                }
                case "font-family": {
                    family = Font.parseFamily(value);
                    continue block14;
                }
                case "font-style": {
                    style = FontStyle.parse(value);
                    continue block14;
                }
                case "font-weight": {
                    weight = FontWeight.parse(value);
                }
            }
        }
        return Font.create(family, size, style, weight);
    }

    public Font(List<String> _family, Length _size, FontStyle _style, FontWeight _weight) {
        this.family = _family;
        this.size = _size;
        this.style = _style;
        this.weight = _weight;
        this.hashCode = Objects.hash(new Object[]{_family, _size, _style, _weight});
    }

    public double sizePx(double _parentFontPx) {
        return this.size == null ? _parentFontPx : this.size.calculatePx(_parentFontPx, _parentFontPx);
    }

    public String familyCss() {
        return Font.familyToCss(this.family);
    }

    public String sizeCss() {
        return this.size != null ? this.size.toString() : "";
    }

    public String styleCss() {
        return FontStyle.toCssString(this.style);
    }

    public String weightCss() {
        return FontWeight.toCssString(this.weight);
    }

    public String toCssString() {
        StringBuilder result = new StringBuilder();
        String temp = this.familyCss();
        if (temp != null && temp.length() > 0) {
            result.append("font-family: ").append(temp).append(';');
        }
        if ((temp = this.sizeCss()) != null && temp.length() > 0) {
            if (result.length() > 0) {
                result.append(' ');
            }
            result.append("font-size: ").append(temp).append(';');
        }
        if ((temp = this.styleCss()) != null && temp.length() > 0) {
            if (result.length() > 0) {
                result.append(' ');
            }
            result.append("font-style: ").append(temp).append(';');
        }
        if ((temp = this.weightCss()) != null && temp.length() > 0) {
            if (result.length() > 0) {
                result.append(' ');
            }
            result.append("font-weight: ").append(temp).append(';');
        }
        return result.toString();
    }

    public String toString() {
        String result;
        if (this.style != FontStyle.Normal && this.weight != FontWeight.Normal || this.style == FontStyle.Normal && this.weight == FontWeight.Normal) {
            result = "";
            if (this.style == FontStyle.Normal) {
                result = result + "normal";
            } else {
                if (this.style != null) {
                    result = result + this.style.value();
                }
                if (this.weight != null) {
                    if (result.length() > 0) {
                        result = result + " ";
                    }
                    result = result + FontWeight.toCssString(this.weight);
                }
            }
            if (this.size != null) {
                if (result.length() > 0) {
                    result = result + " ";
                }
                result = result + this.size.toString();
            }
            if (this.family != null && this.family.size() > 0) {
                if (result.length() > 0) {
                    result = result + " ";
                }
                result = result + Font.familyToCss(this.family);
            }
        } else {
            result = this.toCssString();
        }
        return result;
    }

    public boolean equals(Object _other) {
        if (_other == this) {
            return true;
        }
        Font other = _other instanceof Font ? (Font)_other : null;
        return other != null && Font.familyEqual(this.family, other.family) && (this.size == other.size || this.size != null && this.size.equals(other.size)) && this.style == other.style && this.weight == other.weight;
    }

    public int hashCode() {
        return this.hashCode;
    }
}

