/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vipr.renderingservice.property;

import com.ibm.vipr.renderingservice.property.LengthUnit;
import com.ibm.vipr.renderingservice.util.NumberUtil;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Length {
    private static final double INCH_TO_PX = 96.0;
    private static final double CENTIMETER_TO_PX = 37.79527559055118;
    private static final double MILLIMETER_TO_PX = 3.7795275590551185;
    private static final double PICA_TO_PX = 16.0;
    private static final double POINT_TO_PX = 1.3333333333333333;
    private static final Pattern reLength = Pattern.compile("^([\\-\\+]?(?:\\d+(?:(?!\\r?\\n)[\\s,]\\d+)*(?:\\.\\d+)?|\\.\\d+))(?:$|(?!\\d|\\.))(%|[a-zA-Z]+)?$");
    public final double value;
    public final LengthUnit unit;
    private int hashCode;

    public static Length parse(String _value) {
        if (_value == null || _value.length() < 1) {
            return null;
        }
        Matcher match = reLength.matcher(_value);
        if (match.matches()) {
            Number number = NumberUtil.parseNumber(match.group(1), null);
            LengthUnit unit = LengthUnit.parse(match.group(2));
            if (number != null && (unit != null || match.group(2) == null)) {
                return new Length(number.doubleValue(), unit == null ? LengthUnit.Pixel : unit);
            }
        }
        return null;
    }

    public Length(double _value, LengthUnit _unit) {
        this.value = _value;
        if (_unit == null) {
            throw new IllegalArgumentException("unit cannot be null");
        }
        this.unit = _unit;
        this.hashCode = Objects.hash(new Object[]{_value, _unit});
    }

    public double calculatePx(double _parentPx, double _fontSize) {
        switch (this.unit) {
            case Em: {
                return _fontSize * this.value;
            }
            case Percentage: {
                return _parentPx * this.value / 100.0;
            }
            case Centimeter: {
                return this.value * 37.79527559055118;
            }
            case Millimeter: {
                return this.value * 3.7795275590551185;
            }
            case Inch: {
                return this.value * 96.0;
            }
            case Pica: {
                return this.value * 16.0;
            }
            case Point: {
                return this.value * 1.3333333333333333;
            }
            case Pixel: {
                return this.value;
            }
        }
        throw new Error("Unhandled unit: " + (Object)((Object)this.unit));
    }

    public String toString() {
        return NumberUtil.toString(this.value) + this.unit.value();
    }

    public boolean equals(Object _other) {
        if (_other == this) {
            return true;
        }
        Length other = _other instanceof Length ? (Length)_other : null;
        return other != null && Double.compare(this.value, other.value) == 0 && this.unit == other.unit;
    }

    public int hashCode() {
        return this.hashCode;
    }
}

