/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vipr.renderingservice.util;

import com.ibm.vipr.renderingservice.api.IRSPoint;

public class Bounds {
    private double left;
    private double top;
    private double right;
    private double bottom;
    private double width;
    private double height;

    public static Bounds fromXYWH(double _x, double _y, double _w, double _h) {
        return new Bounds(_x, _y, _x + _w, _y + _h);
    }

    public static Bounds fromXYWH(Number _x, Number _y, Number _w, Number _h) {
        if (_x == null) {
            _x = 0;
        }
        if (_y == null) {
            _y = 0;
        }
        if (_w == null) {
            _w = 0;
        }
        if (_h == null) {
            _h = 0;
        }
        return new Bounds(_x.doubleValue(), _y.doubleValue(), _x.doubleValue() + _w.doubleValue(), _y.doubleValue() + _h.doubleValue());
    }

    public Bounds(double _left, double _top, double _right, double _bottom) {
        this.left = _left;
        this.top = _top;
        this.right = _right;
        this.bottom = _bottom;
        this.width = _right - _left;
        this.height = _bottom - _top;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public double getLeft() {
        return this.left;
    }

    public double getRight() {
        return this.right;
    }

    public double getTop() {
        return this.top;
    }

    public double getBottom() {
        return this.bottom;
    }

    public boolean containsPoint(IRSPoint _point) {
        return this.containsPointXY(_point.getX(), _point.getY());
    }

    public boolean containsPointXY(double _x, double _y) {
        return _x >= this.left && _x < this.right && _y >= this.top && _y < this.bottom;
    }

    public String toString() {
        return "Bounds[" + this.getLeft() + "," + this.getTop() + "," + this.getWidth() + "," + this.getHeight() + "]";
    }
}

