/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vipr.renderingservice.util;

import com.ibm.vipr.renderingservice.api.IRSCapability;
import com.ibm.vipr.renderingservice.util.AggregationCapability;
import com.ibm.vipr.renderingservice.util.NegativeHandlingCapability;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Capability
implements IRSCapability {
    public static final String Aggregate = "aggregate";
    public static final String AggregateOver = "over";
    public static final String AggregateNegative = "negative";
    public static final String AggregateType = "type";
    public static final String Limit = "limit";
    public static final String LimitSize = "n";
    private final String slot;
    private final String name;
    private final Map<String, Object> attributes;
    private final Map<String, Object> readOnlyAttributes;

    @Override
    public String getSlot() {
        return this.slot;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.readOnlyAttributes;
    }

    private Capability(String _slot, String _name) {
        this.slot = _slot;
        this.name = _name;
        this.attributes = new HashMap<String, Object>();
        this.readOnlyAttributes = Collections.unmodifiableMap(this.attributes);
    }

    public static Capability create(String _slot, String _name) {
        return new Capability(_slot, _name);
    }

    public static Capability limit(String _slot, int _size) {
        return new Capability(_slot, Limit).attr(LimitSize, _size);
    }

    public static Capability aggregate(String _slot, String _over, AggregationCapability _type, NegativeHandlingCapability _negative) {
        return new Capability(_slot, Aggregate).attr(AggregateOver, _over).attr(AggregateNegative, _negative != null ? _negative.value() : NegativeHandlingCapability.Separate.value()).attr(AggregateType, _type != null ? _type.value() : AggregationCapability.Sum.value());
    }

    public Capability attr(String name, Object value) {
        this.attributes.put(name, value);
        return this;
    }
}

