/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.vis.schema.definition;

import com.ibm.ba.vis.schema.definition.Rave2DefinitionConverter;
import com.ibm.ba.vis.vgs.error.ErrorCode;
import com.ibm.ba.vis.vgs.error.GalleryServiceErrorCode;
import com.ibm.ba.vis.vgs.error.GalleryServiceException;
import com.ibm.rave.bundles.RaveBundle;
import com.ibm.rave.bundles.nativeImpl.BundleLookup;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.library.framework.meta.BundleConfiguration;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.IOUtils;

public class Rave2BundleDefinitionManager {
    private static HashMap<String, List<String>> bundlesConfigs = new HashMap();
    private static HashMap<String, Properties> bundlesConfigsAllLangDefinitions = new HashMap();
    private static HashMap<String, List<String>> bundlesConfigsPreviews = new HashMap();

    public static List<String> getBundleLangNames() {
        return Arrays.asList("cs", "da", "de", "en", "es", "fi", "fr", "hr", "hu", "it", "ja", "kk", "ko", "nb", "nl", "pl", "pt-br", "ro", "ru", "sl", "sv", "th", "tr", "zh-cn", "zh-tw");
    }

    public static String updateLangName(String lang) {
        if (lang.contains("-") && !lang.startsWith("zh-") && !lang.equals("pt-br")) {
            return lang.split("-")[0];
        }
        if (lang.equals("pt")) {
            return "pt-br";
        }
        if (lang.equals("no")) {
            return "nb";
        }
        if (!Rave2BundleDefinitionManager.getBundleLangNames().contains(lang)) {
            return "en";
        }
        return lang;
    }

    public static void createAllLangRave2BundlesDefinitions(String rave2FolderPath) {
        File path = new File(rave2FolderPath);
        if (!path.exists() && !path.mkdirs()) {
            throw new GalleryServiceException((ErrorCode)GalleryServiceErrorCode.internalServiceError, (Throwable)new Exception("mkdirs failed"));
        }
        List<String> langNames = Rave2BundleDefinitionManager.getBundleLangNames();
        langNames.parallelStream().forEach(lang -> Rave2BundleDefinitionManager.createOneLangRave2BundlesDefinitions(lang, rave2FolderPath));
    }

    public static void createOneLangRave2BundlesDefinitions(String lang, String rave2FolderPath) {
        Properties rave2BundlesDefProp = new Properties();
        List bundleNames = BundleLookup.getBundleIds();
        Rave2DefinitionConverter converter = new Rave2DefinitionConverter(lang);
        for (String bundleName : bundleNames) {
            List<String> configIDs = bundlesConfigs.get(bundleName);
            for (String configID : configIDs) {
                String bundleConfig = bundleName + ',' + configID;
                InputStream definitionStream = converter.convert(bundleConfig);
                try {
                    rave2BundlesDefProp.setProperty(bundleConfig, IOUtils.toString((InputStream)definitionStream, (String)"UTF-8"));
                    definitionStream.close();
                }
                catch (IOException e) {
                    throw new GalleryServiceException((ErrorCode)GalleryServiceErrorCode.internalServiceError, (Throwable)e);
                }
            }
        }
        try {
            FileOutputStream output = new FileOutputStream(rave2FolderPath + "/rave2BundlesDef_" + lang + ".properties");
            rave2BundlesDefProp.store(output, null);
            output.close();
        }
        catch (IOException e) {
            throw new GalleryServiceException((ErrorCode)GalleryServiceErrorCode.internalServiceError, (Throwable)e);
        }
    }

    public static String getOneLangRave2OneBundleDefinition(String bundleConfigID, String lang) {
        return bundlesConfigsAllLangDefinitions.get(lang).getProperty(bundleConfigID);
    }

    public static void loadAllLangRave2BundlesDefinitions() {
        List<String> langNames = Rave2BundleDefinitionManager.getBundleLangNames();
        for (String lang : langNames) {
            Rave2BundleDefinitionManager.loadOneLangRave2BundlesDefinitions(lang);
        }
    }

    private static void loadOneLangRave2BundlesDefinitions(String lang) {
        Properties rave2BundlesDefProp = new Properties();
        List bundleNames = BundleLookup.getBundleIds();
        Rave2DefinitionConverter converter = new Rave2DefinitionConverter(lang);
        for (String bundleName : bundleNames) {
            List<String> configIDs = bundlesConfigs.get(bundleName);
            for (String configID : configIDs) {
                String bundleConfig = bundleName + ',' + configID;
                InputStream definitionStream = converter.convert(bundleConfig);
                try {
                    rave2BundlesDefProp.setProperty(bundleConfig, IOUtils.toString((InputStream)definitionStream, (String)"UTF-8"));
                    definitionStream.close();
                }
                catch (IOException e) {
                    throw new GalleryServiceException((ErrorCode)GalleryServiceErrorCode.internalServiceError, (Throwable)e);
                }
            }
        }
        bundlesConfigsAllLangDefinitions.putIfAbsent(lang, rave2BundlesDefProp);
    }

    public static Properties getOneLangRave2BundlesDefinitions(String lang) {
        return bundlesConfigsAllLangDefinitions.get(lang);
    }

    public static List<String> getRave2BundleConfigIDs(String bundleName) {
        return bundlesConfigs.get(bundleName);
    }

    private static void loadBundlesAndConfigsAndPreviews() {
        List bundleNames = BundleLookup.getBundleIds();
        for (String bundleName : bundleNames) {
            ArrayList<String> bundleConfigIDs = new ArrayList<String>();
            RaveBundle bundle = BundleLookup.getBundle((String)bundleName);
            ArrayEx configurations = bundle.configurations();
            for (BundleConfiguration configuration : configurations) {
                bundleConfigIDs.add(configuration.id());
                bundlesConfigsPreviews.putIfAbsent(bundleName + ',' + configuration.id(), (List<String>)configuration.info().getPreviews("svg"));
            }
            bundlesConfigs.putIfAbsent(bundleName, bundleConfigIDs);
        }
    }

    public static List<String> getRave2BundleConfigPreviews(String bundleNameWithConfigID) {
        return bundlesConfigsPreviews.get(bundleNameWithConfigID);
    }

    public static boolean isRave2BundleName(String bundleName) {
        return bundleName.startsWith("rave-library-") && bundleName.contains(",");
    }

    static {
        Rave2BundleDefinitionManager.loadBundlesAndConfigsAndPreviews();
        Rave2BundleDefinitionManager.loadAllLangRave2BundlesDefinitions();
    }
}

