/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.vis.schema.definition;

import com.ibm.ba.vis.schema.definition.Rave2Converter;
import com.ibm.ba.vis.vgs.error.ErrorCode;
import com.ibm.ba.vis.vgs.error.GalleryAPIErrorCode;
import com.ibm.ba.vis.vgs.error.GalleryServiceException;
import com.ibm.ba.vis.vgs.resources.VGSLocaleUtils;
import com.ibm.json.java.JSON;
import com.ibm.json.java.JSONObject;
import com.ibm.rave.awt.service.AWTRaveImageService;
import com.ibm.rave.awt.service.AWTRaveImageServiceRunnable;
import com.ibm.rave.bundles.RaveBundle;
import com.ibm.rave.bundles.nativeImpl.BundleLookup;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.selector.Selector;
import com.ibm.rave.library.datamodel.DataModelDescriptor;
import com.ibm.rave.library.datamodel.DataSetDescriptor;
import com.ibm.rave.library.datamodel.DataSlotDescriptor;
import com.ibm.rave.library.framework.BundleInfo;
import com.ibm.rave.library.framework.Controller;
import com.ibm.rave.library.framework.meta.BundleConfiguration;
import com.ibm.rave.library.framework.meta.GenericMetadata;
import com.ibm.rave.library.framework.meta.PresentationItems;
import com.ibm.rave.library.framework.meta.PropertyMeta;
import com.ibm.rave.library.framework.meta.PropertyPresentationMeta;
import com.ibm.rave.library.framework.meta.internal.PropertyGroupMeta;
import com.ibm.rave.library.framework.meta.internal.PropertyReferenceMeta;
import com.ibm.rave.library.property.PropertyBooleanType;
import com.ibm.rave.library.property.PropertyNumericType;
import com.ibm.rave.library.property.PropertyStringType;
import com.ibm.rave.library.property.StringPropertyOption;
import com.ibm.xmlns.prod.ba.visbundle.charttypedefinition._3_1.CategorySlot;
import com.ibm.xmlns.prod.ba.visbundle.charttypedefinition._3_1.CustomProperties;
import com.ibm.xmlns.prod.ba.visbundle.charttypedefinition._3_1.DataTypes;
import com.ibm.xmlns.prod.ba.visbundle.charttypedefinition._3_1.Description;
import com.ibm.xmlns.prod.ba.visbundle.charttypedefinition._3_1.GroupProperties;
import com.ibm.xmlns.prod.ba.visbundle.charttypedefinition._3_1.Label;
import com.ibm.xmlns.prod.ba.visbundle.charttypedefinition._3_1.ObjectFactory;
import com.ibm.xmlns.prod.ba.visbundle.charttypedefinition._3_1.Properties;
import com.ibm.xmlns.prod.ba.visbundle.charttypedefinition._3_1.RGBA;
import com.ibm.xmlns.prod.ba.visbundle.charttypedefinition._3_1.Set;
import com.ibm.xmlns.prod.ba.visbundle.charttypedefinition._3_1.Tags;
import com.ibm.xmlns.prod.ba.visbundle.charttypedefinition._3_1.Tooltip;
import com.ibm.xmlns.prod.ba.visbundle.charttypedefinition._3_1.ValueSlot;
import com.ibm.xmlns.prod.ba.visbundle.charttypedefinition._3_1.VisualizationDefinition;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;

public class Rave2DefinitionConverter
implements Rave2Converter,
AWTRaveImageServiceRunnable {
    static final String DEFINITION_V3_1 = "com.ibm.xmlns.prod.ba.visbundle.charttypedefinition._3_1";
    private String bundleNameWithConfigID = null;
    private String bundleName = null;
    private String configID = null;
    private ObjectFactory factory = null;
    private VisualizationDefinition definition = null;
    private JAXBContext context = null;
    private String language = "en";
    private ResourceBundle vgsBundle = null;
    private String outputType = "all";

    public Rave2DefinitionConverter(String language) {
        this.language = language;
        this.factory = new ObjectFactory();
        this.definition = this.factory.createVisualizationDefinition();
        try {
            this.context = JAXBContext.newInstance((String)DEFINITION_V3_1);
        }
        catch (JAXBException e) {
            throw new GalleryServiceException((ErrorCode)GalleryAPIErrorCode.corruptedBundleDefinition, (Throwable)e);
        }
    }

    @Override
    public InputStream convert(String bundleName) {
        this.reset();
        this.bundleNameWithConfigID = bundleName;
        if (this.bundleNameWithConfigID.contains(",")) {
            String[] parts = this.bundleNameWithConfigID.split(",");
            this.bundleName = parts[0];
            this.configID = parts[1];
        }
        AWTRaveImageService.getInstance().run((AWTRaveImageServiceRunnable)this, "root");
        return this.convertDefinitionToXMLStream(this.definition);
    }

    private void reset() {
        this.definition = this.factory.createVisualizationDefinition();
    }

    private void addMetadata(String name, BundleInfo bundleInfo) {
        GenericMetadata genericMeta = bundleInfo.meta();
        this.definition.setName(name);
        this.definition.setAuthor(genericMeta.id("author"));
        this.definition.setDefinitionVersion("3_1");
        this.definition.setAdapter("com.ibm.cognos.adapters.rave2.RAVEChartAdapter");
        this.definition.setSupportsDefaultDataFormatting(true);
        this.definition.setOutputType(this.outputType);
        Label label = new Label();
        label.setValue(genericMeta.id("label"));
        this.definition.setLabel(label);
        Description description = new Description();
        description.setValue(genericMeta.id("description"));
        this.definition.setDescription(description);
        this.addTagsToObject((List<String>)genericMeta.tags(), VisualizationDefinition.class, this.definition);
    }

    private void addInteractiveType() {
        VisualizationDefinition.InteractiveOutputType interactiveOutputType = this.factory.createVisualizationDefinitionInteractiveOutputType();
        VisualizationDefinition.InteractiveOutputType.Canvas interactiveCanvas = this.factory.createVisualizationDefinitionInteractiveOutputTypeCanvas();
        VisualizationDefinition.InteractiveOutputType.Svg interactiveSvg = this.factory.createVisualizationDefinitionInteractiveOutputTypeSvg();
        interactiveOutputType.setCanvas(interactiveCanvas);
        interactiveOutputType.setSvg(interactiveSvg);
        this.definition.setInteractiveOutputType(interactiveOutputType);
    }

    private void addData(BundleInfo bundleInfo) {
        DataModelDescriptor dataModelDescriptor = (DataModelDescriptor)bundleInfo.dataModels().get(0);
        ArrayEx dataSetDescriptorArray = dataModelDescriptor.dataSets();
        VisualizationDefinition.DataSets dataSets = this.factory.createVisualizationDefinitionDataSets();
        VisualizationDefinition.Slots slots = this.factory.createVisualizationDefinitionSlots();
        List<String> listOfSlots = new ArrayList<String>();
        for (DataSetDescriptor dataSetDescriptor : dataSetDescriptorArray) {
            VisualizationDefinition.DataSets.DataSet dataSet = this.factory.createVisualizationDefinitionDataSetsDataSet();
            dataSet.setName(dataSetDescriptor.id());
            Label label = new Label();
            label.setValue(dataSetDescriptor.label());
            dataSet.setLabel(label);
            Tooltip tooltip = new Tooltip();
            tooltip.setValue(dataSetDescriptor.description());
            dataSet.setTooltip(tooltip);
            dataSet.setOptionalOverride(false);
            dataSet.setHasChartElements(true);
            VisualizationDefinition.DataSets.DataSet.ValueAxis valueAxis = this.factory.createVisualizationDefinitionDataSetsDataSetValueAxis();
            VisualizationDefinition.DataSets.DataSet.CategoryAxes categoryAxes = this.factory.createVisualizationDefinitionDataSetsDataSetCategoryAxes();
            ArrayEx dataSlotDescriptorArray = dataSetDescriptor.dataSlots();
            listOfSlots = this.createSlots(valueAxis, categoryAxes, (ArrayEx<DataSlotDescriptor>)dataSlotDescriptorArray, slots, listOfSlots);
            if (slots.getCategorySlotOrValueSlot().isEmpty()) continue;
            this.definition.setSlots(slots);
            dataSet.setValueAxis(valueAxis);
            dataSet.setCategoryAxes(categoryAxes);
            this.addTagsToObject((List<String>)dataSetDescriptor.tags(), VisualizationDefinition.DataSets.DataSet.class, dataSet);
            dataSets.getDataSet().add(dataSet);
            this.definition.setDataSets(dataSets);
        }
    }

    private List<String> createSlots(VisualizationDefinition.DataSets.DataSet.ValueAxis valueAxis, VisualizationDefinition.DataSets.DataSet.CategoryAxes categoryAxes, ArrayEx<DataSlotDescriptor> dataSlotDescriptorArray, VisualizationDefinition.Slots slots, List<String> listOfSlots) {
        VisualizationDefinition.DataSets.DataSet.ValueAxis.ValueAxisSet valueAxisSet = null;
        HashMap<Set, Integer> edgePositionMap = new HashMap<Set, Integer>();
        for (DataSlotDescriptor dataSlotDescriptor : dataSlotDescriptorArray) {
            if (dataSlotDescriptor.isHidden()) continue;
            ArrayEx dataTypeArray = dataSlotDescriptor.dataTypes();
            String id = dataSlotDescriptor.id();
            Label label = new Label();
            label.setValue(dataSlotDescriptor.label());
            Tooltip tooltip = new Tooltip();
            tooltip.setValue(dataSlotDescriptor.description());
            DataTypes dataTypes = new DataTypes();
            dataTypes.setValue(dataTypeArray.toString());
            Boolean optionalSlot = !"1".equalsIgnoreCase(dataSlotDescriptor.cardinality());
            ArrayEx tagsArray = dataSlotDescriptor.tags();
            Boolean isCategorical = dataTypeArray.contains("string") || tagsArray.contains("ca.reporting.categorical");
            if (isCategorical.booleanValue()) {
                this.createCategorySlot(categoryAxes, slots, id, label, tooltip, dataTypes, listOfSlots, optionalSlot, (List<String>)tagsArray, edgePositionMap);
                continue;
            }
            if (!dataTypeArray.contains("numeric")) continue;
            valueAxisSet = this.createValueSlot(valueAxis, slots, valueAxisSet, id, label, tooltip, dataTypes, listOfSlots, optionalSlot, (List<String>)tagsArray);
        }
        return listOfSlots;
    }

    private VisualizationDefinition.DataSets.DataSet.ValueAxis.ValueAxisSet createValueSlot(VisualizationDefinition.DataSets.DataSet.ValueAxis valueAxis, VisualizationDefinition.Slots slots, VisualizationDefinition.DataSets.DataSet.ValueAxis.ValueAxisSet valueAxisSet, String id, Label label, Tooltip tooltip, DataTypes dataTypes, List<String> listOfSlots, Boolean optionalSlot, List<String> tagsArray) {
        ValueSlot valueSlot = this.factory.createValueSlot();
        valueSlot.setName(id);
        valueSlot.setSupportsRange(false);
        valueSlot.setLabel(label);
        valueSlot.setTooltip(tooltip);
        valueSlot.setDataTypes(dataTypes);
        valueSlot.setOptional(optionalSlot);
        if (!listOfSlots.contains(id)) {
            listOfSlots.add(id);
            slots.getCategorySlotOrValueSlot().add(valueSlot);
        }
        this.addTagsToObject(tagsArray, ValueSlot.class, valueSlot);
        VisualizationDefinition.DataSets.DataSet.ValueAxis.ValueAxisSet valueAxisSetUpdated = valueAxisSet == null ? this.factory.createVisualizationDefinitionDataSetsDataSetValueAxisValueAxisSet() : valueAxisSet;
        VisualizationDefinition.DataSets.DataSet.ValueAxis.ValueAxisSet.ValueAxisValue valueAxisValue = this.factory.createVisualizationDefinitionDataSetsDataSetValueAxisValueAxisSetValueAxisValue();
        valueAxisValue.setRefSlot(id);
        valueAxisSetUpdated.getValueAxisValue().add(valueAxisValue);
        valueAxis.setValueAxisSet(valueAxisSetUpdated);
        return valueAxisSetUpdated;
    }

    private void createCategorySlot(VisualizationDefinition.DataSets.DataSet.CategoryAxes categoryAxes, VisualizationDefinition.Slots slots, String id, Label label, Tooltip tooltip, DataTypes dataTypes, List<String> listOfSlots, Boolean optionalSlot, List<String> tagsArray, HashMap<Set, Integer> edgePositionMap) {
        CategorySlot categorySlot = this.factory.createCategorySlot();
        categorySlot.setName(id);
        categorySlot.setCategoryValues("indexedVisible");
        categorySlot.setLabel(label);
        categorySlot.setTooltip(tooltip);
        categorySlot.setDataTypes(dataTypes);
        categorySlot.setOptional(optionalSlot);
        if (!listOfSlots.contains(id)) {
            listOfSlots.add(id);
            slots.getCategorySlotOrValueSlot().add(categorySlot);
        }
        this.addTagsToObject(tagsArray, CategorySlot.class, categorySlot);
        String edgeId = null;
        Integer edgePosition = null;
        for (String tag : tagsArray) {
            if (tag.startsWith("ca.reporting.edgeId:")) {
                edgeId = tag.substring("ca.reporting.edgeId:".length());
                continue;
            }
            if (!tag.startsWith("ca.reporting.edgePosition:")) continue;
            edgePosition = new Integer(tag.substring("ca.reporting.edgePosition:".length()));
        }
        if (edgeId != null && edgePosition != null) {
            List<VisualizationDefinition.DataSets.DataSet.CategoryAxes.CategoryAxis> axes = categoryAxes.getCategoryAxis();
            VisualizationDefinition.DataSets.DataSet.CategoryAxes.CategoryAxis edgeAxis = null;
            for (VisualizationDefinition.DataSets.DataSet.CategoryAxes.CategoryAxis axis : axes) {
                if (!axis.getName().equals(edgeId)) continue;
                edgeAxis = axis;
                break;
            }
            if (edgeAxis == null) {
                edgeAxis = this.factory.createVisualizationDefinitionDataSetsDataSetCategoryAxesCategoryAxis();
                VisualizationDefinition.DataSets.DataSet.CategoryAxes.CategoryAxis.AxisStructure axisStructure = this.factory.createVisualizationDefinitionDataSetsDataSetCategoryAxesCategoryAxisAxisStructure();
                VisualizationDefinition.DataSets.DataSet.CategoryAxes.CategoryAxis.AxisStructure.Nest nest = this.factory.createVisualizationDefinitionDataSetsDataSetCategoryAxesCategoryAxisAxisStructureNest();
                axisStructure.setNest(nest);
                edgeAxis.setAxisStructure(axisStructure);
                edgeAxis.setName(edgeId);
                axes.add(edgeAxis);
            }
            Set set = this.factory.createSet();
            set.setRefSlot(id);
            edgePositionMap.put(set, edgePosition);
            List<Set> edgeSets = edgeAxis.getAxisStructure().getNest().getSet();
            int pos = edgeSets.size();
            for (int i = 0; i < edgeSets.size(); ++i) {
                Set edgeSet = edgeSets.get(i);
                if (edgePositionMap.get(edgeSet) <= edgePosition) continue;
                pos = i;
                break;
            }
            edgeSets.add(pos, set);
        } else {
            VisualizationDefinition.DataSets.DataSet.CategoryAxes.CategoryAxis categoryAxis = this.factory.createVisualizationDefinitionDataSetsDataSetCategoryAxesCategoryAxis();
            VisualizationDefinition.DataSets.DataSet.CategoryAxes.CategoryAxis.AxisStructure axisStructure = this.factory.createVisualizationDefinitionDataSetsDataSetCategoryAxesCategoryAxisAxisStructure();
            Set set = this.factory.createSet();
            set.setRefSlot(id);
            axisStructure.setSet(set);
            categoryAxis.setAxisStructure(axisStructure);
            String axisName = id.concat("Edge");
            categoryAxis.setName(axisName);
            categoryAxes.getCategoryAxis().add(categoryAxis);
        }
    }

    private void addTagsToObject(List<String> tagsArray, Class<? extends Object> theClass, Object theObject) {
        Tags tags = this.factory.createTags();
        CustomProperties customProperties = this.factory.createCustomProperties();
        for (String tagObject : tagsArray) {
            if (tagObject.startsWith("ca.chart.definition.")) {
                this.addReportingPropertyToObject(theClass, theObject, tagObject);
                continue;
            }
            if (tagObject.contains("=")) {
                this.addCustomPropertyToList(customProperties, tagObject);
                continue;
            }
            this.addTagToList(tags, tagObject);
        }
        if (!tags.getTag().isEmpty()) {
            this.addPureTagsToObject(theClass, theObject, tags);
        }
        if (!customProperties.getCustomProperty().isEmpty()) {
            this.addCustomPropertiesToObject(theClass, theObject, customProperties);
        }
    }

    private void addCustomPropertiesToObject(Class<? extends Object> theClass, Object theObject, CustomProperties customProperties) {
        try {
            Method setCustomPropertiesMethod = theClass.getMethod("setCustomProperties", CustomProperties.class);
            setCustomPropertiesMethod.invoke(theObject, customProperties);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            // empty catch block
        }
    }

    private void addPureTagsToObject(Class<? extends Object> theClass, Object theObject, Tags tags) {
        try {
            Method setTagsMethod = theClass.getMethod("setTags", Tags.class);
            setTagsMethod.invoke(theObject, tags);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            // empty catch block
        }
    }

    private void addTagToList(Tags tags, String tagObject) {
        Tags.Tag tag = this.factory.createTagsTag();
        tag.setValue(tagObject);
        tags.getTag().add(tag);
    }

    private void addCustomPropertyToList(CustomProperties customProperties, String tagObject) {
        CustomProperties.CustomProperty customProperty = this.factory.createCustomPropertiesCustomProperty();
        String[] parts = tagObject.split("=");
        customProperty.setName(parts[0]);
        customProperty.setValue(parts[1]);
        customProperties.getCustomProperty().add(customProperty);
    }

    private void addReportingPropertyToObject(Class<? extends Object> theClass, Object theObject, String tagObject) {
        String[] parts = tagObject.split("=");
        String name = parts[0];
        String value = parts[1];
        if ("outputType".equals(name)) {
            this.outputType = value;
        }
        String name2 = name.substring(name.lastIndexOf(46) + 1);
        String methodName = "set" + name2.substring(0, 1).toUpperCase(Locale.ROOT) + name2.substring(1);
        try {
            if ("true".equals(value) || "false".equals(value)) {
                Method methodNameMethod = theClass.getMethod(methodName, Boolean.class);
                methodNameMethod.invoke(theObject, new Boolean(value));
            } else {
                Method methodNameMethod = theClass.getMethod(methodName, String.class);
                methodNameMethod.invoke(theObject, value);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new GalleryServiceException((ErrorCode)GalleryAPIErrorCode.galleryRequestError, new Throwable(theObject.toString() + ":" + methodName));
        }
    }

    private void addProperties(BundleInfo bundleInfo, String internalBundleName) {
        Properties defProps = this.factory.createProperties();
        HashMap<String, Object> propertiesMap = this.getBundleProperties(bundleInfo);
        PresentationItems[] presentationItemsArray = this.getBundlePresentationItems(bundleInfo);
        GroupProperties commonGroupProperties = null;
        if (presentationItemsArray.length > 0) {
            for (PresentationItems presentationItems : presentationItemsArray) {
                PresentationItems[] itemsArray;
                presentationItems.id();
                PropertyGroupMeta propertyGroupMeta = (PropertyGroupMeta)presentationItems;
                Properties.PropertiesGroup propertiesGroup = this.factory.createPropertiesPropertiesGroup();
                propertiesGroup.setName(propertyGroupMeta.id());
                Label label = new Label();
                label.setValue(propertyGroupMeta.name());
                propertiesGroup.setLabel(label);
                Description description = new Description();
                description.setValue(propertyGroupMeta.description());
                propertiesGroup.setDescription(description);
                GroupProperties groupProperties = this.factory.createGroupProperties();
                if (propertyGroupMeta.id().equals("commonProperties")) {
                    commonGroupProperties = groupProperties;
                }
                String[] groupTags = propertyGroupMeta.tags();
                for (PresentationItems item : itemsArray = propertyGroupMeta.presentationItems()) {
                    PropertyReferenceMeta propertyReferenceMeta = (PropertyReferenceMeta)item;
                    String id = propertyReferenceMeta.id();
                    Object propertyObj = propertiesMap.get(id);
                    if (groupTags.length > 0) {
                        this.addTagsToObject(Arrays.asList(groupTags), propertyObj.getClass(), propertyObj);
                    }
                    groupProperties.getPropertyTypes().add(propertyObj);
                    propertiesMap.remove(id);
                }
                if (propertyGroupMeta.id().endsWith("SpecificProperties")) {
                    this.createBundleSpecificProperties(groupProperties, internalBundleName);
                }
                propertiesGroup.setGroupProperties(groupProperties);
                defProps.getStringPropertyOrIntegerPropertyOrDecimalProperty().add(propertiesGroup);
            }
        }
        this.createMissingProperty(commonGroupProperties, defProps, "width");
        this.createMissingProperty(commonGroupProperties, defProps, "height");
        if (!defProps.getStringPropertyOrIntegerPropertyOrDecimalProperty().isEmpty()) {
            this.definition.setProperties(defProps);
        }
    }

    private PresentationItems[] getBundlePresentationItems(BundleInfo bundleInfo) {
        ArrayEx propertyPresentations = bundleInfo.propertyPresentations();
        for (PropertyPresentationMeta propertyPresentation : propertyPresentations) {
            if (!Arrays.asList(propertyPresentation.tags()).contains("ca.reporting")) continue;
            return propertyPresentation.presentationItems();
        }
        return new PresentationItems[0];
    }

    private HashMap<String, Object> getBundleProperties(BundleInfo bundleInfo) {
        HashMap<String, Object> propertiesMap = new HashMap<String, Object>();
        ArrayEx properties = bundleInfo.properties();
        for (PropertyMeta property : properties) {
            Object propertyObj;
            String type = property.type();
            Object defaultValue = property.defaultValue();
            List options = property.options();
            String id = property.id();
            String description = property.description();
            Description desc = new Description();
            desc.setValue(description);
            String name = property.name();
            Label label = new Label();
            label.setValue(name);
            if (options != null && !options.isEmpty() && !"palette".equalsIgnoreCase(type)) {
                type = "enum";
            }
            if ((propertyObj = this.createProperty(property, type, defaultValue, options, id, desc, label)) == null) continue;
            propertiesMap.put(id, propertyObj);
        }
        return propertiesMap;
    }

    private Object createProperty(PropertyMeta property, String type, Object defaultValue, List<StringPropertyOption> options, String id, Description desc, Label label) {
        Object propertyObj = null;
        if ("string".equalsIgnoreCase(type)) {
            propertyObj = this.createStringProperty((PropertyStringType)property, defaultValue, id, desc, label);
        } else if ("enum".equalsIgnoreCase(type)) {
            propertyObj = this.createEnumProperty(defaultValue, options, id, desc, label);
        } else if ("boolean".equalsIgnoreCase(type)) {
            PropertyBooleanType propBoolType = (PropertyBooleanType)property;
            Boolean defaultVal = null;
            if (defaultValue instanceof String) {
                defaultVal = Boolean.valueOf((String)defaultValue);
            } else if (defaultValue instanceof Boolean) {
                defaultVal = (Boolean)defaultValue;
            }
            propertyObj = this.createBooleanProperty(propBoolType, defaultVal, id, desc, label);
        } else if ("numeric".equalsIgnoreCase(type)) {
            PropertyNumericType propertyNumericType = (PropertyNumericType)property;
            Boolean isDecimal = propertyNumericType.decimal();
            propertyObj = isDecimal.booleanValue() ? this.createDecimalProperty(propertyNumericType, defaultValue, id, desc, label) : this.createIntegerProperty(propertyNumericType, defaultValue, id, desc, label);
        } else if ("palette".equalsIgnoreCase(type)) {
            propertyObj = this.createPaletteProperty("", id, desc, label);
        } else if ("color".equalsIgnoreCase(type)) {
            propertyObj = this.createCssColorProperty(defaultValue, id, desc, label);
        } else if ("jsonobject".equalsIgnoreCase(type)) {
            propertyObj = this.createJsonProperty(id, desc, label);
        } else if ("font".equalsIgnoreCase(type)) {
            propertyObj = this.createCssFontProperty(defaultValue, id, desc, label);
        } else if ("length".equalsIgnoreCase(type)) {
            propertyObj = this.createLengthProperty(defaultValue, id, desc, label);
        } else if ("padding".equalsIgnoreCase(type)) {
            propertyObj = this.createCssPaddingProperty(defaultValue, id, desc, label);
        } else if ("dasharray".equalsIgnoreCase(type)) {
            propertyObj = this.createCssStrokeDashArrayProperty(defaultValue, id, desc, label);
        }
        return propertyObj;
    }

    private Properties.JsonProperty createJsonProperty(String id, Description desc, Label label) {
        Properties.JsonProperty jsonProperty = this.factory.createPropertiesJsonProperty();
        jsonProperty.setName(id);
        jsonProperty.setLabel(label);
        jsonProperty.setDescription(desc);
        return jsonProperty;
    }

    private Properties.ColorPaletteProperty createPaletteProperty(Object defaultValue, String id, Description desc, Label label) {
        Properties.ColorPaletteProperty colorPaletteProperty = this.factory.createPropertiesColorPaletteProperty();
        colorPaletteProperty.setName(id);
        colorPaletteProperty.setLabel(label);
        colorPaletteProperty.setDescription(desc);
        if (defaultValue != null) {
            // empty if block
        }
        return colorPaletteProperty;
    }

    private Properties.DecimalProperty createDecimalProperty(PropertyNumericType propertyNumericType, Object defaultValue, String id, Description desc, Label label) {
        double max;
        Properties.DecimalProperty decimalProperty = this.factory.createPropertiesDecimalProperty();
        decimalProperty.setName(id);
        double min = propertyNumericType.min();
        if (!Double.isNaN(min)) {
            decimalProperty.setMin(BigDecimal.valueOf((long)min));
        }
        if (!Double.isNaN(max = propertyNumericType.max())) {
            decimalProperty.setMax(BigDecimal.valueOf((long)max));
        }
        decimalProperty.setLabel(label);
        if (defaultValue != null) {
            double defaultValueDouble = Double.parseDouble(defaultValue.toString());
            decimalProperty.setDefaultDecimal(BigDecimal.valueOf((long)defaultValueDouble));
        }
        decimalProperty.setDescription(desc);
        decimalProperty.setOutputType(this.outputType);
        return decimalProperty;
    }

    private Properties.IntegerProperty createIntegerProperty(PropertyNumericType propertyNumericType, Object defaultValue, String id, Description desc, Label label) {
        double max;
        Properties.IntegerProperty intProperty = this.factory.createPropertiesIntegerProperty();
        intProperty.setName(id);
        double min = propertyNumericType.min();
        if (!Double.isNaN(min)) {
            intProperty.setMin(BigInteger.valueOf((long)min));
        }
        if (!Double.isNaN(max = propertyNumericType.max())) {
            intProperty.setMax(BigInteger.valueOf((long)max));
        }
        intProperty.setLabel(label);
        if (defaultValue != null) {
            double defaultValueDouble = Double.parseDouble(defaultValue.toString());
            intProperty.setDefaultInteger(BigInteger.valueOf((long)defaultValueDouble));
        }
        intProperty.setDescription(desc);
        intProperty.setOutputType(this.outputType);
        return intProperty;
    }

    private Properties.CssColorProperty createCssColorProperty(Object defaultValue, String id, Description desc, Label label) {
        Properties.CssColorProperty colorProperty = this.factory.createPropertiesCssColorProperty();
        colorProperty.setName(id);
        colorProperty.setLabel(label);
        colorProperty.setDescription(desc);
        if (defaultValue != null) {
            colorProperty.setDefaultCSSColor(defaultValue.toString());
        }
        return colorProperty;
    }

    @Deprecated
    private Properties.ColorProperty createColorProperty(Object defaultValue, String id, Description desc, Label label) {
        Properties.ColorProperty colorProperty = this.factory.createPropertiesColorProperty();
        colorProperty.setName(id);
        colorProperty.setLabel(label);
        colorProperty.setDescription(desc);
        if (defaultValue != null) {
            Properties.ColorProperty.DefaultColor defaultColor = new Properties.ColorProperty.DefaultColor();
            RGBA rgba = new RGBA();
            rgba.setR(255);
            rgba.setG(255);
            rgba.setB(255);
            rgba.setA(new BigDecimal(0));
            defaultColor.setRGBA(rgba);
            colorProperty.setDefaultColor(defaultColor);
        }
        return colorProperty;
    }

    private Properties.CssFontProperty createCssFontProperty(Object defaultValue, String id, Description desc, Label label) {
        Properties.CssFontProperty fontProperty = this.factory.createPropertiesCssFontProperty();
        fontProperty.setName(id);
        fontProperty.setLabel(label);
        fontProperty.setDescription(desc);
        if (defaultValue != null) {
            fontProperty.setDefaultCSSFont(defaultValue.toString());
        }
        return fontProperty;
    }

    private Properties.LengthProperty createLengthProperty(Object defaultValue, String id, Description desc, Label label) {
        Properties.LengthProperty property = this.factory.createPropertiesLengthProperty();
        property.setName(id);
        property.setLabel(label);
        property.setDescription(desc);
        if (defaultValue != null) {
            property.setDefaultLength(defaultValue.toString());
        }
        return property;
    }

    private Properties.CssPaddingProperty createCssPaddingProperty(Object defaultValue, String id, Description desc, Label label) {
        Properties.CssPaddingProperty property = this.factory.createPropertiesCssPaddingProperty();
        property.setName(id);
        property.setLabel(label);
        property.setDescription(desc);
        if (defaultValue != null) {
            property.setDefaultPadding(defaultValue.toString());
        }
        return property;
    }

    private Properties.CssStrokeDashArrayProperty createCssStrokeDashArrayProperty(Object defaultValue, String id, Description desc, Label label) {
        Properties.CssStrokeDashArrayProperty property = this.factory.createPropertiesCssStrokeDashArrayProperty();
        property.setName(id);
        property.setLabel(label);
        property.setDescription(desc);
        if (defaultValue != null) {
            property.setDefaultStrokeDashArray(defaultValue.toString());
        }
        return property;
    }

    private Properties.BooleanProperty createBooleanProperty(PropertyBooleanType propBoolType, Boolean defaultValue, String id, Description desc, Label label) {
        Properties.BooleanProperty boolProperty = this.factory.createPropertiesBooleanProperty();
        Properties.BooleanProperty.TrueLabel boolTrueLabel = this.factory.createPropertiesBooleanPropertyTrueLabel();
        boolTrueLabel.setValue(propBoolType.trueLabel());
        Properties.BooleanProperty.FalseLabel boolFalseLabel = this.factory.createPropertiesBooleanPropertyFalseLabel();
        boolFalseLabel.setValue(propBoolType.falseLabel());
        boolProperty.setTrueLabel(boolTrueLabel);
        boolProperty.setFalseLabel(boolFalseLabel);
        boolProperty.setName(id);
        boolProperty.setLabel(label);
        if (defaultValue != null) {
            boolProperty.setDefaultBoolean(defaultValue);
        }
        boolProperty.setDescription(desc);
        return boolProperty;
    }

    private Properties.EnumProperty createEnumProperty(Object defaultValue, List<StringPropertyOption> options, String id, Description desc, Label label) {
        Properties.EnumProperty enumProperty = this.factory.createPropertiesEnumProperty();
        enumProperty.setName(id);
        enumProperty.setLabel(label);
        if (defaultValue != null) {
            enumProperty.setDefaultValue((String)defaultValue);
        }
        enumProperty.setDescription(desc);
        Properties.EnumProperty.EnumValues enumValues = this.factory.createPropertiesEnumPropertyEnumValues();
        for (StringPropertyOption option : options) {
            if (option == null || !(option instanceof StringPropertyOption)) continue;
            Properties.EnumProperty.EnumValues.EnumValue enumValue = this.factory.createPropertiesEnumPropertyEnumValuesEnumValue();
            StringPropertyOption stringPropertyOption = option;
            enumValue.setValue(stringPropertyOption.value());
            Label optionLabel = new Label();
            optionLabel.setValue(stringPropertyOption.label());
            enumValue.setLabel(optionLabel);
            enumValues.getEnumValue().add(enumValue);
        }
        enumProperty.setEnumValues(enumValues);
        return enumProperty;
    }

    private Properties.StringProperty createStringProperty(PropertyStringType propertyStringType, Object defaultValue, String id, Description desc, Label label) {
        Properties.StringProperty stringProperty = this.factory.createPropertiesStringProperty();
        if (propertyStringType != null) {
            int stringMinLength = propertyStringType.minLength();
            int stringMaxLength = propertyStringType.maxLength();
            String stringPropRegex = propertyStringType.regularExpression();
            if (stringMinLength > 0) {
                stringProperty.setMinLength(stringMinLength);
            }
            if (stringMaxLength > 0) {
                stringProperty.setMinLength(stringMaxLength);
            }
            if (stringPropRegex != null) {
                stringProperty.setRegEx(stringPropRegex);
            }
        }
        stringProperty.setName(id);
        stringProperty.setLabel(label);
        if (defaultValue != null) {
            stringProperty.setDefaultString(defaultValue.toString());
        }
        stringProperty.setDescription(desc);
        return stringProperty;
    }

    private void createBundleSpecificProperties(GroupProperties groupProperties, String internalBundleName) {
        switch (internalBundleName) {
            case "tiledmapV2Bundle": {
                String localizedDescription;
                Properties.BooleanProperty prop = this.factory.createPropertiesBooleanProperty();
                prop.setName("hideGeoWarning");
                String localizedLabel = this.getLocalizedString("lblHideGeoWarning");
                if (localizedLabel != null) {
                    Label label = new Label();
                    label.setValue(localizedLabel);
                    prop.setLabel(label);
                }
                if ((localizedDescription = this.getLocalizedString("descHideGeoWarning")) != null) {
                    Description description = new Description();
                    description.setValue(localizedDescription);
                    prop.setDescription(description);
                }
                prop.setDefaultBoolean(new Boolean(false));
                groupProperties.getPropertyTypes().add(prop);
                break;
            }
        }
    }

    private void createMissingProperty(GroupProperties commonGroupProperties, Properties props, String dimension) {
        Properties.IntegerProperty intProperty = this.factory.createPropertiesIntegerProperty();
        intProperty.setName(dimension);
        String labelPrefix = "lbl";
        String descPrefix = "desc";
        Label label = new Label();
        String propertyName = intProperty.getName();
        String labelName = propertyName.substring(0, 1).toUpperCase(Locale.ROOT) + propertyName.substring(1);
        String localizedLabel = this.getLocalizedString(labelPrefix.concat(labelName));
        if (localizedLabel != null) {
            label.setValue(localizedLabel);
        }
        intProperty.setLabel(label);
        String localizedDescription = this.getLocalizedString(descPrefix.concat(labelName));
        if (localizedDescription != null) {
            Description description = new Description();
            description.setValue(localizedDescription);
            intProperty.setDescription(description);
        }
        intProperty.setOutputType(this.outputType);
        BigInteger defaultInteger = BigInteger.valueOf(500L);
        intProperty.setDefaultInteger(defaultInteger);
        if (commonGroupProperties != null) {
            commonGroupProperties.getPropertyTypes().add(intProperty);
        } else {
            props.getStringPropertyOrIntegerPropertyOrDecimalProperty().add(intProperty);
        }
    }

    private InputStream convertDefinitionToXMLStream(VisualizationDefinition definition) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Marshaller marshaller = this.context.createMarshaller();
            marshaller.setProperty("jaxb.fragment", (Object)true);
            marshaller.marshal((Object)definition, (OutputStream)baos);
            return new ByteArrayInputStream(baos.toByteArray());
        }
        catch (JAXBException e) {
            throw new GalleryServiceException((ErrorCode)GalleryAPIErrorCode.corruptedBundleDefinition, (Throwable)e);
        }
    }

    private String getLocalizedString(String key) {
        if (this.vgsBundle == null) {
            return null;
        }
        try {
            return this.vgsBundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    public void create(Selector root) {
        InputStream in;
        String internalBundleName;
        RaveBundle bundle = BundleLookup.getBundle((String)this.bundleName);
        Controller bundleInstance = bundle.create();
        bundleInstance.node(root);
        ArrayEx configurations = bundle.configurations();
        BundleInfo bundleInfo = null;
        for (BundleConfiguration config : configurations) {
            if (!this.configID.equalsIgnoreCase(config.id())) continue;
            bundleInfo = config.info();
            break;
        }
        if ("wordcloudBundle".equals(internalBundleName = this.bundleName.replace("rave-library-", "") + "Bundle")) {
            internalBundleName = "wordCloudBundle";
        }
        if ((in = this.getClass().getResourceAsStream("/com/ibm/rave/bundles/" + internalBundleName + "/i18n/messages_" + this.language + ".json")) == null) {
            in = this.getClass().getResourceAsStream("/com/ibm/rave/bundles/" + internalBundleName + "/i18n/messages_en.json");
            this.language = "en";
        }
        Locale resourceLocale = null;
        try {
            resourceLocale = VGSLocaleUtils.resolveLocale((String)this.language);
        }
        catch (GalleryServiceException galleryServiceException) {
            // empty catch block
        }
        if (resourceLocale != null) {
            try {
                this.vgsBundle = PropertyResourceBundle.getBundle("vgs", resourceLocale);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (in != null) {
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader(in, "UTF-8"));
                JSONObject catalog = (JSONObject)JSON.parse((Reader)br);
                bundleInstance.setMessageCatalog(this.language, catalog);
                bundleInstance.setLocale(this.language, "/com/ibm/rave/bundles/" + internalBundleName, null);
                this.addMetadata(this.bundleNameWithConfigID, bundleInfo);
                this.addProperties(bundleInfo, internalBundleName);
                this.addData(bundleInfo);
                this.addInteractiveType();
            }
            catch (Exception e) {
                throw new GalleryServiceException((ErrorCode)GalleryAPIErrorCode.corruptedBundleDefinition, (Throwable)e);
            }
        }
    }

    public void ready(Object arg0) {
    }

    public String css() {
        return null;
    }

    public int getHeight() {
        return 500;
    }

    public int getWidth() {
        return 500;
    }

    public void setException(Exception e) {
        throw new GalleryServiceException((ErrorCode)GalleryAPIErrorCode.galleryRequestError, (Throwable)e);
    }
}

