/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.vis.schema.definition;

import com.ibm.ba.vis.schema.definition.DefinitionValidator;
import com.ibm.ba.vis.vgs.error.ErrorCode;
import com.ibm.ba.vis.vgs.error.ErrorMessage;
import com.ibm.ba.vis.vgs.error.GalleryAPIErrorCode;
import com.ibm.ba.vis.vgs.error.GalleryServiceException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.io.IOUtils;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.SAXException;

class SaxDefinitionValidator
implements DefinitionValidator {
    private static final SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
    private static final Map<File, SaxDefinitionValidator> validators = new ConcurrentHashMap<File, SaxDefinitionValidator>();
    private final Schema definitionSchema;

    SaxDefinitionValidator(File definitionSchemaFile) throws SAXException {
        this(schemaFactory.newSchema(definitionSchemaFile));
    }

    SaxDefinitionValidator(Schema definitionSchema) {
        this.definitionSchema = definitionSchema;
    }

    @Override
    public void validate(InputStream inputStream) {
        try {
            Validator validator = this.definitionSchema.newValidator();
            this.preventExternalAccess(validator);
            StreamSource defSource = new StreamSource(inputStream);
            validator.validate(defSource);
        }
        catch (IOException e) {
            throw new GalleryServiceException((ErrorCode)GalleryAPIErrorCode.corruptedBundleDefinition, (Throwable)e);
        }
        catch (RuntimeException | SAXException e) {
            ErrorMessage msg = new ErrorMessage((ErrorCode)GalleryAPIErrorCode.invalidBundleDefinition);
            msg.addParameter("reason", e.getLocalizedMessage());
            throw new GalleryServiceException(msg, (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    private void preventExternalAccess(Validator validator) {
        validator.setResourceResolver(new LSResourceResolver(){

            @Override
            public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
                throw new RuntimeException("No external resources allowed.");
            }
        });
    }

    static synchronized SaxDefinitionValidator getInstance(File schemaFile) {
        try {
            SaxDefinitionValidator validator = validators.get(schemaFile);
            if (validator == null) {
                validator = new SaxDefinitionValidator(schemaFile);
                validators.put(schemaFile, validator);
            }
            return validator;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create " + SaxDefinitionValidator.class.getName() + " instance", e);
        }
    }
}

