/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.vizbundles.common;

import com.ibm.vida.vizbundles.common.AxisRole;
import com.ibm.vida.vizbundles.common.Orientation;

public class AxisUtil {
    private AxisUtil() {
    }

    public static Orientation axisPositionForRole(AxisRole _role, boolean _transpose, boolean _swapX, boolean _swapY) {
        Orientation defaultAxisPosition;
        boolean swapY = _transpose != _swapY;
        switch (_role) {
            case X1: {
                defaultAxisPosition = Orientation.Bottom;
                break;
            }
            case X2: {
                defaultAxisPosition = Orientation.Top;
                break;
            }
            case Y1: {
                defaultAxisPosition = Orientation.Left;
                break;
            }
            case Y2: {
                defaultAxisPosition = Orientation.Right;
                break;
            }
            default: {
                defaultAxisPosition = Orientation.Bottom;
            }
        }
        Orientation currentAxisPosition = defaultAxisPosition;
        if (_transpose) {
            currentAxisPosition = AxisUtil.transposedAxisPosition(currentAxisPosition);
        }
        if (_swapX && _role == AxisRole.X1 || _role == AxisRole.X2) {
            currentAxisPosition = AxisUtil.swappedXAxisPosition(currentAxisPosition, _swapX);
        }
        if (swapY && _role == AxisRole.Y1 || _role == AxisRole.Y2) {
            currentAxisPosition = AxisUtil.swappedYAxisPosition(currentAxisPosition, swapY);
        }
        return currentAxisPosition;
    }

    private static Orientation transposedAxisPosition(Orientation _axisPosition) {
        switch (_axisPosition) {
            case Bottom: {
                return Orientation.Left;
            }
            case Left: {
                return Orientation.Bottom;
            }
            case Top: {
                return Orientation.Right;
            }
            case Right: {
                return Orientation.Top;
            }
        }
        return _axisPosition;
    }

    private static Orientation swappedXAxisPosition(Orientation _axisPosition, boolean _swapX) {
        if (_swapX) {
            if (Orientation.Bottom == _axisPosition) {
                return Orientation.Top;
            }
            if (Orientation.Top == _axisPosition) {
                return Orientation.Bottom;
            }
        }
        return _axisPosition;
    }

    private static Orientation swappedYAxisPosition(Orientation _axisPosition, boolean _swapY) {
        if (_swapY) {
            if (Orientation.Left == _axisPosition) {
                return Orientation.Right;
            }
            if (Orientation.Right == _axisPosition) {
                return Orientation.Left;
            }
        }
        return _axisPosition;
    }
}

