/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.vizbundles.common.groupproperties;

import com.ibm.vida.rave.core.internal.collections.OMap;
import com.ibm.vida.rave.library.framework.CustomFormatInfo;
import com.ibm.vida.rave.library.framework.CustomFormatter;
import com.ibm.vida.vizbundles.common.rave2.Rave2Common;
import com.ibm.vipr.renderingservice.api.IRSColor;
import com.ibm.vipr.renderingservice.data.IRSCatDataItem;
import com.ibm.vipr.renderingservice.data.IRSContDataItem;
import com.ibm.vipr.renderingservice.data.IRSDataItem;
import com.ibm.vipr.renderingservice.data.IRSFormatter;
import com.ibm.vipr.renderingservice.data.IRSSlot;
import com.ibm.vipr.renderingservice.data.IRSTuple;
import com.ibm.vipr.renderingservice.data.RSDataItemType;
import com.ibm.vipr.renderingservice.data.RSFormatKind;
import com.ibm.vipr.renderingservice.property.Font;
import com.ibm.vipr.renderingservice.property.IRSColorProperty;
import com.ibm.vipr.renderingservice.property.IRSProperties;
import com.ibm.vipr.renderingservice.property.IRSValueProperty;
import com.ibm.vipr.renderingservice.property.Length;
import java.util.ArrayList;
import java.util.List;

public class AxisProperty {
    private final IRSValueProperty<Boolean> _showTitleProp;
    private final IRSValueProperty<Boolean> _showLineProp;
    private final IRSValueProperty<IRSColor> _lineColorProp;
    private final IRSValueProperty<String> _titleProp;
    private final IRSValueProperty<Font> _titleFontProp;
    private final IRSValueProperty<IRSColor> _titleColorProp;
    private final IRSValueProperty<Boolean> _showTicksProp;
    private final IRSColorProperty _tickColorProp;
    private final IRSValueProperty<Boolean> _showTickLabelsProp;
    private final IRSValueProperty<Font> _tickLabelFontProp;
    private final IRSValueProperty<String> _tickLabelModeProp;
    private final IRSValueProperty<Number> _tickLabelRotateAngle;
    private final IRSValueProperty<IRSColor> _tickLabelColorProp;
    private final IRSValueProperty<Number> _tickIntervalProp;
    private final IRSValueProperty<Boolean> _showGridLineProp;
    private final IRSValueProperty<IRSColor> _gridLineColor;
    private final IRSValueProperty<String> _gridLinePattern;
    private final IRSValueProperty<Boolean> _logarithmicProp;
    private boolean _smallAxisLength;
    private boolean _smallVizCategory;
    private IRSSlot _slot;
    private List<IRSTuple> _domainTuples;
    private static final Font DEFAULT_FONT = Font.create(null, (Length)Length.parse((String)"0.75em"), null, null);
    private static final Font DEFAULT_FONT_SMALL = Font.create(null, (Length)Length.parse((String)"0.65em"), null, null);

    public AxisProperty(String _propBasePrefix, IRSProperties _properties) {
        this._showTitleProp = _properties.getBoolean(_propBasePrefix + ".title.visible");
        this._showLineProp = _properties.getBoolean(_propBasePrefix + ".line.visible");
        this._lineColorProp = _properties.getColor(_propBasePrefix + ".line.color");
        this._titleProp = _properties.getString(_propBasePrefix + ".title");
        this._titleFontProp = _properties.getFont(_propBasePrefix + ".title.font");
        this._titleColorProp = _properties.getColor(_propBasePrefix + ".title.color");
        this._showTicksProp = _properties.getBoolean(_propBasePrefix + ".ticks.visible");
        this._tickColorProp = _properties.getColor(_propBasePrefix + ".ticks.color");
        this._showTickLabelsProp = _properties.getBoolean(_propBasePrefix + ".ticks.labels.visible");
        this._tickLabelFontProp = _properties.getFont(_propBasePrefix + ".ticks.labels.font");
        this._tickLabelColorProp = _properties.getColor(_propBasePrefix + ".ticks.labels.color");
        this._tickLabelModeProp = _properties.getEnum(_propBasePrefix + ".ticks.labels.layoutMode");
        this._tickLabelRotateAngle = _properties.getNumber(_propBasePrefix + ".ticks.labels.rotateAngle");
        this._tickIntervalProp = _properties.getNumber(_propBasePrefix + ".tickInterval");
        this._showGridLineProp = _properties.getBoolean(_propBasePrefix + ".gridLines.visible");
        this._gridLineColor = _properties.getColor(_propBasePrefix + ".gridLines.color");
        this._gridLinePattern = _properties.getString(_propBasePrefix + ".gridLines.dashPattern");
        this._logarithmicProp = _properties.getBoolean(_propBasePrefix + ".logarithmic");
        this._smallAxisLength = false;
        this._smallVizCategory = false;
    }

    public AxisProperty setSlot(IRSSlot _slot) {
        this._slot = _slot;
        List dataItems = this._slot.getDataItems();
        if (((IRSDataItem)dataItems.get(0)).getType() == RSDataItemType.Cat) {
            IRSCatDataItem catDataItem = (IRSCatDataItem)dataItems.get(0);
            this._domainTuples = catDataItem.getTuples();
        }
        return this;
    }

    public AxisProperty setSmall(boolean _smallAxisLength, boolean _smallVizCategory) {
        this._smallAxisLength = _smallAxisLength;
        this._smallVizCategory = _smallVizCategory;
        return this;
    }

    private String slotCaption() {
        if (this._slot != null && this._slot.isMapped()) {
            IRSDataItem dataItem = this._slot.getDataItem(0);
            return dataItem.combineCaptions(RSFormatKind.Label);
        }
        return "";
    }

    private void toggleActiveFlag(boolean _flag) {
        ArrayList<Object> propArr = new ArrayList<Object>();
        propArr.add(this._showTitleProp);
        propArr.add(this._showLineProp);
        propArr.add(this._lineColorProp);
        propArr.add(this._titleProp);
        propArr.add(this._titleFontProp);
        propArr.add(this._titleColorProp);
        propArr.add(this._showTicksProp);
        propArr.add(this._tickColorProp);
        propArr.add(this._showTickLabelsProp);
        propArr.add(this._tickLabelFontProp);
        propArr.add(this._tickLabelColorProp);
        propArr.add(this._tickLabelModeProp);
        propArr.add(this._tickIntervalProp);
        propArr.add(this._showGridLineProp);
        propArr.add(this._gridLineColor);
        propArr.add(this._gridLinePattern);
        propArr.forEach(_prop -> {
            if (_prop != null) {
                _prop.setActive(_flag);
            }
        });
    }

    public void disableAll() {
        this.toggleActiveFlag(false);
    }

    public void enableAll() {
        this.toggleActiveFlag(true);
    }

    public boolean showTitle() {
        return !this._smallVizCategory && this.getValue(this._showTitleProp, false) != false;
    }

    public boolean showLine() {
        return !this._smallAxisLength && this.getValue(this._showLineProp, false) != false;
    }

    public String lineColor() {
        IRSColor value = this.getValue(this._lineColorProp, null);
        return Rave2Common.colorToString(value);
    }

    public String title() {
        String title = this.getValue(this._titleProp, null);
        return title != null && !title.isEmpty() ? title : this.slotCaption();
    }

    public OMap<String, Object> titleFont() {
        Font titleFont = this.getValue(this._titleFontProp, null);
        Font defaultFont = this._smallAxisLength ? DEFAULT_FONT_SMALL : DEFAULT_FONT;
        return Rave2Common.composeFontStyleProperty(Font.merge((Font)defaultFont, (Font)titleFont), this.getValue(this._titleColorProp, null));
    }

    public String titleFontCssString() {
        Font titleFont = this.getValue(this._titleFontProp, null);
        Font defaultFont = this._smallAxisLength ? DEFAULT_FONT_SMALL : DEFAULT_FONT;
        return Rave2Common.composeFontStylePropertyString(Font.merge((Font)defaultFont, (Font)titleFont), this.getValue(this._titleColorProp, null));
    }

    public boolean showTicks() {
        return !this._smallAxisLength && this.getValue(this._showTicksProp, false) != false;
    }

    public String tickColor() {
        IRSColor tickColor = this.getValue((IRSValueProperty)this._tickColorProp, null);
        return Rave2Common.colorToString(tickColor);
    }

    public CustomFormatter tickFormat() {
        if (this._slot == null) {
            return null;
        }
        CustomFormatter tickFormatter = null;
        List dataItems = this._slot.getDataItems();
        if (((IRSDataItem)dataItems.get(0)).getType() == RSDataItemType.Cont && (tickFormatter = this.getTickLogFormatter()) == null) {
            IRSContDataItem contDataItem = (IRSContDataItem)dataItems.get(0);
            final IRSFormatter formatter = contDataItem.getFormatter(RSFormatKind.Label);
            tickFormatter = new CustomFormatter(){

                public String getValue(Object context, Object value, int index, int groupIndex, CustomFormatInfo info, boolean simplified) {
                    return formatter.format(value);
                }
            };
        }
        if (((IRSDataItem)dataItems.get(0)).getType() == RSDataItemType.Cat) {
            final List<IRSTuple> domainTuples = this._domainTuples;
            tickFormatter = new CustomFormatter(){

                public String getValue(Object context, Object value, int index, int groupIndex, CustomFormatInfo info, boolean simplified) {
                    int i = 0;
                    while (index < domainTuples.size()) {
                        IRSTuple tuple = (IRSTuple)domainTuples.get(i);
                        if (value.toString().equals(tuple.getKey())) {
                            return tuple.getCaption(RSFormatKind.Label);
                        }
                        ++i;
                    }
                    return "";
                }
            };
        }
        return tickFormatter;
    }

    private CustomFormatter getTickLogFormatter() {
        if (!this.getValue(this._logarithmicProp, false).booleanValue()) {
            return null;
        }
        List dataItems = this._slot.getDataItems();
        if (((IRSDataItem)dataItems.get(0)).getType() == RSDataItemType.Cont) {
            IRSContDataItem contDataItem = (IRSContDataItem)dataItems.get(0);
            final IRSFormatter formatter = contDataItem.getFormatter(RSFormatKind.Label);
            return new CustomFormatter(){

                public String getValue(Object context, Object value, int index, int groupIndex, CustomFormatInfo info, boolean simplified) {
                    if (Math.log10(Math.abs((Double)value)) % 1.0 == 0.0) {
                        return formatter.format(value);
                    }
                    return "";
                }
            };
        }
        return null;
    }

    public Number tickInterval() {
        return this.getValue(this._tickIntervalProp, 0);
    }

    public boolean showTickLabels() {
        return !this._smallAxisLength && this.getValue(this._showTickLabelsProp, false) != false;
    }

    public String tickLabelMode() {
        return this.getValue(this._tickLabelModeProp, "Horizontal");
    }

    public Number tickLabelRotateAngle() {
        return this.getValue(this._tickLabelRotateAngle, 45.0);
    }

    public OMap<String, Object> tickLabelFont() {
        Font tickLabelFont = this.getValue(this._tickLabelFontProp, null);
        Font defaultFont = this._smallAxisLength ? DEFAULT_FONT_SMALL : DEFAULT_FONT;
        return Rave2Common.composeFontStyleProperty(Font.merge((Font)defaultFont, (Font)tickLabelFont), this.getValue(this._tickLabelColorProp, null));
    }

    public String tickLabelFontCssString() {
        Font tickLabelFont = this.getValue(this._tickLabelFontProp, null);
        Font defaultFont = this._smallAxisLength ? DEFAULT_FONT_SMALL : DEFAULT_FONT;
        return Rave2Common.composeFontStylePropertyString(Font.merge((Font)defaultFont, (Font)tickLabelFont), this.getValue(this._tickLabelColorProp, null));
    }

    public boolean showGridLines() {
        return this.getValue(this._showGridLineProp, false);
    }

    public String gridLineColor() {
        IRSColor gridLineColor = this.getValue(this._gridLineColor, null);
        return Rave2Common.colorToString(gridLineColor);
    }

    public String gridPattern() {
        return this.getValue(this._gridLinePattern, "");
    }

    private <T> T getValue(IRSValueProperty<T> _property, T _default) {
        if (_property == null || !_property.isActive()) {
            return _default;
        }
        Object value = _property.getValue();
        return (T)(value != null ? value : _default);
    }
}

