/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.vizbundles.common.groupproperties;

import com.ibm.vipr.renderingservice.data.IRSContDomain;
import com.ibm.vipr.renderingservice.property.IRSProperties;
import com.ibm.vipr.renderingservice.property.IRSValueProperty;
import java.util.ArrayList;

public class AxisScaleProperty {
    private final IRSValueProperty<Boolean> _niceScalingProp;
    private final IRSValueProperty<Boolean> _zeroOriginProp;
    private final IRSValueProperty<Number> _minValueProp;
    private final IRSValueProperty<Number> _maxValueProp;
    private final IRSValueProperty<Boolean> _logarithmicProp;
    private final IRSValueProperty<Number> _tickIntervalProp;
    private boolean _smallAxisLength;
    private boolean _isPercentMode;

    public AxisScaleProperty(String _prefix, IRSProperties _properties) {
        this._niceScalingProp = _properties.getBoolean(_prefix + ".niceScaling");
        this._zeroOriginProp = _properties.getBoolean(_prefix + ".zeroOrigin");
        this._minValueProp = _properties.getNumber(_prefix + ".minValue");
        this._maxValueProp = _properties.getNumber(_prefix + ".maxValue");
        this._logarithmicProp = _properties.getBoolean(_prefix + ".logarithmic");
        this._tickIntervalProp = _properties.getNumber(_prefix + ".tickInterval");
    }

    private static boolean isLogScaleSupported(IRSContDomain _domain, IRSContDomain _domainOppositeAxis) {
        double signDomainMin = Math.signum(_domain.getMin());
        if ((signDomainMin == 1.0 || signDomainMin == -1.0) && signDomainMin == Math.signum(_domain.getMax())) {
            if (_domainOppositeAxis == null) {
                return true;
            }
            if (signDomainMin == Math.signum(_domainOppositeAxis.getMin()) && signDomainMin == Math.signum(_domainOppositeAxis.getMax())) {
                return true;
            }
        }
        return false;
    }

    public void adjustPropertyState(boolean _isContinuous, IRSContDomain _domain) {
        this.adjustPropertyState(_isContinuous, _domain, null);
    }

    public void adjustPropertyState(boolean _isContinuous, IRSContDomain _domain, IRSContDomain _domainOppositeAxis) {
        this.toggleFlag(_isContinuous);
        if (!_isContinuous) {
            return;
        }
        if (this._isPercentMode) {
            this.disableAll();
            this._zeroOriginProp.setActive(true);
            return;
        }
        if (this._zeroOriginProp != null) {
            this._zeroOriginProp.setActive(this.getZeroOriginActiveState(_domain, _domainOppositeAxis));
        }
        if (this._niceScalingProp != null) {
            this._niceScalingProp.setActive(this.getNiceScalingActiveState(_domain));
        }
        if (this._logarithmicProp != null && _domain != null) {
            boolean tickIntervalActive;
            boolean isLogScaleSupported = AxisScaleProperty.isLogScaleSupported(_domain, _domainOppositeAxis);
            this._logarithmicProp.setActive(isLogScaleSupported);
            boolean bl = tickIntervalActive = (Boolean)this._logarithmicProp.getValue() == false || !this._logarithmicProp.isActive();
            if (this._tickIntervalProp != null) {
                this._tickIntervalProp.setActive(tickIntervalActive);
            }
        }
    }

    private boolean getZeroOriginActiveState(IRSContDomain _domain, IRSContDomain _domainOppositeAxis) {
        boolean isLogScaleSupported;
        if (_domain != null && _domain.isExplicit()) {
            return false;
        }
        Number minVal = this.minValue();
        Number maxVal = this.maxValue();
        if (minVal != null && minVal.intValue() > 0 || maxVal != null && maxVal.intValue() < 0) {
            return false;
        }
        return this._logarithmicProp == null || _domain == null || !(isLogScaleSupported = AxisScaleProperty.isLogScaleSupported(_domain, _domainOppositeAxis)) || (Boolean)this._logarithmicProp.getValue() == false;
    }

    private boolean getNiceScalingActiveState(IRSContDomain _domain) {
        if (_domain != null && _domain.isExplicit()) {
            return false;
        }
        Number minVal = this.minValue();
        Number maxVal = this.maxValue();
        return minVal == null || maxVal == null;
    }

    public void setPercentageMode(boolean _flag) {
        this._isPercentMode = _flag;
        this.adjustPropertyState(true, null);
    }

    public void disableAll() {
        this.toggleFlag(false);
    }

    public void enableAll() {
        this.toggleFlag(true);
    }

    public boolean isDirty() {
        ArrayList<Object> arr = new ArrayList<Object>();
        arr.add(this._niceScalingProp);
        arr.add(this._zeroOriginProp);
        arr.add(this._logarithmicProp);
        arr.add(this._tickIntervalProp);
        arr.add(this._minValueProp);
        arr.add(this._maxValueProp);
        return arr.stream().anyMatch(_property -> _property != null && _property.isDirty());
    }

    private void toggleFlag(boolean _flag) {
        if (this._niceScalingProp != null) {
            this._niceScalingProp.setActive(_flag);
        }
        if (this._zeroOriginProp != null) {
            this._zeroOriginProp.setActive(_flag);
        }
        if (this._tickIntervalProp != null) {
            this._tickIntervalProp.setActive(_flag);
        }
        if (this._logarithmicProp != null) {
            this._logarithmicProp.setActive(_flag);
        }
        if (this._minValueProp != null) {
            this._minValueProp.setActive(_flag);
        }
        if (this._maxValueProp != null) {
            this._maxValueProp.setActive(_flag);
        }
    }

    public void setSmall(boolean _smallAxisLength) {
        this._smallAxisLength = _smallAxisLength;
    }

    public boolean niceScale() {
        if (this._smallAxisLength) {
            return false;
        }
        return this._niceScalingProp == null || (Boolean)this._niceScalingProp.getValue() != false && this._niceScalingProp.isActive();
    }

    public boolean zeroOrigin() {
        return this._zeroOriginProp == null || (Boolean)this._zeroOriginProp.getValue() != false && this._zeroOriginProp.isActive();
    }

    public Number minValue() {
        return this._minValueProp == null || !this._minValueProp.isActive() ? (Number)null : (Number)((Number)this._minValueProp.getValue());
    }

    public Number maxValue() {
        return this._maxValueProp == null || !this._maxValueProp.isActive() ? (Number)null : (Number)((Number)this._maxValueProp.getValue());
    }

    public boolean logarithmic() {
        return this._logarithmicProp != null && this._logarithmicProp.isActive() && (Boolean)this._logarithmicProp.getValue() != false;
    }

    public Number tickInterval() {
        if (this._tickIntervalProp != null && this._tickIntervalProp.isActive()) {
            return (Number)this._tickIntervalProp.getValue();
        }
        return null;
    }
}

