/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.vizbundles.common.rave2;

import com.ibm.vida.rave.awt.internal.service.context.AWTRaveImageServiceContextManager;
import com.ibm.vida.rave.core.geom.PointStruct;
import com.ibm.vida.rave.library.ext.imagemap.ImageMap;
import com.ibm.vida.rave.library.ext.imagemap.ImageMapArguments;
import com.ibm.vida.rave.library.ext.imagemap.ImageMapCallback;
import com.ibm.vida.rave.library.ext.imagemap.ImageMapResult;
import com.ibm.vida.rave.library.ext.imagemap.ImageMapSceneItem;
import com.ibm.vida.rave.library.framework.internal.OrdinalCoordinateScaleDatum;
import com.ibm.vida.rave.render.internal.nodes.RootProvider;
import com.ibm.vipr.renderingservice.api.IRSImageMapEntry;
import com.ibm.vipr.renderingservice.api.IRSPoint;
import com.ibm.vipr.renderingservice.api.IRSRenderNotification;
import com.ibm.vipr.renderingservice.api.IRSRequest;
import com.ibm.vipr.renderingservice.api.IRSVisualizationImage;
import com.ibm.vipr.renderingservice.data.IRSDataNode;
import com.ibm.vipr.renderingservice.util.ImageMapEntry;
import com.ibm.vipr.renderingservice.util.Point;
import java.util.ArrayList;
import java.util.List;

public class BundleImageService
implements IRSRenderNotification {
    private final RootProvider root;
    private final IRSRenderNotification notification;

    public BundleImageService(RootProvider _root, IRSRenderNotification _notification) {
        this.root = _root;
        this.notification = _notification;
    }

    public void complete() {
        this.createImage(this.notification);
    }

    public void complete(String _id, Object _data) {
        if (_id.equals("visualizationImage") && _data instanceof IRSVisualizationImage) {
            this.notification.complete(_id, _data);
        } else {
            this.createImage(this.notification);
        }
    }

    public void fail(String _id, String _message, Object _data) {
        this.notification.fail(_id, _message, _data);
    }

    public void error(Throwable _t) {
        this.notification.error(_t);
    }

    public boolean waitingFor(IRSRequest _request) {
        return false;
    }

    public void progress(double _progress, String _id, String _message) {
    }

    public void createImage(IRSRenderNotification _notification) {
        AWTRaveImageServiceContextManager.getInstance().flushAllTimerEvents();
        if (this.root != null) {
            this.root.createImage(_image -> this.createImageMap(_image, _notification));
        } else {
            _notification.error((Throwable)new Exception("Cannot generically create an image without a RootProvider instance"));
        }
    }

    private void createImageMap(final Object _image, final IRSRenderNotification _notification) {
        ImageMapArguments args = ImageMap.INSTANCE.makeArguments(this.root.getRoot());
        args.types.add("element-*");
        args.types.add("legend-*");
        args.types.add("axis-*");
        args.flattenPixels = 4.0;
        args.outlinePixels = 1.0;
        args.expandPixels = 1.0;
        ImageMap im = ImageMap.INSTANCE;
        im.createImageMap(args, new ImageMapCallback(){

            public void ready(ImageMapResult result) {
                final ArrayList<ImageMapEntry> imageMap = new ArrayList<ImageMapEntry>(result.sceneItems().size());
                ItemTypesHelper types = new ItemTypesHelper();
                for (ImageMapSceneItem sceneItem : result.sceneItems()) {
                    if (!types.convert(sceneItem.type())) continue;
                    List<IRSPoint> points = this.convertPoints(sceneItem.points());
                    List<IRSDataNode> data = this.convertData(sceneItem.data());
                    imageMap.add(new ImageMapEntry(types.type, types.subType, data, points));
                }
                _notification.complete("visualizationImage", (Object)new IRSVisualizationImage(){

                    public Object getImageData() {
                        return _image;
                    }

                    public List<IRSImageMapEntry> getImageMap() {
                        return imageMap;
                    }
                });
            }

            private List<IRSPoint> convertPoints(List<PointStruct> _points) {
                ArrayList<IRSPoint> result = new ArrayList<IRSPoint>(_points.size());
                for (PointStruct p : _points) {
                    result.add((IRSPoint)new Point(p.x, p.y));
                }
                return result;
            }

            private List<IRSDataNode> convertData(Object _data) {
                List objList = null;
                if (_data instanceof List) {
                    objList = (List)_data;
                } else if (_data instanceof OrdinalCoordinateScaleDatum) {
                    objList = ((OrdinalCoordinateScaleDatum)_data).originalDataList();
                }
                if (objList == null) {
                    return null;
                }
                ArrayList<IRSDataNode> result = new ArrayList<IRSDataNode>(objList.size());
                for (Object obj : objList) {
                    if (!(obj instanceof IRSDataNode)) continue;
                    result.add((IRSDataNode)obj);
                }
                return result;
            }
        });
    }

    private class ItemTypesHelper {
        public String type;
        public String subType;

        private ItemTypesHelper() {
        }

        public boolean convert(String rave2Type) {
            switch (rave2Type) {
                case "element-shape": {
                    this.type = "element";
                    this.subType = "main";
                    break;
                }
                case "axis-tick": {
                    this.type = "axis";
                    this.subType = "mark";
                    break;
                }
                case "legend-tick": {
                    this.type = "legend";
                    this.subType = "swatch";
                    break;
                }
                default: {
                    int pos = rave2Type.indexOf(45);
                    this.type = rave2Type.substring(0, pos);
                    this.subType = rave2Type.substring(pos + 1);
                }
            }
            return !this.type.isEmpty() && !this.subType.isEmpty();
        }
    }
}

