/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.vizbundles.common.rave2;

import com.ibm.vida.rave.core.Rave;
import com.ibm.vida.rave.core.selector.Selector;
import com.ibm.vida.vizbundles.common.rave2.Rave2Common;
import com.ibm.vida.vizbundles.common.rave2.VidaRenderingServiceBase;
import com.ibm.vida.vizbundles.common.rave2.legend.LegendContainer;
import com.ibm.vida.vizbundles.common.rave2.legend.LegendOrientation;
import com.ibm.vida.vizbundles.common.rave2.legend.LegendPosition;
import com.ibm.vipr.renderingservice.api.IRSColor;
import com.ibm.vipr.renderingservice.api.IRSRenderInvalidation;
import com.ibm.vipr.renderingservice.api.IRenderSurface;
import com.ibm.vipr.renderingservice.property.Font;
import com.ibm.vipr.renderingservice.property.IRSBooleanProperty;
import com.ibm.vipr.renderingservice.property.IRSColorProperty;
import com.ibm.vipr.renderingservice.property.IRSEnumProperty;
import com.ibm.vipr.renderingservice.property.IRSFontProperty;
import com.ibm.vipr.renderingservice.property.IRSLengthProperty;
import com.ibm.vipr.renderingservice.property.IRSProperties;
import com.ibm.vipr.renderingservice.property.Length;
import com.ibm.vipr.renderingservice.property.LengthUnit;
import com.ibm.vipr.renderingservice.util.Bounds;
import java.awt.Dimension;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public abstract class VidaRenderingServiceLegendBase
extends VidaRenderingServiceBase {
    public static final double MAX_LEGEND_FRACTION = 0.2;
    public static final Dimension MIN_VISUALIZATION_SIZE = new Dimension(200, 150);
    private Selector bundleClipPath;
    private Selector legendClipPath;
    private Selector bundleRoot;
    private Selector legendRoot;
    private LegendContainer legendImpl;
    private Dimension bundleSize;

    protected abstract IRSProperties getProperties();

    @Override
    protected Selector initRaveSurface(IRenderSurface _surface, String _format, List<String> _cssFiles) throws Exception {
        Selector root = super.initRaveSurface(_surface, _format, _cssFiles);
        this.bundleSize = new Dimension();
        this.legendImpl = new LegendContainer();
        this.applyProperties();
        return this.createCanvasFuture(root).get();
    }

    @Override
    protected final void beforeRender(IRSRenderInvalidation _invalidation, double _width, double _height) {
        super.beforeRender(_invalidation, _width, _height);
        if (this.applyProperties()) {
            boolean isHorizontal = this.legendImpl.getOrientation() == LegendOrientation.Horizontal;
            this.legendImpl.setEncodings(this.getEncodings());
            IRSLengthProperty propSize = this.getProperties().getLength("rave.legend.size");
            Length legendPrefferdSize = new Length(20.0, LengthUnit.Percentage);
            boolean minimizeUsedSize = true;
            if (propSize != null && propSize.getValue() != null) {
                legendPrefferdSize = (Length)propSize.getValue();
                minimizeUsedSize = false;
            }
            if (isHorizontal) {
                this.legendImpl.setDimensions(_width, legendPrefferdSize.calculatePx(_height, 10.0));
            } else {
                this.legendImpl.setDimensions(legendPrefferdSize.calculatePx(_width, 10.0), _height);
            }
            this.legendImpl.measure(this.legendRoot, minimizeUsedSize);
            this.applySize(this.surface.getWidth(), this.surface.getHeight());
            this.legendImpl.render(this.legendRoot);
        } else {
            this.applySize(this.surface.getWidth(), this.surface.getHeight());
        }
    }

    @Override
    protected Dimension getDimension() {
        return this.bundleSize;
    }

    @Override
    public Selector getBundleRoot() {
        return this.bundleRoot;
    }

    public Selector getLegendRoot() {
        return this.legendRoot;
    }

    private CompletableFuture<Selector> createCanvasFuture(Selector _root) {
        if (this.format.equals("client")) {
            CompletableFuture<Selector> raveThreadInit = new CompletableFuture<Selector>();
            Rave.timer.addEvent(_elapsed -> {
                raveThreadInit.complete(this.createCanvas(_root));
                return true;
            });
            return raveThreadInit;
        }
        return CompletableFuture.completedFuture(this.createCanvas(_root));
    }

    private Selector createCanvas(Selector _root) {
        boolean createChartClipPath = this.mustCreateDefaultBundleClipPath();
        String bundleClipId = null;
        String legendClipId = null;
        Selector defs = _root.append("defs");
        legendClipId = String.format("legendClip%d", this.getUniqueBundleId());
        this.legendClipPath = defs.append("clipPath").attr("id", (Object)legendClipId).append("rect");
        if (createChartClipPath) {
            bundleClipId = String.format("bundleClip%d", this.getUniqueBundleId());
            this.bundleClipPath = defs.append("clipPath").attr("id", (Object)bundleClipId).append("rect");
        }
        this.bundleRoot = _root.append("g");
        this.legendRoot = _root.append("g").attr("class", (Object)"vida legend").attr("clip-path", (Object)Rave2Common.svgRef(legendClipId));
        if (createChartClipPath) {
            this.bundleRoot.attr("clip-path", (Object)Rave2Common.svgRef(bundleClipId));
        }
        this.legendRoot.append("rect").classed("background", true).style("fill-opacity", (Object)0.0);
        return this.bundleRoot;
    }

    protected boolean mustCreateDefaultBundleClipPath() {
        return true;
    }

    private void applySize(double _width, int _height) {
        if (_width < MIN_VISUALIZATION_SIZE.getWidth() || (double)_height < MIN_VISUALIZATION_SIZE.getHeight()) {
            this.legendImpl.setVisible(false);
        }
        double legendPixSize = this._computeLegendPixSize(_width, _height);
        Bounds vizualizationBounds = this._computeChartBounds(_width, _height, legendPixSize);
        Bounds legendBounds = this._computeLegendBounds(_width, _height, legendPixSize);
        this.bundleRoot.attr("transform", (Object)Rave2Common.translate(vizualizationBounds.getLeft(), vizualizationBounds.getTop()));
        if (this.bundleClipPath != null) {
            this.bundleClipPath.attr("width", (Object)vizualizationBounds.getWidth()).attr("height", (Object)vizualizationBounds.getHeight());
        }
        this.legendClipPath.attr("width", (Object)legendBounds.getWidth()).attr("height", (Object)legendBounds.getHeight());
        this.bundleSize.setSize(vizualizationBounds.getWidth(), vizualizationBounds.getHeight());
        this.legendImpl.setDimensions(legendBounds.getWidth(), legendBounds.getHeight());
        this.legendImpl.setOrigin(legendBounds.getLeft(), legendBounds.getTop());
    }

    private boolean applyProperties() {
        IRSProperties properties = this.getProperties();
        IRSBooleanProperty propDisplay = properties.getBoolean("rave.legend.display");
        IRSBooleanProperty propTitleVisible = properties.getBoolean("rave.legend.titleVisible");
        IRSEnumProperty propPosition = properties.getEnum("rave.legend.position");
        IRSColorProperty propTitleColor = properties.getColor("rave.legend.titleColor");
        IRSFontProperty propTitleFont = properties.getFont("rave.legend.titleFont");
        IRSColorProperty propColor = properties.getColor("rave.legend.color");
        IRSFontProperty propFont = properties.getFont("rave.legend.font");
        IRSColorProperty propBackgroundColor = properties.getColor("rave.legend.backgroundColor");
        Boolean displayLegend = propDisplay != null && (Boolean)propDisplay.getValue() != false;
        if (propDisplay != null) {
            this.legendImpl.setVisible(displayLegend);
        }
        if (propTitleVisible != null) {
            this.legendImpl.setTitleVisible((Boolean)propTitleVisible.getValue());
        }
        if (propPosition != null) {
            this.legendImpl.setPosition(LegendPosition.parse((String)propPosition.getValue()));
        }
        this.legendImpl.setBackgroundColor(propBackgroundColor != null ? (IRSColor)propBackgroundColor.getValue() : null);
        Font font = propFont != null ? (Font)propFont.getValue() : null;
        this.legendImpl.setFont(font);
        if (propTitleFont != null && propTitleFont.getValue() != null) {
            font = Font.merge((Font)font, (Font)((Font)propTitleFont.getValue()));
        }
        this.legendImpl.setTitleFont(font);
        IRSColor color = propColor != null ? (IRSColor)propColor.getValue() : null;
        this.legendImpl.setColor(color);
        if (propTitleColor != null && propTitleColor.getValue() != null) {
            color = (IRSColor)propTitleColor.getValue();
        }
        this.legendImpl.setTitleColor(color);
        return displayLegend != null && displayLegend != false;
    }

    private Length _computeLegendSize() {
        if (this.legendImpl.isVisible()) {
            IRSLengthProperty propSize = this.getProperties().getLength("rave.legend.size");
            if (propSize != null && propSize.getValue() != null) {
                return (Length)propSize.getValue();
            }
            return new Length(this.legendImpl.getUsedSize(), LengthUnit.Pixel);
        }
        return new Length(0.0, LengthUnit.Pixel);
    }

    protected double _computeLegendPixSize(double _width, int _height) {
        double parentSize;
        LegendPosition legendPosition = this.legendImpl.getPosition();
        switch (legendPosition) {
            case Left: 
            case Right: {
                parentSize = _width;
                break;
            }
            default: {
                parentSize = _height;
            }
        }
        double legendPixSize = this._computeLegendSize().calculatePx(parentSize, 10.0);
        return Math.max(Math.min(legendPixSize, parentSize), 0.0);
    }

    protected Bounds _computeChartBounds(double _width, int _height, double legendPixSize) {
        LegendPosition legendPosition = this.legendImpl.getPosition();
        switch (legendPosition) {
            case Left: {
                return new Bounds(legendPixSize, 0.0, _width, (double)_height);
            }
            case Top: {
                return new Bounds(0.0, legendPixSize, _width, (double)_height);
            }
            case Bottom: {
                return new Bounds(0.0, 0.0, _width, (double)_height - legendPixSize);
            }
        }
        return new Bounds(0.0, 0.0, _width - legendPixSize, (double)_height);
    }

    protected Bounds _computeLegendBounds(double _width, int _height, double legendPixSize) {
        LegendPosition legendPosition = this.legendImpl.getPosition();
        switch (legendPosition) {
            case Left: {
                return new Bounds(0.0, 0.0, legendPixSize, (double)_height);
            }
            case Top: {
                return new Bounds(0.0, 0.0, _width, legendPixSize);
            }
            case Bottom: {
                return new Bounds(0.0, (double)_height - legendPixSize, _width, (double)_height);
            }
        }
        return new Bounds(_width - legendPixSize, 0.0, _width, (double)_height);
    }

    protected abstract double getMinimalVisualizationWidth();

    protected abstract double getMinimalVisualizationHeight();
}

