/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.vizbundles.common.rave2.legend;

import com.ibm.vida.rave.core.Rave;
import com.ibm.vida.rave.core.geom.RaveRect;
import com.ibm.vida.rave.core.selector.Selector;
import com.ibm.vida.rave.ext.layout.RaveLayout;
import com.ibm.vida.rave.ext.position.RavePosition;
import com.ibm.vida.rave.ext.symbol.RaveSymbol;
import com.ibm.vida.rave.ext.text.TextExtensions;
import com.ibm.vida.vizbundles.common.rave2.Rave2Common;
import com.ibm.vida.vizbundles.common.rave2.legend.ILegend;
import com.ibm.vida.vizbundles.common.rave2.legend.LegendOrientation;
import com.ibm.vida.vizbundles.common.rave2.legend.LegendPosition;
import com.ibm.vida.vizbundles.common.rave2.legend.RaveContinuousLegend;
import com.ibm.vida.vizbundles.common.rave2.legend.RaveLegend;
import com.ibm.vida.vizbundles.common.rave2.legend.RaveSizeLegend;
import com.ibm.vida.vizbundles.common.rave2.legend.RaveSwatchLegend;
import com.ibm.vida.vizbundles.common.rendering.decorations.LineDecorationsController;
import com.ibm.vipr.renderingservice.api.IRSCatEncoding;
import com.ibm.vipr.renderingservice.api.IRSColor;
import com.ibm.vipr.renderingservice.api.IRSContEncoding;
import com.ibm.vipr.renderingservice.api.IRSEncoding;
import com.ibm.vipr.renderingservice.property.Font;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class LegendContainer
implements Iterable<ILegend>,
ILegend {
    private static final String colorChannel = "color";
    private static final String sizeChannel = "size";
    private static final String annotationsChannel = "annotations";
    private static final double legendSpacing = 10.0;
    private static final int ALIGN_HORIZONTALLY = 1;
    private static final int ALIGN_VERTICALLY = 2;
    protected final List<ILegend> legends = new ArrayList<ILegend>();
    protected Insets padding;
    protected LegendOrientation orientation = LegendOrientation.Vertical;
    protected double tX = 0.0;
    protected double tY = 0.0;
    protected double width;
    protected double height;
    protected Boolean visible = null;
    protected IRSColor backgroundColor;
    protected LegendPosition legendPosition;
    protected IRSColor color;
    protected Font font;
    protected IRSColor titleColor;
    protected boolean titleVisible;
    protected Font titleFont;
    private int currentAlignment;

    public LegendContainer() {
        this.padding = new Insets(0, 0, 0, 0);
        this.legendPosition = LegendPosition.Right;
        RaveLayout.init();
        TextExtensions.init();
        RaveSymbol.init();
        RavePosition.init();
        LineDecorationsController.registerShapeSymbols();
    }

    public void measure(Selector node, boolean minimizeUsedSize) {
        int legendCount = this.legends.size();
        boolean isHorizontal = this.orientation == LegendOrientation.Horizontal;
        double availableWidth = this.width - (double)this.padding.left - (double)this.padding.right;
        double availableHeight = this.height - (double)this.padding.top - (double)this.padding.bottom;
        double[][] spaceNeeded = new double[legendCount][2];
        for (int legendIndex = 0; legendIndex < legendCount; ++legendIndex) {
            ILegend legend = this.legends.get(legendIndex);
            legend.setDimensions(availableWidth, availableHeight);
            Selector legendSelector = node.append("g").attr("class", (Object)"legendNode");
            legend.render(legendSelector);
            legendSelector.selectAll(".legendBBox").remove();
            RaveRect renderedSize = Rave.util.getBBox(legendSelector.node());
            legendSelector.remove();
            if (isHorizontal) {
                spaceNeeded[legendIndex][0] = renderedSize.width * 1.2;
                spaceNeeded[legendIndex][1] = legend.getUsedSize();
                continue;
            }
            spaceNeeded[legendIndex][0] = legend.getUsedSize();
            spaceNeeded[legendIndex][1] = renderedSize.height + 10.0;
        }
        if (isHorizontal) {
            this.bestHorizontalLayout(spaceNeeded);
        } else {
            this.bestVerticalLayout(spaceNeeded, minimizeUsedSize);
        }
    }

    private void bestHorizontalLayout(double[][] spaceNeeded) {
        boolean isSuccess = this.shareSpaceHorizontally(spaceNeeded, false);
        if (isSuccess) {
            this.currentAlignment = 1;
            return;
        }
        isSuccess = this.shareSpaceVertically(spaceNeeded, false);
        if (isSuccess) {
            this.currentAlignment = 2;
            return;
        }
        this.shareSpaceHorizontally(spaceNeeded, true);
        this.currentAlignment = 1;
    }

    private void bestVerticalLayout(double[][] spaceNeeded, boolean minimizeUsedSize) {
        boolean isSuccess;
        if (minimizeUsedSize && (isSuccess = this.shareSpaceVertically(spaceNeeded, false))) {
            this.currentAlignment = 2;
            return;
        }
        isSuccess = this.shareSpaceHorizontally(spaceNeeded, false);
        if (isSuccess) {
            this.currentAlignment = 1;
            return;
        }
        double availableHeight = this.height - (double)this.padding.top - (double)this.padding.bottom;
        double availableWidth = this.width - (double)this.padding.left - (double)this.padding.right;
        if (availableHeight > availableWidth) {
            this.shareSpaceVertically(spaceNeeded, true);
            this.currentAlignment = 2;
        } else {
            this.shareSpaceHorizontally(spaceNeeded, true);
            this.currentAlignment = 1;
        }
    }

    private boolean shareSpaceVertically(double[][] spaceNeeded, boolean force) {
        double availableHeight = this.height - (double)this.padding.top - (double)this.padding.bottom;
        double availableWidth = this.width - (double)this.padding.left - (double)this.padding.right;
        double legendOffset = this.padding.top;
        int legendCount = this.legends.size();
        for (int legendIndex = 0; legendIndex < legendCount; ++legendIndex) {
            ILegend legend = this.legends.get(legendIndex);
            double givenHeight = Math.min(availableHeight / (double)(legendCount - legendIndex), spaceNeeded[legendIndex][1]);
            if (legendIndex + 1 == legendCount) {
                givenHeight = availableHeight;
            }
            if (!force && legendIndex > 0 && givenHeight < spaceNeeded[legendIndex - 1][1] && givenHeight < spaceNeeded[legendIndex][1]) {
                return false;
            }
            legend.setDimensions(availableWidth, givenHeight);
            legend.setOrigin(this.padding.left, legendOffset);
            legendOffset += givenHeight + 10.0;
            availableHeight -= givenHeight + 10.0;
        }
        return true;
    }

    private boolean shareSpaceHorizontally(double[][] spaceNeeded, boolean force) {
        double availableHeight = this.height - (double)this.padding.top - (double)this.padding.bottom;
        double availableWidth = this.width - (double)this.padding.left - (double)this.padding.right;
        double legendOffset = this.padding.left;
        int legendCount = this.legends.size();
        for (int legendIndex = 0; legendIndex < legendCount; ++legendIndex) {
            ILegend legend = this.legends.get(legendIndex);
            double givenWidth = Math.min(availableWidth / (double)(legendCount - legendIndex), spaceNeeded[legendIndex][0]);
            if (legendIndex + 1 == legendCount) {
                givenWidth = availableWidth;
            }
            if (!force && legendIndex > 0 && givenWidth < spaceNeeded[legendIndex - 1][0] && givenWidth < spaceNeeded[legendIndex][0]) {
                return false;
            }
            legend.setDimensions(givenWidth, availableHeight);
            legend.setOrigin(legendOffset, this.padding.top);
            legendOffset += givenWidth + 10.0;
            availableWidth -= givenWidth + 10.0;
        }
        return true;
    }

    @Override
    public void render(Selector node) {
        node.attr("transform", (Object)Rave2Common.translate(this.tX, this.tY));
        Selector backgroundNode = node.select((Object)">rect");
        if (this.backgroundColor != null) {
            backgroundNode.attr("width", (Object)this.width).attr("height", (Object)this.height).style("fill-opacity", (Object)1.0).style("fill", (Object)Rave2Common.colorToString(this.backgroundColor));
        } else {
            backgroundNode.style("fill-opacity", (Object)0.0).style("fill", null);
        }
        node.selectAll(".vidaLegend").remove();
        for (ILegend legend : this.legends) {
            Selector legendNode = node.append("g").attr("class", (Object)"vidaLegend");
            legend.render(legendNode);
        }
    }

    public LegendContainer setEncodings(List<IRSEncoding> _encodings) {
        this.legends.clear();
        for (IRSEncoding encoding : LegendContainer.sortAndFilterEncodings(_encodings)) {
            RaveLegend legend = null;
            if (encoding.getType() == IRSEncoding.EncodingType.Cat) {
                IRSCatEncoding catEncoding = (IRSCatEncoding)encoding;
                String channel = catEncoding.getChannel();
                if (channel.equals(colorChannel) || channel.equals(annotationsChannel)) {
                    legend = new RaveSwatchLegend(catEncoding);
                }
            } else {
                IRSContEncoding contEncoding = (IRSContEncoding)encoding;
                if (contEncoding.getChannel().equals(colorChannel)) {
                    legend = new RaveContinuousLegend(contEncoding);
                }
                if (contEncoding.getChannel().equals(sizeChannel)) {
                    legend = new RaveSizeLegend(contEncoding).mode("categorical");
                }
            }
            if (legend == null) continue;
            legend.title(this.titleVisible ? encoding.getCaption() : "").titleFont(this.titleFont, this.titleColor).font(this.font, this.color).setOrientation(this.orientation);
            this.legends.add(legend);
        }
        return this;
    }

    static List<IRSEncoding> sortAndFilterEncodings(List<IRSEncoding> _encodings) {
        ArrayList<IRSEncoding> result = new ArrayList<IRSEncoding>();
        int len = _encodings == null ? 0 : _encodings.size();
        int cat = 0;
        int cont = 0;
        int custom = 0;
        for (int i = 0; i < len; ++i) {
            IRSEncoding encoding = _encodings.get(i);
            int insertBefore = 0;
            IRSEncoding.EncodingType type = encoding.getType();
            switch (encoding.getChannel()) {
                case "color": {
                    if (type == IRSEncoding.EncodingType.Cont) {
                        insertBefore = ++cont;
                        break;
                    }
                    insertBefore = cont + ++cat;
                    break;
                }
                case "size": {
                    if (type != IRSEncoding.EncodingType.Cont) break;
                    insertBefore = ++cont;
                    break;
                }
                case "annotations": {
                    insertBefore = cont + cat + ++custom;
                }
            }
            if (insertBefore <= 0) continue;
            if (insertBefore > result.size()) {
                result.add(encoding);
                continue;
            }
            result.add(insertBefore - 1, encoding);
        }
        return result;
    }

    public LegendContainer setPadding(Insets _padding) {
        this.padding = _padding;
        return this;
    }

    @Override
    public double getUsedSize() {
        double usedSize = 0.0;
        if (this.currentAlignment == 1 && this.orientation == LegendOrientation.Vertical || this.currentAlignment == 2 && this.orientation == LegendOrientation.Horizontal) {
            for (int i = 0; i < this.legends.size(); ++i) {
                usedSize += this.legends.get(i).getUsedSize() + 10.0;
            }
        } else {
            for (int i = 0; i < this.legends.size(); ++i) {
                usedSize = Math.max(this.legends.get(i).getUsedSize(), usedSize);
            }
            usedSize += 10.0;
        }
        return usedSize;
    }

    @Override
    public boolean isVisible() {
        if (this.visible != null) {
            return this.visible != false && !this.legends.isEmpty();
        }
        for (ILegend legend : this.legends) {
            if (!legend.isVisible()) continue;
            return true;
        }
        return false;
    }

    public LegendContainer setVisible(Boolean _visible) {
        this.visible = _visible;
        return this;
    }

    public LegendOrientation getOrientation() {
        return this.orientation;
    }

    public IRSColor getBackgroundColor() {
        return this.backgroundColor;
    }

    public LegendContainer setBackgroundColor(IRSColor _color) {
        this.backgroundColor = _color;
        return this;
    }

    public LegendPosition getPosition() {
        return this.legendPosition;
    }

    public LegendContainer setPosition(LegendPosition _legendPosition) {
        this.legendPosition = _legendPosition;
        if (_legendPosition == LegendPosition.Left || _legendPosition == LegendPosition.Right) {
            this.orientation = LegendOrientation.Vertical;
        }
        if (_legendPosition == LegendPosition.Top || _legendPosition == LegendPosition.Bottom) {
            this.orientation = LegendOrientation.Horizontal;
        }
        return this;
    }

    public boolean getTitleVisible() {
        return this.titleVisible;
    }

    public LegendContainer setTitleVisible(boolean _titleVisible) {
        this.titleVisible = _titleVisible;
        return this;
    }

    public IRSColor getColor() {
        return this.color;
    }

    public LegendContainer setColor(IRSColor _color) {
        this.color = _color;
        return this;
    }

    public Font getFont() {
        return this.font;
    }

    public LegendContainer setFont(Font _font) {
        this.font = _font;
        return this;
    }

    public IRSColor getTitleColor() {
        return this.titleColor;
    }

    public LegendContainer setTitleColor(IRSColor _titleColor) {
        this.titleColor = _titleColor;
        return this;
    }

    public Font getTitleFont() {
        return this.titleFont;
    }

    public LegendContainer setTitleFont(Font _titleFont) {
        this.titleFont = _titleFont;
        return this;
    }

    @Override
    public ILegend setDimensions(double _width, double _height) {
        this.width = _width;
        this.height = _height;
        return this;
    }

    @Override
    public ILegend setOrigin(double _x, double _y) {
        this.tX = _x;
        this.tY = _y;
        return this;
    }

    public List<ILegend> getLegends() {
        return this.legends;
    }

    @Override
    public Iterator<ILegend> iterator() {
        return this.legends.iterator();
    }
}

