/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.vizbundles.common.rave2bundle;

import com.ibm.vida.vizbundles.common.rave2bundle.HierarchyNodeDatum;
import com.ibm.vipr.renderingservice.data.IRSItem;
import com.ibm.vipr.renderingservice.data.RSFormatKind;
import java.util.List;

public class HierarchyUtility {
    private static final String ROOT_KEY = "__root_node__";

    public static HierarchyNodeDatum buildHierarchy(List<HierarchyNodeDatum> _leafLevelNodeDatumList) {
        HierarchyNodeDatum root = new HierarchyNodeDatum(ROOT_KEY);
        root.type = HierarchyNodeDatum.NodeType.Root;
        for (HierarchyNodeDatum node : _leafLevelNodeDatumList) {
            int maxDepth = node.tuple.getItemCount();
            HierarchyNodeDatum parent = root;
            String key = "";
            for (int itemIndex = 0; itemIndex < maxDepth; ++itemIndex) {
                IRSItem item = node.tuple.getItem(itemIndex);
                key = itemIndex == maxDepth - 1 ? node.key : key + item.getUniqueName();
                HierarchyNodeDatum childNode = parent.findChild(key);
                if (childNode == null) {
                    if (itemIndex == maxDepth - 1) {
                        childNode = node;
                        childNode.type = HierarchyNodeDatum.NodeType.Leaf;
                    } else {
                        childNode = new HierarchyNodeDatum(key, node.getData(), node.tuple);
                        childNode.caption = item.getCaption(RSFormatKind.Label);
                        childNode.type = HierarchyNodeDatum.NodeType.Parent;
                    }
                    parent.addChild(childNode);
                } else if (itemIndex == maxDepth - 1) {
                    node.addChild(childNode.getChildren());
                    parent.replaceChild(childNode.key, node);
                } else {
                    childNode.type = HierarchyNodeDatum.NodeType.Parent;
                    if (maxDepth == childNode.tuple.getItemCount()) {
                        childNode.updateData(node.getData());
                    }
                }
                parent = childNode;
            }
        }
        return root;
    }
}

