/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.vizbundles.common.rendering.decorations.data;

import com.ibm.vida.rave.bundles.data.LineDataUtilities;
import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.geom.RaveRect;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.vida.vizbundles.common.rave2bundle.IRave2BundleWrapper;
import com.ibm.vida.vizbundles.common.rendering.decorations.DecorationError;
import com.ibm.vida.vizbundles.common.rendering.decorations.IProperties;
import com.ibm.vida.vizbundles.common.rendering.decorations.InvalidInputError;
import com.ibm.vida.vizbundles.common.rendering.decorations.PropertiesImpl;
import com.ibm.vida.vizbundles.common.rendering.decorations.Scale;
import com.ibm.vida.vizbundles.common.rendering.decorations.data.Rave2BundleDecorationsData;
import com.ibm.vida.vizbundles.common.rendering.decorations.renderers.IBaseLineData;
import com.ibm.vida.vizbundles.common.rendering.decorations.renderers.IDataMarkerData;
import com.ibm.vida.vizbundles.common.rendering.decorations.renderers.IDataPointMarkerData;
import com.ibm.vida.vizbundles.common.rendering.decorations.renderers.IPolyLineData;
import com.ibm.vida.vizbundles.common.rendering.decorations.renderers.ITrendLineData;
import com.ibm.vida.vizbundles.extensions.common.IPoint;
import com.ibm.vida.vizbundles.extensions.common.PointImpl;
import com.ibm.vipr.renderingservice.data.IRSDataPoint;
import com.ibm.vipr.renderingservice.data.IRSDataSet;
import com.ibm.vipr.renderingservice.data.IRSDatum;
import com.ibm.vipr.renderingservice.data.IRSSlot;
import com.ibm.vipr.renderingservice.property.IRSProperties;
import java.util.function.Supplier;

public class AreaDecorationsData
extends Rave2BundleDecorationsData
implements IBaseLineData,
ITrendLineData,
IPolyLineData,
IDataMarkerData,
IDataPointMarkerData {
    private final Supplier<IRSDataSet> resolveDataSet;
    private final Supplier<IRSProperties> resolveProperties;

    public AreaDecorationsData(Supplier<IRSDataSet> _resolveDataSet, Supplier<IRave2BundleWrapper> _resolveBundle, Supplier<IRSProperties> _resolveProperties, Supplier<RaveRect> _resolvePlotAreaBounds) {
        super(_resolveBundle, _resolvePlotAreaBounds, null);
        this.resolveDataSet = _resolveDataSet;
        this.resolveProperties = _resolveProperties;
    }

    @Override
    public IProperties getProperties() {
        IRSProperties properties = this.resolveProperties.get();
        PropertiesImpl props = this.createProperties(properties);
        props.setHorizontal((Boolean)properties.getBoolean("transpose").getValue());
        return props;
    }

    @Override
    public IPoint getPointPosition(Scale _xScale, Scale _yScale, IRSDataPoint _dataPoint) throws DecorationError {
        boolean isHorizontal = this.getProperties().isHorizontal();
        IRSDataSet dataset = this.resolveDataSet.get();
        IRSSlot categoriesSlot = dataset.getSlot("categories");
        IRSSlot seriesSlot = dataset.getSlot("series");
        IRSDatum xVal = _dataPoint.get(categoriesSlot);
        IRSDatum seriesVal = _dataPoint.get(seriesSlot);
        ResolvePoint result = new ResolvePoint();
        ((IRave2BundleWrapper)this.resolveBundle.get()).getItemsByCssSelector("g.elements").selectAll(".element-shape").each((_context, _data, _index, _groupIndex) -> {
            LineDataUtilities.LineDatum lineDatum = (LineDataUtilities.LineDatum)_data;
            ArrayEx points = lineDatum.points;
            for (int i = 0; i < points.length(); ++i) {
                double x;
                ArrayEx point = (ArrayEx)points.get(i);
                if (ObjectConverter.toInt((Object)point.get(0)) != xVal.asCat().getIndex() || Integer.parseInt(lineDatum.group) != seriesVal.asCat().getIndex()) continue;
                try {
                    x = _xScale.getScaleValue(xVal.asCat().getIndex());
                }
                catch (DecorationError e) {
                    break;
                }
                double yScaleInput = ObjectConverter.toDouble((Object)point.get(1)) + ObjectConverter.toDouble((Object)point.get(2));
                double y = _yScale.getDoubleValue(yScaleInput);
                result.setX(x);
                result.setY(y);
                result.setFound(true);
                break;
            }
        });
        if (!result.isFound()) {
            throw new InvalidInputError("dataPointMarker");
        }
        return new PointImpl(!isHorizontal ? result.getX() : result.getY(), isHorizontal ? result.getX() : result.getY());
    }

    @Override
    public IPoint getDataPosition(Scale _xScale, Scale _yScale, int[] _items) throws InvalidInputError, DecorationError {
        if (_items.length != 2) {
            throw new InvalidInputError("dataMarker");
        }
        boolean isHorizontal = this.getProperties().isHorizontal();
        int cat = _items[0];
        int yAxis = _items[1];
        double x = !isHorizontal ? _xScale.getScaleValue(cat) : _yScale.getDoubleValue(yAxis);
        double y = isHorizontal ? _xScale.getScaleValue(cat) : _yScale.getDoubleValue(yAxis);
        return new PointImpl(x, y);
    }

    private class ResolvePoint {
        private boolean found = false;
        private double x = 0.0;
        private double y = 0.0;

        public boolean isFound() {
            return this.found;
        }

        public void setFound(boolean found) {
            this.found = found;
        }

        public double getX() {
            return this.x;
        }

        public void setX(double x) {
            this.x = x;
        }

        public double getY() {
            return this.y;
        }

        public void setY(double y) {
            this.y = y;
        }
    }
}

