/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.vizbundles.common.rendering.decorations.data;

import com.ibm.vida.rave.core.geom.RaveRect;
import com.ibm.vida.rave.core.scales.AbstractScale;
import com.ibm.vida.rave.library.framework.CoordinateScale;
import com.ibm.vida.vizbundles.common.rave2bundle.IRave2BundleWrapper;
import com.ibm.vida.vizbundles.common.rendering.decorations.DecorationError;
import com.ibm.vida.vizbundles.common.rendering.decorations.IProperties;
import com.ibm.vida.vizbundles.common.rendering.decorations.InvalidInputError;
import com.ibm.vida.vizbundles.common.rendering.decorations.PropertiesImpl;
import com.ibm.vida.vizbundles.common.rendering.decorations.Scale;
import com.ibm.vida.vizbundles.common.rendering.decorations.data.Rave2BundleDecorationsData;
import com.ibm.vida.vizbundles.common.rendering.decorations.renderers.IBaseLineData;
import com.ibm.vida.vizbundles.common.rendering.decorations.renderers.IDataMarkerData;
import com.ibm.vida.vizbundles.common.rendering.decorations.renderers.IDataPointMarkerData;
import com.ibm.vida.vizbundles.common.rendering.decorations.renderers.IPolyLineData;
import com.ibm.vida.vizbundles.common.rendering.decorations.renderers.ITrendLineData;
import com.ibm.vida.vizbundles.extensions.common.IPoint;
import com.ibm.vida.vizbundles.extensions.common.PointImpl;
import com.ibm.vipr.renderingservice.data.IRSDataPoint;
import com.ibm.vipr.renderingservice.data.IRSDataSet;
import com.ibm.vipr.renderingservice.data.IRSSlot;
import com.ibm.vipr.renderingservice.data.RSDataItemType;
import com.ibm.vipr.renderingservice.property.Font;
import com.ibm.vipr.renderingservice.property.IRSProperties;
import java.util.Arrays;
import java.util.function.Supplier;

public class BarDecorationsData
extends Rave2BundleDecorationsData
implements IBaseLineData,
ITrendLineData,
IPolyLineData,
IDataMarkerData,
IDataPointMarkerData {
    private final Supplier<IRSProperties> resolveProperties;
    private final Supplier<IRSDataSet> resolveDataSet;

    public BarDecorationsData(Supplier<IRSDataSet> _resolveDataSet, Supplier<IRave2BundleWrapper> _resolveBundle, Supplier<IRSProperties> _resolveProperties, Supplier<RaveRect> _resolvePlotAreaBounds, Font _bundleFont) {
        super(_resolveBundle, _resolvePlotAreaBounds, _bundleFont);
        this.resolveDataSet = _resolveDataSet;
        this.resolveProperties = _resolveProperties;
    }

    @Override
    public IPoint getDataPosition(Scale _xScale, Scale _yScale, int[] _items) throws DecorationError {
        if (_items.length != 2) {
            throw new InvalidInputError("dataMarker");
        }
        double x = _xScale.getScaleValue(_items[0]);
        double y = _yScale.getScaleValue(_items[1]);
        boolean isHorizontal = this.getProperties().isHorizontal();
        return new PointImpl(!isHorizontal ? x : y, isHorizontal ? x : y);
    }

    @Override
    public IPoint getPointPosition(Scale _xScale, Scale _yScale, IRSDataPoint _dataPoint) throws DecorationError {
        double y;
        double x;
        IRSProperties properties = this.resolveProperties.get();
        boolean isStacked = (Boolean)properties.getBoolean("stacked").getValue();
        if (isStacked) {
            throw new DecorationError("unsupported when bar is stacked");
        }
        IRSDataSet dataSet = this.resolveDataSet.get();
        int xKey = this.getDataPointIndex(_dataPoint, dataSet.getSlot("categories"));
        Number yValue = this.getDataPointValue(_dataPoint, dataSet.getSlot("values"));
        IRSSlot yStartSlot = dataSet.getSlot("yStart");
        IRSSlot colorSlot = dataSet.getSlot("color");
        CoordinateScale coordinateXScale = ((IRave2BundleWrapper)this.resolveBundle.get()).getCoordinateScale("ROLE_X1");
        if (colorSlot.isMapped() && colorSlot.getDataItem().getType() == RSDataItemType.Cat) {
            int colorKey = this.getDataPointIndex(_dataPoint, colorSlot);
            x = coordinateXScale.center(Arrays.asList(xKey, colorKey)).doubleValue();
        } else {
            x = coordinateXScale.center(Arrays.asList(xKey)).doubleValue();
        }
        if (yStartSlot.isMapped()) {
            Number offsetValue = this.getDataPointValue(_dataPoint, yStartSlot);
            y = _yScale.getDoubleValue((yValue.doubleValue() - offsetValue.doubleValue()) * 0.5 + offsetValue.doubleValue());
        } else {
            AbstractScale<?, Object> scale = _yScale.getScale();
            if (_yScale.isCategorical()) {
                double rangeBand = scale.getRangeBand().getValue().doubleValue();
                y = _yScale.getDoubleValue(yValue) + rangeBand * 0.5;
            } else {
                y = _yScale.getDoubleValue(yValue.doubleValue() * 0.5);
            }
        }
        boolean isHorizontal = this.getProperties().isHorizontal();
        return new PointImpl(!isHorizontal ? x : y, isHorizontal ? x : y);
    }

    @Override
    public IProperties getProperties() {
        IRSProperties properties = this.resolveProperties.get();
        PropertiesImpl props = this.createProperties(properties);
        props.setHorizontal((Boolean)properties.getBoolean("bar.direction.vertical").getValue() == false);
        return props;
    }
}

