/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.vizbundles.common.rendering.decorations.data;

import com.ibm.vida.rave.core.geom.RaveRect;
import com.ibm.vida.vizbundles.common.rave2bundle.IRave2BundleWrapper;
import com.ibm.vida.vizbundles.common.rendering.decorations.DecorationError;
import com.ibm.vida.vizbundles.common.rendering.decorations.IProperties;
import com.ibm.vida.vizbundles.common.rendering.decorations.InvalidInputError;
import com.ibm.vida.vizbundles.common.rendering.decorations.PropertiesImpl;
import com.ibm.vida.vizbundles.common.rendering.decorations.Scale;
import com.ibm.vida.vizbundles.common.rendering.decorations.data.Rave2BundleDecorationsData;
import com.ibm.vida.vizbundles.common.rendering.decorations.renderers.IBaseLineData;
import com.ibm.vida.vizbundles.common.rendering.decorations.renderers.IDataMarkerData;
import com.ibm.vida.vizbundles.common.rendering.decorations.renderers.IFreeMarkerData;
import com.ibm.vida.vizbundles.common.rendering.decorations.renderers.IPolyLineData;
import com.ibm.vida.vizbundles.common.rendering.decorations.renderers.ITrendLineData;
import com.ibm.vida.vizbundles.extensions.common.IPoint;
import com.ibm.vida.vizbundles.extensions.common.PointImpl;
import com.ibm.vipr.renderingservice.data.IRSDataSet;
import com.ibm.vipr.renderingservice.property.Font;
import com.ibm.vipr.renderingservice.property.IRSBooleanProperty;
import com.ibm.vipr.renderingservice.property.IRSProperties;
import java.util.function.Supplier;

public class CompositeDecorationsData
extends Rave2BundleDecorationsData
implements IBaseLineData,
ITrendLineData,
IPolyLineData,
IDataMarkerData,
IFreeMarkerData {
    private final Supplier<IRSDataSet> resolveDataSet;
    private final Supplier<IRSProperties> resolveProperties;

    public CompositeDecorationsData(Supplier<IRSDataSet> _resolveDataSet, Supplier<IRave2BundleWrapper> _resolveBundle, Supplier<IRSProperties> _resolveProperties, Supplier<RaveRect> _resolvePlotAreaBounds, Font _bundleFont) {
        super(_resolveBundle, _resolvePlotAreaBounds, _bundleFont);
        this.resolveDataSet = _resolveDataSet;
        this.resolveProperties = _resolveProperties;
        this.clipPathCSSSelector = ".content1";
    }

    @Override
    public IProperties getProperties() {
        IRSProperties properties = this.resolveProperties.get();
        PropertiesImpl props = this.createProperties(properties);
        IRSBooleanProperty yAxisProp = properties.getBoolean("valueAxis.column.ticks.labels.visible");
        IRSBooleanProperty y2AxisProp = properties.getBoolean("valueAxis.line.ticks.labels.visible");
        props.setHasSpaceOnYAxis(yAxisProp != null ? ((Boolean)yAxisProp.getValue()).booleanValue() : props.hasSpaceOnYAxis());
        props.setHasSpaceOnY2Axis(y2AxisProp != null ? ((Boolean)y2AxisProp.getValue()).booleanValue() : props.hasSpaceOnY2Axis());
        props.setHorizontal((Boolean)properties.getBoolean("bar.direction.vertical").getValue() == false);
        return props;
    }

    @Override
    public IPoint getDataPosition(Scale _xScale, Scale _yScale, int[] _items) throws InvalidInputError, DecorationError {
        Scale y2Scale = this.getScales().getY2Scale();
        if (_items.length < 2) {
            throw new InvalidInputError("dataMarker");
        }
        double x = _xScale.getScaleValue(_items[0]);
        double y = 0.0;
        if (_items[1] >= 0) {
            y = _yScale.getDoubleValue(_items[1]);
        } else if (_items[2] >= 0 && y2Scale != null) {
            y = y2Scale.getDoubleValue(_items[2]);
        }
        boolean isHorizontal = !this.getProperties().isHorizontal();
        return new PointImpl(isHorizontal ? x : y, !isHorizontal ? x : y);
    }

    public boolean axisIsSwitched() {
        IRSProperties properties = this.resolveProperties.get();
        return (Boolean)properties.getBoolean("swapLineColumn").getValue();
    }
}

