/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.vizbundles.common.rendering.decorations.data;

import com.ibm.vida.rave.core.geom.NodeRect;
import com.ibm.vida.rave.core.geom.RaveRect;
import com.ibm.vida.vizbundles.common.rendering.decorations.DecorationError;
import com.ibm.vida.vizbundles.common.rendering.decorations.IProperties;
import com.ibm.vida.vizbundles.common.rendering.decorations.IScales;
import com.ibm.vida.vizbundles.common.rendering.decorations.InvalidInputError;
import com.ibm.vida.vizbundles.common.rendering.decorations.PropertiesImpl;
import com.ibm.vida.vizbundles.common.rendering.decorations.Scale;
import com.ibm.vida.vizbundles.common.rendering.decorations.renderers.IBaseLineData;
import com.ibm.vida.vizbundles.common.rendering.decorations.renderers.IDataMarkerData;
import com.ibm.vida.vizbundles.common.rendering.decorations.renderers.IDataPointMarkerData;
import com.ibm.vida.vizbundles.common.rendering.decorations.renderers.IFreeMarkerData;
import com.ibm.vida.vizbundles.common.rendering.decorations.renderers.IPolyLineData;
import com.ibm.vida.vizbundles.common.rendering.decorations.renderers.ITrendLineData;
import com.ibm.vida.vizbundles.extensions.common.IPoint;
import com.ibm.vida.vizbundles.extensions.common.PointImpl;
import com.ibm.vipr.renderingservice.api.IRSColor;
import com.ibm.vipr.renderingservice.data.IRSDataPoint;
import com.ibm.vipr.renderingservice.data.IRSDataSet;
import com.ibm.vipr.renderingservice.data.IRSDatum;
import com.ibm.vipr.renderingservice.data.IRSSlot;
import com.ibm.vipr.renderingservice.property.Font;
import com.ibm.vipr.renderingservice.property.IRSProperties;
import com.ibm.vipr.renderingservice.util.Bounds;
import java.util.function.Supplier;

public class LineDecorationsData
implements IBaseLineData,
ITrendLineData,
IPolyLineData,
IDataMarkerData,
IDataPointMarkerData,
IFreeMarkerData {
    private final Supplier<IRSDataSet> resolveDataSet;
    private final Supplier<IScales> resolveScales;
    private final Supplier<IRSProperties> resolveProperties;
    private final Supplier<NodeRect> resolveCanvasSize;
    private final Supplier<RaveRect> resolvePlotAreaBounds;
    private final String clipPath;
    private final Font bundleFont;

    public LineDecorationsData(Supplier<IRSDataSet> _resolveDataSet, Supplier<IScales> _resolveScales, Supplier<IRSProperties> _resolveProperties, Supplier<NodeRect> _resolveCanvasSize, Supplier<RaveRect> _resolvePlotAreaBounds, String _clipPath, Font _bundleFont) {
        this.resolveDataSet = _resolveDataSet;
        this.resolveScales = _resolveScales;
        this.resolveProperties = _resolveProperties;
        this.resolveCanvasSize = _resolveCanvasSize;
        this.resolvePlotAreaBounds = _resolvePlotAreaBounds;
        this.clipPath = _clipPath;
        this.bundleFont = _bundleFont;
    }

    @Override
    public IScales getScales() {
        return this.resolveScales.get();
    }

    @Override
    public IProperties getProperties() {
        IRSProperties properties = this.resolveProperties.get();
        boolean isHorizontal = false;
        IRSColor backgroundColor = (IRSColor)properties.getColor("backgroundColor").getValue();
        boolean hasSpaceOnXAxis = (Boolean)properties.getBoolean("itemAxis.ticks.labels.visible").getValue();
        boolean hasSpaceOnYAxis = (Boolean)properties.getBoolean("valueAxis.ticks.labels.visible").getValue();
        return new PropertiesImpl(isHorizontal, backgroundColor, hasSpaceOnXAxis, hasSpaceOnYAxis, this.bundleFont);
    }

    @Override
    public Bounds getPlotAreaBounds() {
        RaveRect rect = this.resolvePlotAreaBounds.get();
        return Bounds.fromXYWH((double)rect.x, (double)rect.y, (double)rect.width, (double)rect.height);
    }

    @Override
    public String getClipPath() {
        return this.clipPath;
    }

    @Override
    public Bounds getCanvasSize() {
        NodeRect rect = this.resolveCanvasSize.get();
        return Bounds.fromXYWH((double)rect.left, (double)rect.top, (double)rect.width, (double)rect.height);
    }

    @Override
    public IPoint getPointPosition(Scale _xScale, Scale _yScale, IRSDataPoint _dataPoint) throws DecorationError {
        IRSDataSet dataSet = this.resolveDataSet.get();
        String CATEGORIES_SLOT = "categories";
        String VALUES_SLOT = "values";
        IRSSlot categoriesSlot = dataSet.getSlot(CATEGORIES_SLOT);
        IRSSlot valuesSlot = dataSet.getSlot(VALUES_SLOT);
        IRSDatum xVal = _dataPoint.get(categoriesSlot);
        IRSDatum yVal = _dataPoint.get(valuesSlot);
        double x = _xScale.getScaleValue(xVal);
        double y = _yScale.getScaleValue(yVal);
        return new PointImpl(x, y);
    }

    @Override
    public IPoint getDataPosition(Scale _xScale, Scale _yScale, int[] _items) throws InvalidInputError, DecorationError {
        if (_items.length != 2) {
            throw new InvalidInputError("dataMarker");
        }
        double x = _xScale.getScaleValue(_items[0]);
        double y = _yScale.getScaleValue(_items[1]);
        return new PointImpl(x, y);
    }
}

