/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.vizbundles.common.rendering.decorations.data;

import com.ibm.vida.rave.core.geom.RaveRect;
import com.ibm.vida.rave.core.scene.SceneNode;
import com.ibm.vida.vizbundles.common.rave2bundle.IRave2BundleWrapper;
import com.ibm.vida.vizbundles.common.rendering.decorations.IChartData;
import com.ibm.vida.vizbundles.common.rendering.decorations.IChartProperties;
import com.ibm.vida.vizbundles.common.rendering.decorations.IPlotArea;
import com.ibm.vida.vizbundles.common.rendering.decorations.IScales;
import com.ibm.vida.vizbundles.common.rendering.decorations.PropertiesImpl;
import com.ibm.vida.vizbundles.common.rendering.decorations.ScalesImpl;
import com.ibm.vida.vizbundles.common.rendering.decorations.renderers.IFreeMarkerData;
import com.ibm.vipr.renderingservice.api.IRSColor;
import com.ibm.vipr.renderingservice.data.IRSDataPoint;
import com.ibm.vipr.renderingservice.data.IRSDatum;
import com.ibm.vipr.renderingservice.data.IRSSlot;
import com.ibm.vipr.renderingservice.data.IRSTuple;
import com.ibm.vipr.renderingservice.data.IRSValue;
import com.ibm.vipr.renderingservice.data.RSDataItemType;
import com.ibm.vipr.renderingservice.data.RSValueType;
import com.ibm.vipr.renderingservice.property.Font;
import com.ibm.vipr.renderingservice.property.IRSBooleanProperty;
import com.ibm.vipr.renderingservice.property.IRSProperties;
import com.ibm.vipr.renderingservice.util.Bounds;
import java.util.function.Supplier;

public abstract class Rave2BundleDecorationsData
implements IChartData,
IPlotArea,
IChartProperties,
IFreeMarkerData {
    protected final Supplier<IRave2BundleWrapper> resolveBundle;
    private final Supplier<RaveRect> resolvePlotAreaBounds;
    protected String clipPathCSSSelector;
    private Font bundleFont;

    public Rave2BundleDecorationsData(Supplier<IRave2BundleWrapper> _resolveBundle, Supplier<RaveRect> _resolvePlotAreaBounds, Font _bundleFont) {
        this.resolveBundle = _resolveBundle;
        this.resolvePlotAreaBounds = _resolvePlotAreaBounds;
        this.clipPathCSSSelector = ".content";
        this.bundleFont = _bundleFont;
    }

    protected Number getDataPointValue(IRSDataPoint _dataPoint, IRSSlot _slot) {
        IRSValue rsValue;
        IRSDatum datum = _dataPoint.get(_slot);
        if (datum.getType() == RSDataItemType.Cont && (rsValue = datum.asCont()).getValueType() == RSValueType.Numeric && rsValue.getValue() != null) {
            return (Number)rsValue.getValue();
        }
        return null;
    }

    protected int getDataPointIndex(IRSDataPoint _dataPoint, IRSSlot _slot) {
        IRSDatum datum = _dataPoint.get(_slot);
        if (datum.getType() == RSDataItemType.Cat) {
            IRSTuple rsTuple = datum.asCat();
            return rsTuple.getIndex();
        }
        return -1;
    }

    protected String getDataPointKey(IRSDataPoint _dataPoint, IRSSlot _slot) {
        IRSDatum datum = _dataPoint.get(_slot);
        if (datum.getType() == RSDataItemType.Cat) {
            IRSTuple rsTuple = datum.asCat();
            return rsTuple.getKey();
        }
        return null;
    }

    public PropertiesImpl createProperties(IRSProperties _properties) {
        IRSColor backgroundColor = (IRSColor)_properties.getColor("backgroundColor").getValue();
        IRSBooleanProperty xAxisProp = _properties.getBoolean("itemAxis.ticks.labels.visible");
        boolean hasSpaceOnXAxis = xAxisProp != null ? (Boolean)xAxisProp.getValue() : false;
        IRSBooleanProperty yAxisProp = _properties.getBoolean("valueAxis.ticks.labels.visible");
        boolean hasSpaceOnYAxis = yAxisProp != null ? (Boolean)yAxisProp.getValue() : false;
        return new PropertiesImpl(false, backgroundColor, hasSpaceOnXAxis, hasSpaceOnYAxis, this.bundleFont);
    }

    @Override
    public IScales getScales() {
        IRave2BundleWrapper bundleWrapper = this.resolveBundle.get();
        return new ScalesImpl(bundleWrapper);
    }

    @Override
    public String getClipPath() {
        IRave2BundleWrapper bundleWrapper = this.resolveBundle.get();
        SceneNode node = bundleWrapper.getItemsByCssSelector(this.clipPathCSSSelector).node();
        return (String)node.getAttribute("clip-path");
    }

    @Override
    public Bounds getPlotAreaBounds() {
        RaveRect rect = this.resolvePlotAreaBounds.get();
        return Bounds.fromXYWH((double)rect.x, (double)rect.y, (double)rect.width, (double)rect.height);
    }

    @Override
    public Bounds getCanvasSize() {
        return this.resolveBundle.get().getSize();
    }
}

