/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.vizbundles.common.rendering.decorations.data;

import com.ibm.vida.rave.bundles.data.waterfall.WaterfallDatum;
import com.ibm.vida.rave.core.geom.RaveRect;
import com.ibm.vida.rave.core.scales.AbstractScale;
import com.ibm.vida.vizbundles.common.rave2bundle.IRave2BundleWrapper;
import com.ibm.vida.vizbundles.common.rendering.decorations.DecorationError;
import com.ibm.vida.vizbundles.common.rendering.decorations.Helpers;
import com.ibm.vida.vizbundles.common.rendering.decorations.IProperties;
import com.ibm.vida.vizbundles.common.rendering.decorations.InvalidInputError;
import com.ibm.vida.vizbundles.common.rendering.decorations.PropertiesImpl;
import com.ibm.vida.vizbundles.common.rendering.decorations.Scale;
import com.ibm.vida.vizbundles.common.rendering.decorations.data.Rave2BundleDecorationsData;
import com.ibm.vida.vizbundles.common.rendering.decorations.renderers.IBaseLineData;
import com.ibm.vida.vizbundles.common.rendering.decorations.renderers.IDataMarkerData;
import com.ibm.vida.vizbundles.common.rendering.decorations.renderers.IDataPointMarkerData;
import com.ibm.vida.vizbundles.common.rendering.decorations.renderers.IFreeMarkerData;
import com.ibm.vida.vizbundles.common.rendering.decorations.renderers.IPolyLineData;
import com.ibm.vida.vizbundles.common.rendering.decorations.renderers.ITrendLineData;
import com.ibm.vida.vizbundles.extensions.common.IPoint;
import com.ibm.vida.vizbundles.extensions.common.PointImpl;
import com.ibm.vipr.renderingservice.data.IRSDataPoint;
import com.ibm.vipr.renderingservice.data.IRSDataSet;
import com.ibm.vipr.renderingservice.data.IRSDatum;
import com.ibm.vipr.renderingservice.data.IRSSlot;
import com.ibm.vipr.renderingservice.data.IRSTuple;
import com.ibm.vipr.renderingservice.property.Font;
import com.ibm.vipr.renderingservice.property.IRSProperties;
import java.util.List;
import java.util.function.Supplier;

public class WaterfallDecorationsData
extends Rave2BundleDecorationsData
implements IBaseLineData,
ITrendLineData,
IPolyLineData,
IDataMarkerData,
IDataPointMarkerData,
IFreeMarkerData {
    private final Supplier<IRSDataSet> resolveDataSet;
    private final Supplier<IRSProperties> resolveProperties;

    public WaterfallDecorationsData(Supplier<IRSDataSet> _resolveDataSet, Supplier<IRave2BundleWrapper> _resolveBundle, Supplier<IRSProperties> _resolveProperties, Supplier<RaveRect> _resolvePlotAreaBounds, Font _bundleFont) {
        super(_resolveBundle, _resolvePlotAreaBounds, _bundleFont);
        this.resolveDataSet = _resolveDataSet;
        this.resolveProperties = _resolveProperties;
    }

    @Override
    public IProperties getProperties() {
        IRSProperties properties = this.resolveProperties.get();
        PropertiesImpl props = this.createProperties(properties);
        props.setHorizontal((Boolean)properties.getBoolean("transpose").getValue());
        return props;
    }

    @Override
    public IPoint getPointPosition(Scale _xScale, Scale _yScale, IRSDataPoint _dataPoint) throws DecorationError {
        IRSDataSet dataSet = this.resolveDataSet.get();
        String CATEGORIES_SLOT = "categories";
        IRSSlot categoriesSlot = dataSet.getSlot(CATEGORIES_SLOT);
        IRSDatum datum = _dataPoint.get(categoriesSlot);
        IRSTuple xTuple = datum.asCat();
        WaterfallDatum result = new WaterfallDatum();
        ((IRave2BundleWrapper)this.resolveBundle.get()).getItemsByCssSelector("g.chart .element-shape").each((_context, _data, _index, _groupIndex) -> {
            WaterfallDatum waterfallDatum = (WaterfallDatum)_data;
            if (waterfallDatum.key().equals(xTuple.getKey())) {
                result.absoluteValue(waterfallDatum.absoluteValue() * 0.5 + waterfallDatum.base());
                result.category(waterfallDatum.key());
            }
        });
        AbstractScale<?, Object> xScale = _xScale.getScale();
        double x = _xScale.isCategorical() ? _xScale.getDoubleValue(result.category()) + xScale.rangeBand.getValue().doubleValue() * 0.5 : _xScale.getDoubleValue(result.category());
        double y = _yScale.getDoubleValue(result.absoluteValue());
        boolean isHorizontal = this.getProperties().isHorizontal();
        return new PointImpl(!isHorizontal ? x : y, isHorizontal ? x : y);
    }

    @Override
    public IPoint getDataPosition(Scale _xScale, Scale _yScale, int[] _items) throws InvalidInputError, DecorationError {
        if (_items.length != 2) {
            throw new InvalidInputError("dataMarker");
        }
        AbstractScale<?, Object> xScale = _xScale.getScale();
        AbstractScale<?, Object> yScale = _yScale.getScale();
        List xDomain = xScale.domain();
        List yDomain = yScale.domain();
        if (!Helpers.indexInBounds(xDomain, _items[0])) {
            throw new InvalidInputError("dataMarker");
        }
        double x = _xScale.isCategorical() ? _xScale.getDoubleValue(xDomain.get(_items[0])) + xScale.rangeBand.getValue().doubleValue() * 0.5 : _xScale.getDoubleValue(_items[0]);
        double y = _yScale.isCategorical() ? _yScale.getDoubleValue(yDomain.get(_items[1])) + yScale.rangeBand.getValue().doubleValue() * 0.5 : _yScale.getDoubleValue(_items[1]);
        boolean isHorizontal = this.getProperties().isHorizontal();
        return new PointImpl(!isHorizontal ? x : y, isHorizontal ? x : y);
    }
}

