/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.vizbundles.common.rendering.decorations.renderers;

import com.ibm.vida.vizbundles.common.rendering.decorations.LineData;
import com.ibm.vida.vizbundles.common.rendering.decorations.data.CompositeDecorationsData;
import com.ibm.vida.vizbundles.common.rendering.decorations.renderers.BaseLineRenderer;
import com.ibm.vida.vizbundles.extensions.decorations.Position;
import com.ibm.vida.vizbundles.extensions.decorations.lines.GrabberPositionType;

public class CompositeBaseLineRenderer
extends BaseLineRenderer {
    private final CompositeDecorationsData _compositeBundleData;

    public CompositeBaseLineRenderer(CompositeDecorationsData _bundleData) {
        super(_bundleData);
        this._compositeBundleData = _bundleData;
    }

    @Override
    protected Position getVanePosition(LineData _lineData) {
        boolean isChartVertical;
        boolean isLineHorizontal = this._info.isHorizontalAxis();
        boolean axisIsSwitched = this._compositeBundleData.axisIsSwitched();
        boolean isY2 = _lineData.getAxis() == "y2";
        boolean isRight = isY2 && !axisIsSwitched || !isY2 && axisIsSwitched;
        boolean bl = isChartVertical = !this._compositeBundleData.getProperties().isHorizontal();
        if (isLineHorizontal) {
            return isChartVertical ? Position.BOTTOM : Position.LEFT;
        }
        if (isLineHorizontal != isChartVertical) {
            return isRight ? Position.RIGHT : Position.LEFT;
        }
        return isRight ? Position.BOTTOM : Position.TOP;
    }

    @Override
    protected Position getGrabberPosition(LineData _lineData, GrabberPositionType _position) {
        Position position;
        if (_position == GrabberPositionType.BEGIN) {
            position = this._info.isHorizontalLine() ? (_lineData.getAxis() == "y" ? Position.LEFT : Position.RIGHT) : (_lineData.getAxis() == "y" ? Position.TOP : Position.BOTTOM);
        } else if (this._info.isHorizontalLine()) {
            position = _lineData.getAxis() == "y" ? Position.RIGHT : Position.LEFT;
        } else {
            Position position2 = position = _lineData.getAxis() == "y" ? Position.BOTTOM : Position.TOP;
        }
        if (this._compositeBundleData.axisIsSwitched()) {
            switch (position) {
                case TOP: {
                    return Position.BOTTOM;
                }
                case BOTTOM: {
                    return Position.TOP;
                }
                case LEFT: {
                    return Position.RIGHT;
                }
            }
            return Position.LEFT;
        }
        return position;
    }
}

