/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.vizbundles.common.rendering.decorations.renderers;

import com.ibm.vida.rave.core.Rave;
import com.ibm.vida.rave.core.scene.SceneNode;
import com.ibm.vida.rave.core.selector.Selector;
import com.ibm.vida.vizbundles.common.rendering.decorations.DecorationError;
import com.ibm.vida.vizbundles.common.rendering.decorations.IRenderer;
import com.ibm.vida.vizbundles.common.rendering.decorations.IScales;
import com.ibm.vida.vizbundles.common.rendering.decorations.MarkerData;
import com.ibm.vida.vizbundles.common.rendering.decorations.PositionTypeError;
import com.ibm.vida.vizbundles.common.rendering.decorations.renderers.IDataMarkerData;
import com.ibm.vida.vizbundles.common.rendering.decorations.renderers.MarkerHelpers;
import com.ibm.vida.vizbundles.extensions.common.IPoint;
import com.ibm.vida.vizbundles.extensions.decorations.markers.AbstractMarker;
import com.ibm.vida.vizbundles.extensions.decorations.markers.DataMarker;

public class DataMarkerRenderer
implements IRenderer<MarkerData> {
    private final IDataMarkerData bundleData;

    public DataMarkerRenderer(IDataMarkerData _bundleData) {
        this.bundleData = _bundleData;
    }

    @Override
    public void render(SceneNode _el, MarkerData _decorationItem) throws PositionTypeError, DecorationError {
        Selector selection = Rave.select((SceneNode)_el);
        DataMarker marker = (DataMarker)_decorationItem.getDecoration();
        int[] pos = marker.getPosition();
        if (pos.length == 0) {
            selection.remove();
            return;
        }
        selection.attr("clip-path", (Object)this.bundleData.getClipPath());
        Object[] arrData = new DataMarker[]{marker};
        Selector container = selection.selectAll(".dataMarker").data(arrData);
        container.enter().append("g").attr("class", (Object)"dataMarker");
        IScales scales = this.bundleData.getScales();
        if (scales.getXScale() == null || scales.getYScale() == null) {
            selection.remove();
            return;
        }
        IPoint point = this.bundleData.getDataPosition(scales.getXScale(), scales.getYScale(), pos);
        container.attr("transform", (Object)("translate(" + point.getX() + ", " + point.getY() + ")"));
        MarkerHelpers.applyMarkerProperties(container, (AbstractMarker)marker);
    }
}

