/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.vizbundles.common.rendering.decorations.renderers;

import com.ibm.vida.rave.core.Rave;
import com.ibm.vida.rave.core.scene.SceneNode;
import com.ibm.vida.rave.core.selector.Selector;
import com.ibm.vida.vizbundles.common.rendering.decorations.DecorationError;
import com.ibm.vida.vizbundles.common.rendering.decorations.IRenderer;
import com.ibm.vida.vizbundles.common.rendering.decorations.IScales;
import com.ibm.vida.vizbundles.common.rendering.decorations.MarkerData;
import com.ibm.vida.vizbundles.common.rendering.decorations.PositionTypeError;
import com.ibm.vida.vizbundles.common.rendering.decorations.Scale;
import com.ibm.vida.vizbundles.common.rendering.decorations.renderers.IDataPointMarkerData;
import com.ibm.vida.vizbundles.common.rendering.decorations.renderers.MarkerHelpers;
import com.ibm.vida.vizbundles.extensions.common.IPoint;
import com.ibm.vida.vizbundles.extensions.decorations.markers.AbstractMarker;
import com.ibm.vida.vizbundles.extensions.decorations.markers.DataPointMarker;
import com.ibm.vipr.renderingservice.data.IRSDataPoint;

public class DataPointMarkerRenderer
implements IRenderer<MarkerData> {
    private final IDataPointMarkerData _bundleData;

    public DataPointMarkerRenderer(IDataPointMarkerData _bundleData) {
        this._bundleData = _bundleData;
    }

    @Override
    public void render(SceneNode _el, MarkerData _decorationItem) throws PositionTypeError, DecorationError {
        Selector selection = Rave.select((SceneNode)_el);
        DataPointMarker marker = (DataPointMarker)_decorationItem.getDecoration();
        IRSDataPoint dataPoint = _decorationItem.getDataPoint();
        IScales scales = this._bundleData.getScales();
        Scale xScale = scales.getXScale();
        Scale yScale = scales.getYScale();
        if (xScale == null || yScale == null) {
            selection.remove();
            return;
        }
        IPoint position = this._bundleData.getPointPosition(xScale, yScale, dataPoint);
        selection.attr("clip-path", (Object)this._bundleData.getClipPath());
        Object[] arrData = new DataPointMarker[]{marker};
        Selector container = selection.selectAll(".datapointMarker").data(arrData);
        container.enter().append("g").attr("class", (Object)"datapointMarker");
        container.attr("transform", (Object)("translate(" + position.getX() + ", " + position.getY() + ")"));
        MarkerHelpers.applyMarkerProperties(container, (AbstractMarker)marker);
    }
}

