/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.vizbundles.common.rendering.decorations.renderers;

import com.ibm.vida.rave.core.Rave;
import com.ibm.vida.rave.core.scene.SceneNode;
import com.ibm.vida.rave.core.selector.Selector;
import com.ibm.vida.vizbundles.common.rendering.decorations.DecorationError;
import com.ibm.vida.vizbundles.common.rendering.decorations.IRenderer;
import com.ibm.vida.vizbundles.common.rendering.decorations.MarkerData;
import com.ibm.vida.vizbundles.common.rendering.decorations.PositionTypeError;
import com.ibm.vida.vizbundles.common.rendering.decorations.renderers.IFreeMarkerData;
import com.ibm.vida.vizbundles.common.rendering.decorations.renderers.MarkerHelpers;
import com.ibm.vida.vizbundles.extensions.common.IPoint;
import com.ibm.vida.vizbundles.extensions.decorations.markers.AbstractMarker;
import com.ibm.vida.vizbundles.extensions.decorations.markers.FreeMarker;
import com.ibm.vipr.renderingservice.util.Bounds;

public class FreeMarkerRenderer
implements IRenderer<MarkerData> {
    private final IFreeMarkerData _bundleData;

    public FreeMarkerRenderer(IFreeMarkerData _bundleData) {
        this._bundleData = _bundleData;
    }

    @Override
    public void render(SceneNode _el, MarkerData _decorationItem) throws PositionTypeError, DecorationError {
        FreeMarker marker = (FreeMarker)_decorationItem.getDecoration();
        Selector container = Rave.select((SceneNode)_el);
        IPoint point = marker.getPosition();
        if (point == null) {
            container.remove();
            return;
        }
        switch (marker.getPositionType()) {
            case STATIC_PCT: {
                Bounds dimensions = this._bundleData.getCanvasSize();
                double xRel = point.getX() * dimensions.getWidth();
                double yRel = point.getY() * dimensions.getHeight();
                container.attr("transform", (Object)("translate(" + xRel + ", " + yRel + ")"));
                break;
            }
            case STATIC_POS: {
                container.attr("transform", (Object)("translate(" + point.getX() + ", " + point.getY() + ")"));
                break;
            }
            default: {
                throw new PositionTypeError(marker.getPositionType(), "FreeMarker");
            }
        }
        MarkerHelpers.applyMarkerProperties(container, (AbstractMarker)marker);
    }
}

