/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.vizbundles.common.rendering.decorations.renderers;

import com.ibm.vida.rave.core.Rave;
import com.ibm.vida.rave.core.color.Color;
import com.ibm.vida.rave.core.color.RGB;
import com.ibm.vida.rave.core.geom.RaveRect;
import com.ibm.vida.rave.core.selector.RunFunction;
import com.ibm.vida.rave.core.selector.Selector;
import com.ibm.vida.rave.core.selector.ValueFunction;
import com.ibm.vida.rave.ext.text.nativeImpl.FontChecker;
import com.ibm.vida.rave.ext.text.wrap.TextFlow;
import com.ibm.vida.vizbundles.common.rave2.Rave2Common;
import com.ibm.vida.vizbundles.common.rendering.decorations.IProperties;
import com.ibm.vida.vizbundles.common.rendering.decorations.renderers.FontHelper;
import com.ibm.vida.vizbundles.common.rendering.decorations.renderers.TextPositioning;
import com.ibm.vida.vizbundles.extensions.common.IPoint;
import com.ibm.vida.vizbundles.extensions.decorations.Orientation;
import com.ibm.vida.vizbundles.extensions.decorations.lines.AbstractLine;
import com.ibm.vipr.renderingservice.api.IRSColor;
import com.ibm.vipr.renderingservice.property.Length;
import java.util.ArrayList;
import java.util.Arrays;

public class LineHelpers {
    private LineHelpers() {
    }

    public static Selector renderOverlayText(Selector _containerSelection, final AbstractLine _line, IProperties _properties, final TextPositioning textPositioning) {
        FontChecker fontChecker = (FontChecker)Rave.capabilities.extension("fontchecker");
        String textGroupClass = "text_group";
        String textGroupBackgroundClass = "text_background";
        String textClass = "line_captionText";
        double textLineheight = 20.0;
        Length lineSize = _line.getLineWidth();
        boolean isTextHorizontal = _line.getCaptionOrientation() == Orientation.HORIZONTAL;
        final double offsetFromLine = lineSize.calculatePx(0.0, 10.0) * 0.5 + 4.0;
        final double topSpaceNeeded = 20.0 + offsetFromLine;
        final TextFlow textFlow = (TextFlow)Rave.capabilities.extension("textflow");
        final String overlayText = _line.getCaption();
        ArrayList<Integer> textOnLineData = new ArrayList<Integer>();
        if (overlayText != null) {
            textOnLineData.add(0);
        }
        final Selector textGroup = _containerSelection.selectAll(".text_group").data(textOnLineData);
        textGroup.exit().remove();
        if (overlayText == null) {
            return textGroup;
        }
        Selector textGroupEnter = textGroup.enter().append("g").attr("class", (Object)"text_group");
        textGroupEnter.append("rect").attr("class", (Object)"text_background").attr("x", (Object)(isTextHorizontal ? 0.0 : offsetFromLine)).attr("y", (Object)(isTextHorizontal ? -topSpaceNeeded : 0.0)).attr("width", (Object)126).attr("height", (Object)20.0).style("fill", (Object)"#ffffff").style("fill-opacity", (Object)0.9);
        textGroupEnter.append("text").attr("class", (Object)"line_captionText").attr("text-anchor", (Object)"start").attr("dy", (Object)"0.4em").text((Object)overlayText).attr("x", (Object)(isTextHorizontal ? 4.0 : offsetFromLine + 4.0)).attr("y", (Object)(isTextHorizontal ? -topSpaceNeeded + 10.0 : 10.0));
        textFlow.padding(0, 0, 0, 0).truncate(true).textTruncateIndicator("...");
        final Selector column = textGroup.selectAll(".line_captionText");
        column.text((Object)overlayText).style("font-family", (Object)FontHelper.getFamily(_line.getFont(), _properties.getFont(), "inherit")).style("font-size", (Object)FontHelper.getSize(_line.getFont(), _properties.getFont(), "12px")).style("font-weight", (Object)FontHelper.getWeight(_line.getFont(), _properties.getFont(), "normal")).style("font-style", (Object)FontHelper.getStyle(_line.getFont(), _properties.getFont(), "normal")).style("fill", _line.getFontColor() != null ? _line.getFontColor().toString() : null);
        column.call((RunFunction)fontChecker, new Object[0]);
        RaveRect rect = Rave.util.getBBox(column.node());
        final double textWidth = rect.width;
        textGroup.attr("transform", (ValueFunction)new ValueFunction<Object, Object>(){

            public Object getValue(Object context, Object data, int index, int groupIndex) {
                double x;
                double y;
                double availableSpace;
                double consumedTextSpace;
                double boxPadding = 8.0;
                IPoint position = textPositioning.getTextPosition();
                double availableRightSpace = textPositioning.getAvailableRightSpace();
                if (textPositioning.isLineHorizontal()) {
                    consumedTextSpace = textWidth < availableRightSpace ? textWidth : availableRightSpace;
                    availableSpace = availableRightSpace;
                    y = textPositioning.hasEnoughTopSpace(topSpaceNeeded) ? position.getY() : topSpaceNeeded + offsetFromLine;
                    x = position.getX() - consumedTextSpace / 2.0;
                } else {
                    boolean alignRight = textPositioning.hasEnoughRightSpace(textWidth);
                    double availableLeftSpace = textPositioning.getAvailableLeftSpace();
                    consumedTextSpace = alignRight ? (textWidth < availableRightSpace ? textWidth : availableRightSpace) : (textWidth < availableLeftSpace ? textWidth : availableLeftSpace);
                    availableSpace = alignRight ? availableRightSpace : availableLeftSpace;
                    y = position.getY();
                    double d = x = alignRight ? position.getX() + offsetFromLine : position.getX() - offsetFromLine - consumedTextSpace - 8.0;
                }
                if (overlayText != null && availableSpace < textWidth) {
                    textFlow.extent((int)availableSpace, 20);
                    column.call((RunFunction)textFlow, new Object[0]);
                }
                textGroup.selectAll(".text_background").attr("width", (Object)(consumedTextSpace > 0.0 ? consumedTextSpace + 8.0 : 0.0));
                String rotate = _line.getCaptionOrientation() == Orientation.VERTICAL ? "rotate(-90)" : "";
                return "translate( " + x + "," + y + ")" + rotate;
            }
        });
        return textGroup;
    }

    public static Selector applyLineProperties(Selector _lineSelection, AbstractLine _line, IProperties _properties) {
        RGB rgb;
        IRSColor backgroundColor;
        String dashStyle = null;
        int[] arrDash = _line.getDashStyle();
        if (arrDash != null && arrDash.length > 0) {
            dashStyle = Arrays.toString(arrDash).replace("[", "").replace("]", "");
        }
        _lineSelection.style("fill", (Object)"none").style("stroke", (Object)_line.getColor().toString()).style("color", (Object)_line.getColor().toString()).style("stroke-linecap", (Object)_line.getLineCap()).style("stroke-width", (Object)_line.getLineWidth().calculatePx(0.0, 10.0)).style("stroke-dasharray", (Object)dashStyle);
        if (_properties != null && (backgroundColor = _properties.getBackgroundColor()) != null && Rave2Common.isDarkColor((Color)(rgb = Rave.rgba((int)backgroundColor.getRed(), (int)backgroundColor.getGreen(), (int)backgroundColor.getBlue(), (double)backgroundColor.getAlpha())))) {
            _lineSelection.style("stroke", (Object)"rgb(0, 133, 113)");
        }
        return _lineSelection;
    }
}

