/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.vizbundles.common.rendering.decorations.renderers;

import com.ibm.vida.vizbundles.extensions.common.IPoint;
import com.ibm.vipr.renderingservice.util.Bounds;

public class TextPositioning {
    private Bounds bounds;
    private IPoint textPosition;
    private boolean isLineHorizontal;
    private double linePosition;

    public TextPositioning(Bounds _bounds, IPoint _textPosition, boolean _isLineHorizontal, double _linePosition) {
        this.bounds = _bounds;
        this.textPosition = _textPosition;
        this.isLineHorizontal = _isLineHorizontal;
        this.linePosition = _linePosition;
    }

    public Bounds getBounds() {
        return this.bounds;
    }

    public IPoint getTextPosition() {
        return this.textPosition;
    }

    public boolean isLineHorizontal() {
        return this.isLineHorizontal;
    }

    public double getLinePosition() {
        return this.linePosition;
    }

    public boolean hasEnoughTopSpace(double _spaceNeeded) {
        return this.getAvailableTopSpace() > _spaceNeeded;
    }

    public boolean hasEnoughRightSpace(double _spaceNeeded) {
        return this.getAvailableRightSpace() > _spaceNeeded;
    }

    public double getAvailableTopSpace() {
        double y1 = this.bounds.getTop();
        double y2 = this.bounds.getBottom();
        return this.isLineHorizontal ? this.linePosition - y1 : y2 - y1;
    }

    public double getAvailableRightSpace() {
        double x1 = this.bounds.getLeft();
        double x2 = this.bounds.getRight();
        return this.isLineHorizontal ? x2 - x1 : x2 - this.linePosition;
    }

    public double getAvailableLeftSpace() {
        double x1 = this.bounds.getLeft();
        double x2 = this.bounds.getRight();
        return this.isLineHorizontal ? x2 - x1 : this.linePosition - x1;
    }
}

