/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.vizbundles.common.rendering.decorations.renderers;

import com.ibm.vida.rave.core.Rave;
import com.ibm.vida.rave.core.scene.SceneNode;
import com.ibm.vida.rave.core.selector.Selector;
import com.ibm.vida.rave.core.svg.LinePathGenerator;
import com.ibm.vida.vizbundles.common.rendering.decorations.DecorationError;
import com.ibm.vida.vizbundles.common.rendering.decorations.IProperties;
import com.ibm.vida.vizbundles.common.rendering.decorations.IRenderer;
import com.ibm.vida.vizbundles.common.rendering.decorations.IScales;
import com.ibm.vida.vizbundles.common.rendering.decorations.LineData;
import com.ibm.vida.vizbundles.common.rendering.decorations.Scale;
import com.ibm.vida.vizbundles.common.rendering.decorations.renderers.ITrendLineData;
import com.ibm.vida.vizbundles.common.rendering.decorations.renderers.LineHelpers;
import com.ibm.vida.vizbundles.extensions.common.IPoint;
import com.ibm.vida.vizbundles.extensions.common.PointImpl;
import com.ibm.vida.vizbundles.extensions.decorations.lines.AbstractLine;
import com.ibm.vida.vizbundles.extensions.decorations.lines.TrendLine;
import java.util.ArrayList;
import java.util.List;

public class TrendLineRenderer
implements IRenderer<LineData> {
    private final LinePathGenerator _linePathGenerator;
    private final ITrendLineData _bundleData;

    public TrendLineRenderer(ITrendLineData _bundleData) {
        this._linePathGenerator = Rave.svg.line.create();
        this._linePathGenerator.x((_context, _data, _index, _groupIndex) -> ((IPoint)_data).getX());
        this._linePathGenerator.y((_context, _data, _index, _groupIndex) -> ((IPoint)_data).getY());
        this._bundleData = _bundleData;
    }

    @Override
    public void render(SceneNode _el, LineData _item) throws DecorationError {
        Selector container = Rave.select((SceneNode)_el);
        IScales rScales = this._bundleData.getScales();
        TrendLine line = (TrendLine)_item.getDecoration();
        ArrayList<TrendLine> arrData = new ArrayList<TrendLine>();
        arrData.add(line);
        Selector lineSelection = container.selectAll("." + line.getId()).data(arrData, (_context, _data, _index, _groupIndex) -> {
            TrendLine data = (TrendLine)_data;
            return data.getId();
        });
        lineSelection.enter().append("path").attr("class", (Object)line.getId()).attr("clip-path", (Object)this._bundleData.getClipPath());
        IProperties properties = this._bundleData.getProperties();
        boolean isHorizontal = _item.getAxis() == "x";
        IScales scales = !isHorizontal ? rScales : rScales.invert();
        boolean vertical = !isHorizontal && !properties.isHorizontal();
        List<IPoint> coordinates = this._calculateCoordinates(line, scales, vertical);
        if (coordinates.size() < 2) {
            container.remove();
            return;
        }
        String interpolation = line.isSmooth() ? "cardinal" : "linear";
        this._linePathGenerator.interpolate(interpolation);
        lineSelection.attr("d", (Object)this._linePathGenerator.getValue(null, coordinates, 0, 0));
        LineHelpers.applyLineProperties(lineSelection, (AbstractLine)line, this._bundleData.getProperties());
    }

    protected List<IPoint> _calculateCoordinates(TrendLine _line, IScales _scales, boolean _vertical) {
        ArrayList<IPoint> coordinates = new ArrayList<IPoint>();
        Scale xScale = _scales.getXScale();
        Scale yScale = _scales.getYScale();
        if (xScale == null || yScale == null) {
            return coordinates;
        }
        if (xScale.isCategorical() && !yScale.isCategorical()) {
            double xRangeBandValue = xScale.getScale().getRangeBand().getValue().doubleValue();
            List xDomain = xScale.getScale().domain();
            int[][] params = _line.getParams();
            for (int i = 0; i < params.length; ++i) {
                if (params[i][0] >= xDomain.size() || params[i][0] < 0) continue;
                Object xVal = xDomain.get(params[i][0]);
                double x = xScale.getDoubleValue(xVal) + xRangeBandValue * 0.5;
                double y = yScale.getDoubleValue(params[i][1]);
                coordinates.add((IPoint)new PointImpl(_vertical ? x : y, _vertical ? y : x));
            }
        }
        return coordinates;
    }
}

