/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.vizbundles.common.rendering.decorations.renderers;

import com.ibm.vida.rave.core.Rave;
import com.ibm.vida.rave.core.scene.SceneNode;
import com.ibm.vida.rave.core.selector.RunFunction;
import com.ibm.vida.rave.core.selector.Selector;
import com.ibm.vida.rave.core.selector.ValueFunction;
import com.ibm.vida.rave.ext.text.nativeImpl.FontChecker;
import com.ibm.vida.vizbundles.common.rendering.decorations.IRenderer;
import com.ibm.vida.vizbundles.common.rendering.decorations.data.VaneData;
import com.ibm.vida.vizbundles.common.rendering.decorations.renderers.BaseLineRenderInfo;
import com.ibm.vida.vizbundles.common.rendering.decorations.renderers.FontHelper;
import com.ibm.vida.vizbundles.extensions.decorations.Position;
import com.ibm.vida.vizbundles.extensions.decorations.lines.Vane;
import com.ibm.vipr.renderingservice.property.Font;
import com.ibm.vipr.renderingservice.util.Bounds;
import java.util.List;

public class VaneRenderer
implements IRenderer<List<VaneData>> {
    private final BaseLineRenderInfo _renderInfo;
    private Font _font;

    VaneRenderer(BaseLineRenderInfo _baseLineInfo) {
        this._renderInfo = _baseLineInfo;
        this._font = null;
    }

    public void setFont(Font _font) {
        this._font = _font;
    }

    @Override
    public void render(SceneNode _svgElement, List<VaneData> _arrVaneData) {
        FontChecker fontChecker = (FontChecker)Rave.capabilities.extension("fontchecker");
        double defaultWidth = 54.0;
        Bounds bounds = this._renderInfo.getPlotAreaBounds();
        Selector container = Rave.select((SceneNode)_svgElement);
        Selector groupSelection = container.selectAll(".vane").data(_arrVaneData, VaneRenderer.createVaneDataKeyLambda());
        groupSelection.exit().remove();
        Selector enterSelection = groupSelection.enter().append("g").attr("class", (Object)"vane");
        enterSelection.append("rect").attr("class", (Object)"vaneBackground").attr("height", (Object)16).attr("y", (Object)-10).attr("fill-opacity", (Object)0.9);
        enterSelection.append("text").attr("class", (Object)"vaneText").style("fill", (Object)"rgb(106, 115, 115)");
        groupSelection.attr("transform", this.getTranslateFn(bounds));
        groupSelection.selectAll(".vaneBackground").attr("fill", (_context, _data, _index, _groupIndex) -> {
            Vane vane = ((VaneData)_data).getVane();
            return vane.getFillColor() != null ? vane.getFillColor().toString() : "white";
        }).attr("width", (_context, _data, _index, _groupIndex) -> {
            Vane vane = ((VaneData)_data).getVane();
            return vane.getSize() != null && vane.getSize().value > 0.0 ? vane.getSize().toString() : Double.valueOf(defaultWidth);
        }).attr("stroke-width", (_context, _data, _index, _groupIndex) -> {
            Vane vane = ((VaneData)_data).getVane();
            return vane.getStrokeColor() != null ? 1 : 0;
        }).attr("stroke", (_context, _data, _index, _groupIndex) -> {
            Vane vane = ((VaneData)_data).getVane();
            return vane.getStrokeColor() != null ? vane.getStrokeColor() : "black";
        }).attr("x", this.getBackgroundXFn(defaultWidth));
        Selector textSelection = groupSelection.selectAll(".vaneText").attr("transform", this.getTextTranslateFn()).style("text-anchor", this.getTextAnchorFn()).style("font-family", this.getFontFamilyFn(this._font)).style("font-size", this.getFontSizeFn(this._font)).style("font-weight", this.getFontWeightFn(this._font)).style("font-style", this.getFontStyleFn(this._font)).text((_context, _data, _index, _groupIndex) -> {
            Vane vane = ((VaneData)_data).getVane();
            return vane.getCaption() != null ? vane.getCaption() : "";
        });
        textSelection.call((RunFunction)fontChecker, new Object[0]);
        if (textSelection.size() > 0) {
            double textLength = Rave.util.getBBox((SceneNode)textSelection.node()).width + 4.0;
            groupSelection.select((Object)".vaneBackground").attr("width", (Object)textLength).attr("x", this.getBackgroundXFn(textLength));
        }
    }

    private ValueFunction<SceneNode, Double> getBackgroundXFn(double _width) {
        boolean hasSpaceOnAxis = this._renderInfo.hasSpaceOnAxis();
        return (_context, _data, _index, _groupIndex) -> {
            VaneData data = (VaneData)_data;
            double backgroundXFactor = hasSpaceOnAxis ? 0.0 : -1.0;
            Position position = data.getPosition();
            Vane vane = data.getVane();
            if (position == Position.LEFT) {
                backgroundXFactor = hasSpaceOnAxis ? -1.0 : 0.0;
            } else if (position == Position.TOP || position == Position.BOTTOM) {
                backgroundXFactor = -0.5;
            }
            double size = vane.getSize().value > 0.0 ? vane.getSize().calculatePx(0.0, 10.0) : _width;
            return size * backgroundXFactor;
        };
    }

    private ValueFunction<SceneNode, ?> getTranslateOnAxisFn(Bounds _bounds) {
        return (_context, _data, _index, _groupIndex) -> {
            VaneData data = (VaneData)_data;
            double horizontalAxisOffset = 12.0;
            double topAxisOffset = 18.5;
            double bottomAxisOffset = 22.0;
            switch (data.getPosition()) {
                case LEFT: {
                    return "translate(" + (_bounds.getLeft() - horizontalAxisOffset) + ", 0)";
                }
                case RIGHT: {
                    return "translate(" + (_bounds.getRight() + horizontalAxisOffset) + ", 0)";
                }
                case TOP: {
                    return "translate(0, " + (_bounds.getTop() - topAxisOffset) + ")";
                }
                case BOTTOM: {
                    return "translate(0, " + (_bounds.getBottom() + bottomAxisOffset) + ")";
                }
            }
            return "";
        };
    }

    private ValueFunction<SceneNode, String> getTranslateOnLineFn(Bounds _bounds) {
        return (_context, _data, _index, _groupIndex) -> {
            VaneData data = (VaneData)_data;
            double margin = 4.0;
            double backGroundMargin = 8.0;
            double grabber = data.hasGrabber() ? 20.0 : 0.0;
            double horizontalOffset = grabber + margin;
            double verticalOffset = grabber + backGroundMargin;
            double length = data.getLineWidth().calculatePx(0.0, 10.0);
            double y = (Math.ceil(length / 2.0) + backGroundMargin) * -1.0;
            switch (data.getPosition()) {
                case LEFT: {
                    return "translate(" + (_bounds.getLeft() + horizontalOffset) + ", " + y + ")";
                }
                case RIGHT: {
                    return "translate(" + (_bounds.getRight() - horizontalOffset) + ", " + y + ")";
                }
                case TOP: {
                    return "translate(0, " + (_bounds.getTop() + verticalOffset) + ")";
                }
                case BOTTOM: {
                    return "translate(0, " + (_bounds.getBottom() - verticalOffset) + ")";
                }
            }
            return "";
        };
    }

    private ValueFunction<SceneNode, ?> getTranslateFn(Bounds _bounds) {
        if (this._renderInfo.hasSpaceOnAxis()) {
            return this.getTranslateOnAxisFn(_bounds);
        }
        return this.getTranslateOnLineFn(_bounds);
    }

    private ValueFunction<SceneNode, ?> getTextTranslateFn() {
        boolean hasSpaceOnAxis = this._renderInfo.hasSpaceOnAxis();
        return (_context, _data, _index, _groupIndex) -> {
            VaneData data = (VaneData)_data;
            String textTransform = hasSpaceOnAxis ? "translate( 2, 3 )" : "translate( -2, 3 )";
            Position position = data.getPosition();
            if (position == Position.LEFT) {
                textTransform = hasSpaceOnAxis ? "translate( -2, 3 )" : "translate( 2, 3 )";
            } else if (position == Position.TOP || position == Position.BOTTOM) {
                textTransform = "translate( 0, 2 )";
            }
            return textTransform;
        };
    }

    private ValueFunction<SceneNode, String> getTextAnchorFn() {
        boolean hasSpaceOnAxis = this._renderInfo.hasSpaceOnAxis();
        return (_context, _data, _index, _groupIndex) -> {
            VaneData data = (VaneData)_data;
            Position position = data.getPosition();
            if (position == Position.LEFT) {
                return hasSpaceOnAxis ? "end" : "start";
            }
            if (position == Position.TOP || position == Position.BOTTOM) {
                return "middle";
            }
            return hasSpaceOnAxis ? "start" : "end";
        };
    }

    private ValueFunction<SceneNode, String> getFontFamilyFn(Font _font) {
        return (_context, _data, _index, _groupIndex) -> {
            VaneData data = (VaneData)_data;
            return FontHelper.getFamily(data.getVane().getFont(), _font, "inherit");
        };
    }

    private ValueFunction<SceneNode, String> getFontSizeFn(Font _font) {
        return (_context, _data, _index, _groupIndex) -> {
            VaneData data = (VaneData)_data;
            return FontHelper.getSize(data.getVane().getFont(), _font, "12px");
        };
    }

    private ValueFunction<SceneNode, String> getFontWeightFn(Font _font) {
        return (_context, _data, _index, _groupIndex) -> {
            VaneData data = (VaneData)_data;
            return FontHelper.getWeight(data.getVane().getFont(), _font, "bold");
        };
    }

    private ValueFunction<SceneNode, String> getFontStyleFn(Font _font) {
        return (_context, _data, _index, _groupIndex) -> {
            VaneData data = (VaneData)_data;
            return FontHelper.getStyle(data.getVane().getFont(), _font, null);
        };
    }

    protected static ValueFunction<Object, Object> createVaneDataKeyLambda() {
        return (_context, _data, _index, _groupIndex) -> ((VaneData)_data).getId();
    }
}

