/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.essbase;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseMessageKeys;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseRuntimeException;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseUtil;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.essbase.api.base.IEssValueAny;
import java.lang.reflect.Field;
import java.util.Date;

public abstract class EssbaseApiDeltaFactory {
    private static final EssbaseApiDeltaFactory ESS_API_DELTA;
    private static XQELogger loggerDelta;

    public static final Date getDateValue(String propertyName, IEssValueAny propertyValue) {
        return ESS_API_DELTA.getDateValueImpl(propertyName, propertyValue);
    }

    protected abstract Date getDateValueImpl(String var1, IEssValueAny var2);

    static {
        loggerDelta = XQELog.getLogger((ServiceEnumeration)ServiceEnumeration.XQEODP, (String)"Essbase", (String)"Configuration", (LogLevel)LogLevel.INFO);
        String essVersion = null;
        try {
            Field[] fieldlist;
            Class<?> essBase = Class.forName("com.essbase.api.session.IEssbase");
            for (Field fld : fieldlist = essBase.getDeclaredFields()) {
                String name = fld.getName();
                if (!"JAPI_VERSION".equals(name)) continue;
                essVersion = (String)fld.get(null);
                break;
            }
        }
        catch (Throwable e) {
            throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_UNSUPPORTED_VERSION, e, "NULL");
        }
        if (EssbaseUtil.isEmpty(essVersion)) {
            throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_UNSUPPORTED_VERSION, "null");
        }
        loggerDelta.log("Detected Essbase client version: " + essVersion);
        String deltaClassName = essVersion.startsWith("11.1.1") || essVersion.startsWith("9") ? "com.cognos.xqe.data.providers.olap.essbase.EssbaseApiDelta1111" : "com.cognos.xqe.data.providers.olap.essbase.EssbaseApiDelta1112";
        try {
            Class<?> deltaClass = Class.forName(deltaClassName);
            ESS_API_DELTA = (EssbaseApiDeltaFactory)deltaClass.newInstance();
        }
        catch (Exception e) {
            throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_UNSUPPORTED_VERSION, essVersion);
        }
    }
}

