/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.essbase;

import com.cognos.i18n.NumericFormat;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseFormatInfo;
import com.cognos.xqe.format.BooleanFormatPropertyValue;
import com.cognos.xqe.format.FormatPropertySet;
import com.cognos.xqe.format.FormatPropertyValue;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.format.FormatServiceUtils;
import com.cognos.xqe.format.NumberFormatPropertyValue;
import com.cognos.xqe.format.TextFormatPropertyValue;
import com.cognos.xqe.format.XQEFormatService;
import com.cognos.xqe.format.string.FormatParserType;
import com.cognos.xqe.format.string.IFormatInfo;
import com.cognos.xqe.format.string.IFormatParser;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELogger;
import java.util.Locale;
import java.util.StringTokenizer;

public class EssbaseCellFormatParser
implements IFormatParser {
    private static final String TILDE = "~";
    private static final String LETTER_K = "K";
    private static final String LETTER_M = "M";
    private static final int EXPONENT_SIZE = 3;
    private static final int NUMERIC_SIZE = 5;
    private static final int THOUSAND_SCALE = -3;
    private static final int MILLION_SCALE = -6;
    public static final String SCIENTIFIC_FORMAT_STR = "0E+000";
    public static final String PERCENT_PREFIX_FORMAT_STR = "%0";
    public static final String PERCENT_SUFFIX_FORMAT_STR = "0%";
    private static final char POUND_STR = '#';
    private static final char DOLLAR_STR = '$';
    public static final String EMPTY_STRING = "";
    private static final String PLAIN_FORMAT_STR = "0";
    private static final String SEPARATOR_GROUP_STR = "##0";
    private static final String GENERAL_STR = "General";
    private static final String LOGMSG_CANNOT_PARSE_STRING = "Could not parse String object ";
    private final FormatService mService;

    public EssbaseCellFormatParser(FormatService service) {
        this.mService = service;
    }

    public Object getFormatCacheKey(IFormatInfo formatInfo, Locale locale) {
        return FormatServiceUtils.generateFormatCacheKey((FormatParserType)FormatParserType.ESSBASE, (null != formatInfo ? 1 : 0) != 0, (IFormatInfo)formatInfo, (Locale)locale);
    }

    public FormatPropertySet parseFormat(IFormatInfo info, Locale locale) throws Exception {
        XQELogger spLogger = XQEFormatService.FSLOGGER_STRING_PARSING;
        if (null == info) {
            return null;
        }
        EssbaseFormatInfo essbaseInfo = (EssbaseFormatInfo)info;
        String essbaseFormatString = essbaseInfo.getFormatString();
        if (essbaseFormatString == null || EMPTY_STRING.equals(essbaseFormatString)) {
            spLogger.log(LogLevel.WARN, LOGMSG_CANNOT_PARSE_STRING);
            return null;
        }
        FormatPropertySet set = new FormatPropertySet(this.mService);
        if (GENERAL_STR.equals(essbaseFormatString)) {
            this.setGeneral(set);
        } else if (essbaseFormatString.charAt(0) == '$') {
            set.setFormatType("currencyFormat");
            NumericFormat currencyFormat = new NumericFormat(11, locale);
            essbaseFormatString = essbaseFormatString.substring(1, essbaseFormatString.length()).trim();
            this.parseNumeric(essbaseFormatString, set, currencyFormat);
        } else {
            set.setFormatType("numberFormat");
            NumericFormat numberFormat = new NumericFormat(locale);
            this.parseNumeric(essbaseFormatString, set, numberFormat);
        }
        return set;
    }

    private void parseNumeric(String essbaseFormatString, FormatPropertySet set, NumericFormat number) {
        int decimalSize = 0;
        String subformat = essbaseFormatString;
        StringTokenizer st = new StringTokenizer(essbaseFormatString, TILDE);
        if (st.hasMoreTokens()) {
            subformat = st.nextToken();
        }
        if (st.hasMoreTokens() && (decimalSize = Integer.parseInt(st.nextToken())) >= 0) {
            set.addPropertyValue((FormatPropertyValue)new NumberFormatPropertyValue("decimalSize", (double)decimalSize));
            char temp = number.getDecimalSeparator();
            set.addPropertyValue((FormatPropertyValue)new TextFormatPropertyValue("decimalDelimiter", String.valueOf(temp)));
        }
        if (SCIENTIFIC_FORMAT_STR.equals(subformat)) {
            set.setFormatType("numberFormat");
            set.addPropertyValue((FormatPropertyValue)new BooleanFormatPropertyValue("useScientific", true));
            set.addPropertyValue((FormatPropertyValue)new NumberFormatPropertyValue("exponentSize", 3.0));
        } else if (PERCENT_PREFIX_FORMAT_STR.equals(subformat) || PERCENT_SUFFIX_FORMAT_STR.equals(subformat)) {
            set.setFormatType("percentFormat");
        } else {
            StringBuilder resultStr = new StringBuilder(subformat);
            int kIndex = resultStr.indexOf(LETTER_K);
            if (kIndex != -1) {
                set.addPropertyValue((FormatPropertyValue)new NumberFormatPropertyValue("scale", -3.0));
                set.addPropertyValue((FormatPropertyValue)new TextFormatPropertyValue("unitOfMeasure", LETTER_K));
                resultStr.deleteCharAt(kIndex);
            } else {
                int mIndex = resultStr.indexOf(LETTER_M);
                if (mIndex != -1) {
                    set.addPropertyValue((FormatPropertyValue)new NumberFormatPropertyValue("scale", -6.0));
                    set.addPropertyValue((FormatPropertyValue)new TextFormatPropertyValue("unitOfMeasure", LETTER_M));
                    resultStr.deleteCharAt(mIndex);
                }
            }
            subformat = resultStr.toString();
            if (PLAIN_FORMAT_STR.equals(subformat)) {
                set.addPropertyValue((FormatPropertyValue)new BooleanFormatPropertyValue("useGrouping", false));
            } else if (subformat.charAt(0) == '#' && subformat.length() == 5) {
                if (SEPARATOR_GROUP_STR.equals(subformat.substring(2, subformat.length()))) {
                    set.addPropertyValue((FormatPropertyValue)new BooleanFormatPropertyValue("useGrouping", true));
                    char temp = number.getGroupingSeparator();
                    set.addPropertyValue((FormatPropertyValue)new TextFormatPropertyValue("groupDelimiter", String.valueOf(temp)));
                } else {
                    this.setGeneral(set);
                }
            } else {
                this.setGeneral(set);
            }
        }
    }

    private void setGeneral(FormatPropertySet set) {
        set.setFormatType("numberFormat");
        set.addPropertyValue((FormatPropertyValue)new BooleanFormatPropertyValue("useGrouping", false));
        set.addPropertyValue((FormatPropertyValue)new NumberFormatPropertyValue("decimalSize", 0.0));
    }
}

