/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.essbase;

import com.cognos.xqe.config.ConfigException;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQECCLConfigurationAdapter;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationEvent;
import com.cognos.xqe.config.XQEConfigurationListener;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.config.XQESubConfiguration;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.SingletonHelper;
import org.apache.commons.configuration.ConversionException;

public final class EssbaseConfig
implements XQEConfigurationListener {
    private static final String STR_LOAD_ERR = "Error loading XQEODP configuration: ";
    private boolean isRegistered = false;
    private static final String DEF_METADATA_UPDATE_MARKER_NAME = "CognosMetadataUpdateMarker";
    private String metadataUpdateMarkerName = "CognosMetadataUpdateMarker";
    private final XQELogger logger = XQELog.getLogger((ServiceEnumeration)ServiceEnumeration.XQEODP, (String)"Essbase", (String)"Configuration", (LogLevel)LogLevel.TRACE);
    private static SingletonHelper<EssbaseConfig> singletonHelper = new SingletonHelper<EssbaseConfig>(){

        protected EssbaseConfig newInstance() {
            return new EssbaseConfig();
        }

        protected void releaseImpl(EssbaseConfig theInstance) {
        }

        protected void initializeImpl(EssbaseConfig theInstance) {
        }
    };

    private EssbaseConfig() {
        if (this.logger.isOn()) {
            this.logger.log("Constructing EssbaseConfig");
        }
        this.reload();
    }

    public static EssbaseConfig instance() {
        return (EssbaseConfig)singletonHelper.getInstance();
    }

    public void configurationChanged(XQEConfigurationEvent e) {
        if (e.isBeforeUpdate() || e.getType() != 20) {
            return;
        }
        this.reload();
    }

    public void reload() {
        XQEConfiguration config;
        if (this.logger.isOn()) {
            this.logger.log("Loading EssbaseConfig");
        }
        if ((config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQEODP)) == null) {
            if (this.logger.isOn()) {
                this.logger.log("Constructing new XQEConfiguration instance for XQEODP");
            }
            try {
                config = XQECCLConfigurationAdapter.createDefaultConfigurationForService((ServiceEnumeration)ServiceEnumeration.XQEODP);
                XQEConfigurationManager.getInstance().add(ServiceEnumeration.XQEODP, config);
                config.registerConfigurationListener((XQEConfigurationListener)this);
                this.isRegistered = true;
            }
            catch (ConfigException e) {
                if (XQEMessageKeys.CFG_FileExistError == e.getMessageKey()) {
                    this.logger.log(LogLevel.WARN, STR_LOAD_ERR, (Throwable)e);
                } else {
                    this.logger.log(LogLevel.ERROR, STR_LOAD_ERR, (Throwable)e);
                }
                return;
            }
        } else if (!this.isRegistered) {
            config.registerConfigurationListener((XQEConfigurationListener)this);
            this.isRegistered = true;
        }
        XQESubConfiguration essProviderConfig = config.getConfigForXQEODPComponent("EssbaseODP");
        if (essProviderConfig != null) {
            essProviderConfig.next();
            try {
                this.metadataUpdateMarkerName = essProviderConfig.getString("metadataUpdateMarkerName[@value]", DEF_METADATA_UPDATE_MARKER_NAME);
            }
            catch (ConversionException e) {
                this.logger.log(LogLevel.ERROR, "Error converting value of configuration parameter \"metadataUpdateMarkerName\": ", (Throwable)e);
            }
        } else if (this.logger.isOn(LogLevel.WARN)) {
            this.logger.log(LogLevel.WARN, "Configuration for EssbaseODP provider not found.");
        }
    }

    public String getMetadataUpdateMarkerName() {
        return this.metadataUpdateMarkerName;
    }
}

