/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.essbase;

import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceConnection;
import com.cognos.xqe.data.model.IDataSourceConnectionSignon;
import com.cognos.xqe.data.model.IUsernamePasswordSignon;
import com.cognos.xqe.data.model.LogonFailureException;
import com.cognos.xqe.data.providers.ConnectionTestQueryArguments;
import com.cognos.xqe.data.providers.QueryArguments;
import com.cognos.xqe.data.providers.connection.ConnectionFactoryStatisticsDecorator;
import com.cognos.xqe.data.providers.connection.ConnectionFactoryTimeoutDecorator;
import com.cognos.xqe.data.providers.connection.ConnectionStringParser;
import com.cognos.xqe.data.providers.connection.parameters.AttributeRepresentationType;
import com.cognos.xqe.data.providers.connection.parameters.CatalogParameter;
import com.cognos.xqe.data.providers.connection.parameters.CubeParameter;
import com.cognos.xqe.data.providers.connection.parameters.NamespaceParameter;
import com.cognos.xqe.data.providers.connection.parameters.PasswordParameter;
import com.cognos.xqe.data.providers.connection.parameters.ServerParameter;
import com.cognos.xqe.data.providers.connection.parameters.UserIDParameter;
import com.cognos.xqe.data.providers.olap.IOLAPDataProvider;
import com.cognos.xqe.data.providers.olap.IOLAPMetadataProvider;
import com.cognos.xqe.data.providers.olap.MDXQueryArguments;
import com.cognos.xqe.data.providers.olap.MetadataQueryArguments;
import com.cognos.xqe.data.providers.olap.OLAPDataProviderBase;
import com.cognos.xqe.data.providers.olap.TracingOLAPMetadataProvider;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseConnection;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseMessageKeys;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseMetadataProvider;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseResultSet;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseRuntimeException;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseUtil;
import com.cognos.xqe.exception.XQEMessage;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metrics.MetricsService;
import com.cognos.xqe.pool.connection.ConnectionParameters;
import com.cognos.xqe.pool.connection.IConnectionFactory;
import com.cognos.xqe.pool.connection.IConnectionParameter;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.resultset.interfaces.ICubeResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.essbase.api.dataquery.IEssMdDataSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class EssbaseDataProvider
extends OLAPDataProviderBase {
    private final EssbaseConnectionFactory mEssbaseConnectionFactory;
    private final IConnectionFactory mConnectionFactory;
    private static final String STR_CATALOG = "catalog";
    private static final String STR_CUBE = "cube";
    private final String mPoolDisabled;
    private volatile String metadataUpdateMarkerValue = null;
    private static final String IS_BLACK_LISTED = " is black listed.";
    protected final XQELogger logConnect = XQELog.getLogger((ServiceEnumeration)ServiceEnumeration.XQEODP, (String)"Essbase", (String)"Connection", (LogLevel)LogLevel.INFO);

    public EssbaseDataProvider(String instanceName, Properties properties) {
        super(instanceName, properties);
        try {
            Class.forName("com.essbase.api.datasource.IEssCube");
        }
        catch (ClassNotFoundException e) {
            throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_DATASOURCE_CLIENT_NOT_FOUND);
        }
        this.mPoolDisabled = properties.getProperty("connectionPoolingDisabled");
        this.mEssbaseConnectionFactory = new EssbaseConnectionFactory();
        this.mConnectionFactory = ConnectionFactoryTimeoutDecorator.decorateIfNecessary((IConnectionFactory)new ConnectionFactoryStatisticsDecorator((IConnectionFactory)this.mEssbaseConnectionFactory, instanceName), (Properties)this.getProperties());
    }

    public IConnectionFactory getConnectionFactory() {
        return this.mConnectionFactory;
    }

    public IPooledConnection borrowConnection(ConnectionParameters connectionParameters, IExecutionEnvironment executionEnvironment) {
        String connectionMarker;
        IPooledConnection essbasePooledConnection = executionEnvironment.getConnectionPool().borrowConnection(this.getProviderInstanceName(), connectionParameters, this.selector, this.mConnectionFactory);
        EssbaseConnection connection = (EssbaseConnection)((Object)essbasePooledConnection.getConnection());
        if (!(EssbaseUtil.isEmpty(this.metadataUpdateMarkerValue) || EssbaseUtil.isEmpty(connectionMarker = connection.getMetadataUpdateMarkerValue()) || this.metadataUpdateMarkerValue.equals(connectionMarker))) {
            connection.reconnect();
        }
        connection.setPoolDisabled(this.mPoolDisabled);
        connection.getMetadataCache().setCancelManager(executionEnvironment.getCancelManager());
        return essbasePooledConnection;
    }

    public ICubeResultSet query(XDataContext xDataContext, MDXQueryArguments theQueryArguments) throws EssbaseRuntimeException {
        IPooledConnection pooledConnection = null;
        ExecutionEnvironment environment = (ExecutionEnvironment)xDataContext.getEnvironment();
        try {
            MetricsService.startCollectingMetric((RequestEnvironment)((RequestEnvironment)environment.getRequestEnvironment()), (String)"executeMDXPopulateHResult");
            ConnectionParameters connectionParameters = this.createConnectionParameters((IExecutionEnvironment)environment, theQueryArguments);
            pooledConnection = this.borrowConnection(connectionParameters, (IExecutionEnvironment)environment);
            EssbaseResultSet result = this.executeMDX(pooledConnection, xDataContext, theQueryArguments, connectionParameters);
            pooledConnection = null;
            EssbaseResultSet essbaseResultSet = result;
            return essbaseResultSet;
        }
        catch (LogonFailureException e) {
            if (e.getDataSource() == null) {
                e.setDataSource(theQueryArguments.getDataSource());
            }
            IDataSource dataSource = theQueryArguments.getDataSource();
            IDataSourceConnection connection = dataSource.getDataSourceConnection();
            connection.invalidateResolvedSignon();
            throw e;
        }
        catch (Throwable e) {
            throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_EXECUTE_ERROR, e);
        }
        finally {
            if (null != pooledConnection) {
                EssbaseConnection essConnection = (EssbaseConnection)((Object)pooledConnection.getConnection());
                if (null != essConnection && !essConnection.isValid()) {
                    pooledConnection.setNotReusable();
                }
                pooledConnection.returnConnection();
            }
        }
    }

    public ConnectionParameters createConnectionParameters(IExecutionEnvironment env, MDXQueryArguments queryArgs) {
        MDXQuery mdxQuery = queryArgs.getMDXQuery();
        ICube icube = mdxQuery.getReferencedCube();
        return this.createConnectionParms((QueryArguments)queryArgs, icube, null, null);
    }

    public EssbaseResultSet executeMDX(IPooledConnection pooledConnection, XDataContext xDataContext, MDXQueryArguments theQueryArguments, ConnectionParameters connectionParameters) {
        EssbaseConnection essConnection = (EssbaseConnection)((Object)pooledConnection.getConnection());
        String catalogName = (String)connectionParameters.valueOf(CatalogParameter.class, String.class);
        String cubeName = (String)connectionParameters.valueOf(CubeParameter.class, String.class);
        MDXQuery mdxQuery = theQueryArguments.getMDXQuery();
        String mdxString = mdxQuery.getMDX();
        while (true) {
            try {
                IEssMdDataSet mddata = essConnection.getMdDataSet(catalogName, cubeName, mdxString);
                return new EssbaseResultSet(this, pooledConnection, xDataContext, theQueryArguments, mddata);
            }
            catch (EssbaseRuntimeException e) {
                if (EssbaseUtil.isLoggedOutError(e)) {
                    essConnection.reconnect();
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    public List<XQEMessage> testConnection(ConnectionTestQueryArguments theQueryArguments) {
        List<XQEMessage> connectionDetails = null;
        EssbaseConnection essbaseConnection = null;
        ConnectionParameters parameters = this.createConnectionParms((QueryArguments)theQueryArguments, null, null, null);
        try {
            essbaseConnection = (EssbaseConnection)((Object)this.mEssbaseConnectionFactory.createConnection(parameters));
            connectionDetails = essbaseConnection.getConnectionDetails();
        }
        catch (LogonFailureException e) {
            if (e.getDataSource() == null) {
                e.setDataSource(theQueryArguments.getDataSource());
            }
            IDataSource dataSource = theQueryArguments.getDataSource();
            IDataSourceConnection connection = dataSource.getDataSourceConnection();
            connection.invalidateResolvedSignon();
            throw e;
        }
        finally {
            if (null != essbaseConnection) {
                this.mEssbaseConnectionFactory.destroyConnection(essbaseConnection);
            }
        }
        return connectionDetails;
    }

    protected ConnectionParameters createConnectionParms(QueryArguments theQueryArguments, ICube icube, String theCatalogName, String theCubeName) {
        String attributeRepresentation;
        IDataSource dataSource = theQueryArguments.getDataSource();
        Map metadataProperties = dataSource.getMetadataProperties();
        IDataSourceConnection connection = dataSource.getDataSourceConnection();
        String connectionString = connection.getConnectionString(null);
        IDataSourceConnectionSignon signon = connection.getSignon();
        final ConnectionParameters connectionParams = new ConnectionParameters();
        ConnectionStringParser.parse((String)connectionString, (ConnectionStringParser.TokenHandler)new ConnectionStringParser.TokenHandler(){

            public void onKeyValueToken(String key, String value) {
                if ("SERVER".equals(key)) {
                    connectionParams.put((IConnectionParameter)new ServerParameter(value));
                } else if ("CATALOG".equals(key)) {
                    connectionParams.put((IConnectionParameter)new CatalogParameter(value));
                } else if ("CUBE".equals(key)) {
                    connectionParams.put((IConnectionParameter)new CubeParameter(value));
                }
            }

            public void onSimpleToken(String value) {
            }
        });
        String catalogName = (String)connectionParams.valueOf(CatalogParameter.class, String.class);
        if (theCatalogName != null) {
            if (!theCatalogName.equals(catalogName)) {
                connectionParams.put((IConnectionParameter)new CatalogParameter(theCatalogName));
            }
        } else if (catalogName == null && (catalogName = icube != null ? icube.getCatalog().getName() : (String)metadataProperties.get(STR_CATALOG)) != null) {
            connectionParams.put((IConnectionParameter)new CatalogParameter(catalogName));
        }
        String cubeName = (String)connectionParams.valueOf(CubeParameter.class, String.class);
        if (theCubeName != null) {
            if (!theCubeName.equals(cubeName)) {
                connectionParams.put((IConnectionParameter)new CubeParameter(theCubeName));
            }
        } else if (cubeName == null && (cubeName = icube != null ? icube.getName() : (String)metadataProperties.get(STR_CUBE)) != null) {
            connectionParams.put((IConnectionParameter)new CubeParameter(cubeName));
        }
        if (signon != null && signon.getType() == IDataSourceConnectionSignon.SignonType.USERNAME_PASSWORD) {
            IUsernamePasswordSignon userPwdSignon = (IUsernamePasswordSignon)signon;
            connectionParams.put((IConnectionParameter)new UserIDParameter(userPwdSignon.getUserName()));
            connectionParams.put((IConnectionParameter)new PasswordParameter(userPwdSignon.getPassword()));
            connectionParams.put((IConnectionParameter)new NamespaceParameter(connection.getNamespace()));
        }
        if ((attributeRepresentation = (String)metadataProperties.get("attribute")) != null && "dimension".equals(attributeRepresentation)) {
            connectionParams.put((IConnectionParameter)new AttributeRepresentationType("Dimension"));
        } else {
            connectionParams.put((IConnectionParameter)new AttributeRepresentationType("Property"));
        }
        return connectionParams;
    }

    public IOLAPMetadataProvider getMetadataProvider(MetadataQueryArguments theQueryArguments) throws LogonFailureException, EssbaseRuntimeException {
        ConnectionParameters defaultConnectionParameters = this.createConnectionParms((QueryArguments)theQueryArguments, null, null, null);
        try {
            EssbaseMetadataProvider provider = new EssbaseMetadataProvider(this, theQueryArguments, defaultConnectionParameters);
            provider = new TracingOLAPMetadataProvider((IOLAPMetadataProvider)provider, "Essbase");
            return provider;
        }
        catch (LogonFailureException e) {
            if (e.getDataSource() == null) {
                e.setDataSource(theQueryArguments.getDataSource());
            }
            IDataSource dataSource = theQueryArguments.getDataSource();
            IDataSourceConnection connection = dataSource.getDataSourceConnection();
            connection.invalidateResolvedSignon();
            throw e;
        }
    }

    public void releaseImpl() {
    }

    public void setMetadataUpdateMarkerValue(String updateMarker) {
        this.metadataUpdateMarkerValue = updateMarker;
    }

    private final class EssbaseConnectionFactory
    implements IConnectionFactory {
        private EssbaseConnectionFactory() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object createConnection(ConnectionParameters connectionParameters) {
            EssbaseConnection connection = null;
            try {
                if (EssbaseDataProvider.this.logConnect.isOn()) {
                    EssbaseDataProvider.this.logConnect.log("EssbaseConnectionFactory.createConnection: Attempting to create a new connection with parameters " + connectionParameters.toString());
                }
                connection = new EssbaseConnection((IOLAPDataProvider)EssbaseDataProvider.this, connectionParameters);
            }
            finally {
                if (null == connection) {
                    if (EssbaseDataProvider.this.logConnect.isOn()) {
                        EssbaseDataProvider.this.logConnect.log("EssbaseConnectionFactory.createConnection: failed. Parameters " + connectionParameters.toString());
                    }
                } else {
                    List<XQEMessage> blackList;
                    if (EssbaseDataProvider.this.logConnect.isOn()) {
                        EssbaseDataProvider.this.logConnect.log("EssbaseConnectionFactory.createConnection: passed. Parameters " + connectionParameters.toString());
                    }
                    if (!(blackList = connection.getConnectionBlackListDetails()).isEmpty()) {
                        this.destroyConnection(connection);
                        connection = null;
                        XQEMessage message = blackList.get(0);
                        if (XQEMessageKeys.DS_DriverBlacklistedTestConnectionUI == message.getMessageKey()) {
                            EssbaseDataProvider.this.logConnect.log("EssbaseConnectionFactory.createConnection: The driver version " + message.getParams()[0] + EssbaseDataProvider.IS_BLACK_LISTED);
                            throw new XQERuntimeException(XQEMessageKeys.DS_DriverBlacklistedTestConnectionUI, message.getParams()[0], message.getParams()[1]);
                        }
                        if (XQEMessageKeys.DS_ServerBlacklistedTestConnectionUI2 == message.getMessageKey()) {
                            EssbaseDataProvider.this.logConnect.log("EssbaseConnectionFactory.createConnection: The server version " + message.getParams()[1] + EssbaseDataProvider.IS_BLACK_LISTED);
                            throw new XQERuntimeException(XQEMessageKeys.DS_ServerBlacklistedTestConnectionUI2, message.getParams()[0], message.getParams()[1]);
                        }
                        throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalError_INTERNAL);
                    }
                }
            }
            return connection;
        }

        public void destroyConnection(IPooledConnection pooledConnection) {
            ((EssbaseConnection)((Object)pooledConnection.getConnection())).disconnect();
        }

        private void destroyConnection(EssbaseConnection connection) {
            connection.disconnect();
        }
    }
}

