/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.essbase;

import com.cognos.xqe.data.providers.olap.essbase.EssbaseConnection;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseMessageKeys;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseRuntimeException;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseWrappers;
import com.cognos.xqe.util.LocaleConverter;
import com.cognos.xqe.util.LocalizedString;
import com.essbase.api.base.IEssIterator;
import com.essbase.api.metadata.IEssMember;
import com.essbase.api.metadata.IEssMemberSelection;
import java.util.Locale;
import java.util.Map;

public class EssbaseLocalizedString {
    private final Locale runLocale;
    private final String runLocaleStr;
    private final String runLanguage;

    EssbaseLocalizedString(Locale theRunLocale) {
        this.runLocale = theRunLocale;
        this.runLocaleStr = LocaleConverter.toString((Locale)theRunLocale);
        this.runLanguage = LocaleConverter.getLanguage((Locale)theRunLocale);
    }

    public LocalizedString getLocalizedCaptions(EssbaseConnection connection, String memberName, String dimensionName, IEssMember essMember, Map<String, String> aliasTableNames, Map<String, String> cachedAliasNames) {
        EssbaseWrappers essbaseAPI = connection.getEssAPI();
        if (aliasTableNames == null) {
            return new LocalizedString(this.runLocaleStr, memberName);
        }
        boolean allAliasesExist = false;
        String aliasTableNameRunLocale = aliasTableNames.get(this.runLanguage);
        if (aliasTableNameRunLocale != null && cachedAliasNames.containsKey(aliasTableNameRunLocale)) {
            allAliasesExist = true;
        }
        if (allAliasesExist) {
            for (String name : aliasTableNames.values()) {
                if (cachedAliasNames.containsKey(name)) continue;
                allAliasesExist = false;
                break;
            }
        }
        String captionName = null;
        String aliasTableName = null;
        if (allAliasesExist) {
            captionName = cachedAliasNames.get(aliasTableNameRunLocale);
            LocalizedString localizedCaption = new LocalizedString(this.runLocaleStr, captionName);
            for (Map.Entry<String, String> entry : aliasTableNames.entrySet()) {
                String locale = entry.getKey();
                if (locale.equals(this.runLanguage)) continue;
                aliasTableName = entry.getValue();
                captionName = cachedAliasNames.get(aliasTableName);
                localizedCaption.put(locale, captionName);
            }
            return localizedCaption;
        }
        IEssMember essMbr = essMember;
        IEssMemberSelection mbrSel = null;
        if (essMbr == null) {
            mbrSel = connection.openMbrSel();
            essbaseAPI.executeQuery(mbrSel, memberName, 11, dimensionName, memberName, "");
            IEssIterator essMembers = essbaseAPI.getMembers(mbrSel);
            if (essbaseAPI.getCount(essMembers) < 1) {
                throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_INVALID_MEMBER_NAME, memberName);
            }
            essMbr = (IEssMember)essbaseAPI.getAt(essMembers, 0);
        }
        captionName = this.getLocalizedCaption(connection, essMbr, aliasTableNameRunLocale);
        if (aliasTableNameRunLocale != null && !cachedAliasNames.containsKey(captionName)) {
            cachedAliasNames.put(aliasTableNameRunLocale, captionName);
        }
        LocalizedString localizedCaption = new LocalizedString(this.runLocaleStr, captionName);
        for (Map.Entry<String, String> entry : aliasTableNames.entrySet()) {
            String locale = entry.getKey();
            if (locale.equals(this.runLanguage)) continue;
            aliasTableName = entry.getValue();
            captionName = this.getLocalizedCaption(connection, essMbr, aliasTableName);
            localizedCaption.put(locale, captionName);
            if (aliasTableName == null) continue;
            cachedAliasNames.put(aliasTableName, captionName);
        }
        if (mbrSel != null) {
            connection.releaseMbrSel(mbrSel);
        }
        return localizedCaption;
    }

    private String getLocalizedCaption(EssbaseConnection connection, IEssMember essMember, String aliasTableName) {
        String captionName;
        EssbaseWrappers essbaseAPI = connection.getEssAPI();
        if (aliasTableName != null && (captionName = essbaseAPI.getAlias(essMember, aliasTableName)) != null) {
            return captionName;
        }
        return essbaseAPI.getMemberName(essMember);
    }

    public Locale getRunLocale() {
        return this.runLocale;
    }

    public String getRunLocaleStr() {
        return this.runLocaleStr;
    }

    public String getRunLocaleLanguage() {
        return this.runLanguage;
    }
}

